/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.examples.toolkits.me4se;

import java.io.File;
import java.io.FilenameFilter;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.mtj.core.MTJCore;
import org.eclipse.mtj.core.sdk.device.IDevice;
import org.eclipse.mtj.core.sdk.device.IDeviceClasspath;
import org.eclipse.mtj.core.sdk.device.ILibrary;
import org.eclipse.mtj.core.sdk.device.ILibraryImporter;
import org.eclipse.mtj.core.sdk.device.midp.IMIDPAPI;
import org.eclipse.mtj.core.sdk.device.midp.IMIDPDevice;
import org.eclipse.mtj.core.sdk.device.midp.IMIDPLibrary;
import org.eclipse.mtj.core.sdk.device.midp.MIDPAPIType;
import org.eclipse.mtj.core.symbol.ISymbolSet;
import org.eclipse.mtj.examples.toolkits.Activator;
import org.eclipse.mtj.examples.toolkits.me4se.ME4SEDevice;
import org.eclipse.mtj.examples.toolkits.me4se.Messages;
import org.eclipse.mtj.internal.core.sdk.device.JavaEmulatorDeviceImporter;
import org.eclipse.mtj.internal.core.sdk.device.JavaEmulatorDeviceProperties;
import org.eclipse.mtj.internal.core.util.ReplaceableParametersProcessor;
import org.eclipse.mtj.internal.core.util.log.MTJLogger;
import org.osgi.framework.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ME4SEDeviceImporter
extends JavaEmulatorDeviceImporter {
    private static final String EMULATOR_JAR_PREFIX = "me4se";
    private static final String EMULATOR_JAR_SUFFIX = ".jar";
    private static final String PROPS_FILE = "me4se.properties";

    public List<IDevice> importDevices(File file, IProgressMonitor iProgressMonitor) {
        ArrayList<IMIDPDevice> arrayList = null;
        try {
            IMIDPDevice iMIDPDevice;
            File[] fileArray = file.listFiles(new FilenameFilter(){

                public boolean accept(File file, String string) {
                    return string.startsWith(ME4SEDeviceImporter.EMULATOR_JAR_PREFIX) && string.endsWith(ME4SEDeviceImporter.EMULATOR_JAR_SUFFIX);
                }
            });
            if (fileArray != null && fileArray.length > 0 && (iMIDPDevice = this.createDevice(fileArray[0])) != null) {
                arrayList = new ArrayList<IMIDPDevice>(1);
                arrayList.add(iMIDPDevice);
            }
        }
        catch (Exception exception) {
            MTJLogger.log((int)2, (String)Messages.ME4SEDeviceImporter_importing_error, (Throwable)exception);
        }
        return arrayList;
    }

    private void addDeviceLibraries(File file, IDeviceClasspath iDeviceClasspath, ILibraryImporter iLibraryImporter) {
        String[] stringArray;
        String string = this.getDeviceProperties().getProperty(JavaEmulatorDeviceProperties.CLASSPATH.toString(), "");
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("me4sejar", file.toString());
        string = ReplaceableParametersProcessor.processReplaceableValues((String)string, hashMap);
        String[] stringArray2 = stringArray = string.split(";");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string2 = stringArray2[n2];
            IMIDPLibrary iMIDPLibrary = (IMIDPLibrary)iLibraryImporter.createLibraryFor(new File(string2));
            IMIDPAPI iMIDPAPI = iMIDPLibrary.getAPI(MIDPAPIType.CONFIGURATION);
            if (iMIDPAPI != null) {
                iMIDPAPI.setVersion(new Version("1.1"));
            }
            if ((iMIDPAPI = iMIDPLibrary.getAPI(MIDPAPIType.PROFILE)) != null) {
                iMIDPAPI.setVersion(new Version("2.0"));
            }
            iDeviceClasspath.addEntry((ILibrary)iMIDPLibrary);
            ++n2;
        }
    }

    private IMIDPDevice createDevice(File file) {
        ME4SEDevice mE4SEDevice = new ME4SEDevice();
        mE4SEDevice.setBundle(Activator.getDefault().getBundle().getSymbolicName());
        mE4SEDevice.setClasspath(this.getDeviceClasspath(file));
        mE4SEDevice.setDebugServer(this.isDebugServer());
        mE4SEDevice.setDescription("ME4SE Device");
        mE4SEDevice.setDeviceProperties(new Properties());
        mE4SEDevice.setGroupName("ME4SE");
        mE4SEDevice.setName("ME4SE");
        mE4SEDevice.setPreverifier(this.getPreverifier(file));
        mE4SEDevice.setProtectionDomains(new String[0]);
        mE4SEDevice.setLaunchCommandTemplate(this.getLaunchCommand());
        mE4SEDevice.setJarFile(file);
        ISymbolSet iSymbolSet = MTJCore.getSymbolSetFactory().createSymbolSetFromDevice((IDevice)mE4SEDevice);
        ISymbolSet iSymbolSet2 = MTJCore.getSymbolSetFactory().createSymbolSetFromProperties(this.deviceProperties);
        iSymbolSet.add(iSymbolSet2.getSymbols());
        iSymbolSet.setName(mE4SEDevice.getName());
        mE4SEDevice.setSymbolSet(iSymbolSet);
        return mE4SEDevice;
    }

    private IDeviceClasspath getDeviceClasspath(File file) {
        IDeviceClasspath iDeviceClasspath = MTJCore.createNewDeviceClasspath();
        this.addDeviceLibraries(file, iDeviceClasspath, MTJCore.getLibraryImporter((String)"org.eclipse.mtj.libraryimporter.uei"));
        return iDeviceClasspath;
    }

    protected URL getDevicePropertiesURL() {
        return Activator.getDefault().getBundle().getEntry(PROPS_FILE);
    }
}

