/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.forms.parts;

import org.eclipse.mtj.internal.ui.forms.parts.IFormEntryListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class FormEntry {
    public static final int F_DEFAULT_TEXT_WIDTH_HINT = 100;
    private Control fLabel;
    private Text fText;
    private Button fBrowse;
    private String fValue = "";
    private boolean fDirty;
    private IFormEntryListener fListener;
    boolean fIgnoreModify = false;

    public FormEntry(Composite composite, FormToolkit formToolkit, String string, int n) {
        this.createControl(composite, formToolkit, string, n, null, false, 0, 0);
    }

    public FormEntry(Composite composite, FormToolkit formToolkit, String string, int n, int n2) {
        this.createControl(composite, formToolkit, string, 4, null, false, n, n2);
    }

    public FormEntry(Composite composite, FormToolkit formToolkit, String string, String string2, boolean bl) {
        this(composite, formToolkit, string, string2, bl, 0);
    }

    public FormEntry(Composite composite, FormToolkit formToolkit, String string, String string2, boolean bl, int n) {
        this.createControl(composite, formToolkit, string, 4, string2, bl, n, 0);
    }

    public void cancelEdit() {
        this.fDirty = false;
    }

    public void commit() {
        if (this.fDirty) {
            this.fValue = this.fText.getText();
            if (this.fListener != null) {
                this.fListener.textValueChanged(this);
            }
        }
        this.fDirty = false;
    }

    public Button getButton() {
        return this.fBrowse;
    }

    public Control getLabel() {
        return this.fLabel;
    }

    public Text getText() {
        return this.fText;
    }

    public String getValue() {
        return this.fValue.trim();
    }

    public boolean isDirty() {
        return this.fDirty;
    }

    public void setEditable(boolean bl) {
        this.fText.setEditable(bl);
        if (this.fLabel instanceof Hyperlink) {
            ((Hyperlink)this.fLabel).setUnderlined(bl);
        }
        if (this.fBrowse != null) {
            this.fBrowse.setEnabled(bl);
        }
    }

    public void setFormEntryListener(IFormEntryListener iFormEntryListener) {
        if (this.fLabel != null && this.fLabel instanceof Hyperlink) {
            if (this.fListener != null) {
                ((Hyperlink)this.fLabel).removeHyperlinkListener((IHyperlinkListener)this.fListener);
            }
            if (iFormEntryListener != null) {
                ((Hyperlink)this.fLabel).addHyperlinkListener((IHyperlinkListener)iFormEntryListener);
            }
        }
        this.fListener = iFormEntryListener;
    }

    public void setTextWidthHint(int n) {
        Object object = this.getText().getLayoutData();
        if (object == null) {
            return;
        }
        if (object instanceof GridData) {
            ((GridData)object).widthHint = n;
        } else if (object instanceof TableWrapData) {
            ((TableWrapData)object).maxWidth = n;
        }
    }

    public void setValue(String string) {
        if (this.fText != null) {
            this.fText.setText(string != null ? string : "");
        }
        this.fValue = string != null ? string : "";
    }

    public void setValue(String string, boolean bl) {
        this.fIgnoreModify = bl;
        this.setValue(string);
        this.fIgnoreModify = false;
    }

    public void setVisible(boolean bl) {
        if (this.fLabel != null) {
            this.fLabel.setVisible(bl);
        }
        if (this.fText != null) {
            this.fText.setVisible(bl);
        }
        if (this.fBrowse != null) {
            this.fBrowse.setVisible(bl);
        }
    }

    private void addListeners() {
        this.fText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                FormEntry.this.keyReleaseOccured(keyEvent);
            }
        });
        this.fText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                FormEntry.this.editOccured(modifyEvent);
            }
        });
        this.fText.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                if (FormEntry.this.fListener != null) {
                    FormEntry.this.fListener.focusGained(FormEntry.this);
                }
            }

            public void focusLost(FocusEvent focusEvent) {
                if (FormEntry.this.fDirty) {
                    FormEntry.this.commit();
                }
            }
        });
    }

    private void createControl(Composite composite, FormToolkit formToolkit, String string, int n, String string2, boolean bl, int n2, int n3) {
        if (bl) {
            Hyperlink hyperlink = formToolkit.createHyperlink(composite, string, 0);
            this.fLabel = hyperlink;
        } else if (string != null) {
            this.fLabel = formToolkit.createLabel(composite, string);
            this.fLabel.setForeground(formToolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        }
        this.fText = formToolkit.createText(composite, "", n);
        this.addListeners();
        if (string2 != null) {
            this.fBrowse = formToolkit.createButton(composite, string2, 8);
            this.fBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    if (FormEntry.this.fListener != null) {
                        FormEntry.this.fListener.browseButtonSelected(FormEntry.this);
                    }
                }
            });
        }
        this.fillIntoGrid(composite, n2, n3);
        this.setTextWidthHint(100);
    }

    private void editOccured(ModifyEvent modifyEvent) {
        if (this.fIgnoreModify) {
            return;
        }
        this.fDirty = true;
        if (this.fListener != null) {
            this.fListener.textDirty(this);
        }
    }

    private void fillIntoGrid(Composite composite, int n, int n2) {
        Layout layout = composite.getLayout();
        if (layout instanceof GridLayout) {
            GridData gridData;
            int n3;
            int n4 = ((GridLayout)layout).numColumns;
            if (n2 > 0) {
                n3 = n2;
            } else {
                int n5 = n3 = this.fBrowse != null ? n4 - 2 : n4 - 1;
            }
            if (this.fLabel != null) {
                gridData = new GridData(4);
                gridData.horizontalIndent = n;
                this.fLabel.setLayoutData((Object)gridData);
            }
            gridData = new GridData(256);
            gridData.horizontalSpan = n3;
            if (this.fLabel != null) {
                gridData.horizontalIndent = 3;
            }
            gridData.grabExcessHorizontalSpace = n3 == 1;
            gridData.widthHint = 10;
            this.fText.setLayoutData((Object)gridData);
            if (this.fBrowse != null) {
                gridData = new GridData(4);
                this.fBrowse.setLayoutData((Object)gridData);
            }
        } else if (layout instanceof TableWrapLayout) {
            TableWrapData tableWrapData;
            int n6;
            int n7 = ((TableWrapLayout)layout).numColumns;
            if (n2 > 0) {
                n6 = n2;
            } else {
                int n8 = n6 = this.fBrowse != null ? n7 - 2 : n7 - 1;
            }
            if (this.fLabel != null) {
                tableWrapData = new TableWrapData();
                tableWrapData.valign = 32;
                tableWrapData.indent = n;
                this.fLabel.setLayoutData((Object)tableWrapData);
            }
            tableWrapData = new TableWrapData(128);
            tableWrapData.colspan = n6;
            if (this.fLabel != null) {
                tableWrapData.indent = 3;
            }
            tableWrapData.grabHorizontal = n6 == 1;
            tableWrapData.valign = 32;
            this.fText.setLayoutData((Object)tableWrapData);
            if (this.fBrowse != null) {
                tableWrapData = new TableWrapData(128);
                tableWrapData.valign = 32;
                this.fBrowse.setLayoutData((Object)tableWrapData);
            }
        }
    }

    private void keyReleaseOccured(KeyEvent keyEvent) {
        if (keyEvent.character == '\r') {
            if (this.fDirty) {
                this.commit();
            }
        } else if (keyEvent.character == '\u001b') {
            if (!this.fValue.equals(this.fText.getText())) {
                this.fText.setText(this.fValue != null ? this.fValue : "");
            }
            this.fDirty = false;
        }
        if (this.fListener != null) {
            this.fListener.selectionChanged(this);
        }
    }
}

