/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.sdk.device;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.mtj.core.MTJCore;
import org.eclipse.mtj.core.build.preverifier.IPreverifier;
import org.eclipse.mtj.core.persistence.IPersistenceProvider;
import org.eclipse.mtj.core.persistence.PersistenceException;
import org.eclipse.mtj.core.sdk.device.IDevice;
import org.eclipse.mtj.core.sdk.device.IDeviceRegistry;
import org.eclipse.mtj.core.sdk.device.IDeviceRegistryListener;
import org.eclipse.mtj.core.sdk.device.IManagedDevice;
import org.eclipse.mtj.internal.core.persistence.XMLPersistenceProvider;
import org.eclipse.mtj.internal.core.sdk.device.ImportedDeviceRegistry;
import org.eclipse.mtj.internal.core.sdk.device.ManagedDeviceRegistry;
import org.eclipse.mtj.internal.core.util.migration.DeviceRegistryMigration;
import org.eclipse.mtj.internal.core.util.xml.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeviceRegistry
implements IDeviceRegistry {
    private static IDeviceRegistry instance = null;
    private ManagedDeviceRegistry managedDeviceRegistry = new ManagedDeviceRegistry();
    private ImportedDeviceRegistry importedDeviceRegistry = new ImportedDeviceRegistry();
    private IDevice defaultDevice;
    private IPreverifier defaultPreverifier;
    private boolean fireDeviceAddedEvent;
    private ArrayList<IDeviceRegistryListener> listenerList = new ArrayList();

    public static synchronized IDeviceRegistry getInstance() {
        if (instance == null) {
            instance = new DeviceRegistry();
        }
        return instance;
    }

    protected DeviceRegistry() {
        try {
            this.load();
        }
        catch (PersistenceException persistenceException) {
            persistenceException.printStackTrace();
        }
    }

    @Override
    public void addDevice(IDevice iDevice) throws IllegalArgumentException, PersistenceException {
        if (iDevice instanceof IManagedDevice) {
            return;
        }
        this.importedDeviceRegistry.addDevice(iDevice);
        if (this.fireDeviceAddedEvent) {
            this.fireDeviceAddedEvent(iDevice);
        }
    }

    @Override
    public void addRegistryListener(IDeviceRegistryListener iDeviceRegistryListener) {
        this.listenerList.add(iDeviceRegistryListener);
    }

    @Override
    public void clear() throws PersistenceException {
        this.importedDeviceRegistry.clear();
    }

    @Override
    public void enableDeviceAddedEvent(boolean bl) {
        this.fireDeviceAddedEvent = bl;
    }

    @Override
    public List<IDevice> getAllDevices() throws PersistenceException {
        ArrayList<IDevice> arrayList = new ArrayList<IDevice>(this.managedDeviceRegistry.getAllDevices());
        arrayList.addAll(this.importedDeviceRegistry.getAllDevices());
        return arrayList;
    }

    @Override
    public IDevice getDefaultDevice() {
        return this.defaultDevice;
    }

    @Override
    public IPreverifier getDefaultPreferifier() {
        return this.defaultPreverifier;
    }

    @Override
    public IDevice getDevice(String string, String string2) throws PersistenceException {
        IDevice iDevice = this.managedDeviceRegistry.getDevice(string, string2);
        if (iDevice == null) {
            iDevice = this.importedDeviceRegistry.getDevice(string, string2);
        }
        return iDevice;
    }

    @Override
    public int getDeviceCount() throws PersistenceException {
        return this.managedDeviceRegistry.getDeviceCount() + this.importedDeviceRegistry.getDeviceCount();
    }

    @Override
    public List<IDevice> getDevices(String string) throws PersistenceException {
        List<IDevice> list = this.managedDeviceRegistry.getDevices(string);
        if (list == null) {
            list = this.importedDeviceRegistry.getDevices(string);
        }
        return list;
    }

    @Override
    public List<String> getSDKNames() throws PersistenceException {
        ArrayList<String> arrayList = new ArrayList<String>(this.managedDeviceRegistry.getSDKNames());
        arrayList.addAll(this.importedDeviceRegistry.getSDKNames());
        return arrayList;
    }

    @Override
    public boolean isDeviceAddedEventEnabled() {
        return this.fireDeviceAddedEvent;
    }

    @Override
    public void load() throws PersistenceException {
        this.load(false);
    }

    private void load(boolean bl) throws PersistenceException {
        XMLPersistenceProvider xMLPersistenceProvider = DeviceRegistry.createPersistenceProvider();
        if (xMLPersistenceProvider != null) {
            this.loadUsing(xMLPersistenceProvider);
            this.importedDeviceRegistry.loadUsing(xMLPersistenceProvider, bl);
        }
    }

    @Override
    public void loadUsing(IPersistenceProvider iPersistenceProvider) throws PersistenceException {
        String string;
        String string2;
        try {
            this.enableDeviceAddedEvent(false);
            string2 = iPersistenceProvider.loadString("defaultDeviceSdkName");
            string = iPersistenceProvider.loadString("defaultDevicename");
            this.defaultPreverifier = (IPreverifier)iPersistenceProvider.loadPersistable("defaultPreverifier");
        }
        finally {
            this.enableDeviceAddedEvent(true);
        }
        this.defaultDevice = this.getDevice(string2, string);
    }

    public void updateReferences() throws PersistenceException, TransformerException, IOException {
        this.load(true);
        this.store();
    }

    @Override
    public synchronized void removeDevice(IDevice iDevice) throws PersistenceException {
        if (!(iDevice instanceof IManagedDevice)) {
            this.importedDeviceRegistry.removeDevice(iDevice);
            this.fireDeviceRemovedEvent(iDevice);
            if (iDevice.equals(this.defaultDevice)) {
                this.defaultDevice = null;
            }
        }
    }

    @Override
    public void removeRegistryListener(IDeviceRegistryListener iDeviceRegistryListener) {
        this.listenerList.remove(iDeviceRegistryListener);
    }

    @Override
    public void setDefaultDevice(IDevice iDevice) {
        this.defaultDevice = iDevice;
    }

    @Override
    public void setDefaultPreverifer(IPreverifier iPreverifier) {
        this.defaultPreverifier = iPreverifier;
    }

    @Override
    public void store() throws PersistenceException, TransformerException, IOException {
        XMLPersistenceProvider xMLPersistenceProvider = new XMLPersistenceProvider("deviceRegistry");
        this.storeUsing(xMLPersistenceProvider);
        XMLUtils.writeDocument(DeviceRegistry.getComponentStoreFile(), xMLPersistenceProvider.getDocument());
    }

    @Override
    public void storeUsing(IPersistenceProvider iPersistenceProvider) throws PersistenceException {
        if (this.defaultPreverifier != null) {
            iPersistenceProvider.storePersistable("defaultPreverifier", this.defaultPreverifier);
        }
        if (this.defaultDevice != null) {
            String string = this.defaultDevice.getSDKName();
            String string2 = this.defaultDevice.getName();
            if (string != null && string2 != null) {
                iPersistenceProvider.storeString("defaultDeviceSdkName", string);
                iPersistenceProvider.storeString("defaultDevicename", string2);
            }
        }
        this.importedDeviceRegistry.storeUsing(iPersistenceProvider);
    }

    private void fireDeviceAddedEvent(IDevice iDevice) {
        for (IDeviceRegistryListener iDeviceRegistryListener : this.listenerList) {
            iDeviceRegistryListener.deviceAdded(iDevice);
        }
    }

    private void fireDeviceRemovedEvent(IDevice iDevice) {
        for (IDeviceRegistryListener iDeviceRegistryListener : this.listenerList) {
            iDeviceRegistryListener.deviceRemoved(iDevice);
        }
    }

    static File getComponentStoreFile() {
        IPath iPath = MTJCore.getMTJCore().getStateLocation();
        IPath iPath2 = iPath.append("devices.xml");
        return iPath2.toFile();
    }

    public List<String> getInvalidSDKNames() {
        return this.importedDeviceRegistry.getInvalidSDKNames();
    }

    static XMLPersistenceProvider createPersistenceProvider() throws PersistenceException {
        File file = DeviceRegistry.getComponentStoreFile();
        XMLPersistenceProvider xMLPersistenceProvider = null;
        if (file.exists()) {
            Document document;
            block11: {
                block10: {
                    document = XMLUtils.readDocument(file);
                    if (document != null) break block10;
                    return null;
                }
                Element element = document.getDocumentElement();
                if (element.getNodeName().equals("deviceRegistry")) break block11;
                return null;
            }
            try {
                DeviceRegistryMigration deviceRegistryMigration = new DeviceRegistryMigration();
                deviceRegistryMigration.migrate(document);
                if (deviceRegistryMigration.isMigrated()) {
                    try {
                        XMLUtils.writeDocument(file, document);
                    }
                    catch (TransformerException transformerException) {
                        transformerException.printStackTrace();
                    }
                    document = XMLUtils.readDocument(file);
                }
                xMLPersistenceProvider = new XMLPersistenceProvider(document);
            }
            catch (ParserConfigurationException parserConfigurationException) {
                throw new PersistenceException(parserConfigurationException.getMessage(), parserConfigurationException);
            }
            catch (SAXException sAXException) {
                throw new PersistenceException(sAXException.getMessage(), sAXException);
            }
            catch (IOException iOException) {
                throw new PersistenceException(iOException.getMessage(), iOException);
            }
        }
        return xMLPersistenceProvider;
    }
}

