/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.launching;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.mtj.core.project.IMTJProject;
import org.eclipse.mtj.core.project.midp.IMidletSuiteProject;
import org.eclipse.mtj.internal.core.launching.midp.LaunchingUtils;
import org.eclipse.mtj.internal.core.project.midp.MidletSuiteFactory;
import org.eclipse.mtj.internal.core.util.log.MTJLogger;
import org.eclipse.mtj.internal.ui.launching.NonJavaLaunchShortcut;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JadLaunchShortcut
extends NonJavaLaunchShortcut {
    private IFile jadFile;

    @Override
    protected ILaunchConfiguration createConfiguration() {
        ILaunchConfiguration iLaunchConfiguration = null;
        try {
            ILaunchConfigurationType iLaunchConfigurationType = this.getEmulatorConfigType();
            String string = DebugPlugin.getDefault().getLaunchManager().generateUniqueLaunchConfigurationNameFrom(this.jadFile.getName());
            ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy = iLaunchConfigurationType.newInstance(null, string);
            iLaunchConfigurationWorkingCopy.setAttribute("mtj.do_jad_launch", true);
            String string2 = this.getLaunchingJadFileLocation(this.jadFile);
            iLaunchConfigurationWorkingCopy.setAttribute("mtj.specified_jad_url", string2);
            iLaunchConfigurationWorkingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, this.jadFile.getProject().getName());
            iLaunchConfigurationWorkingCopy.setAttribute("mtj.do_ota", false);
            DebugUITools.setLaunchPerspective((ILaunchConfigurationType)iLaunchConfigurationType, (String)"run", (String)"perspective_default");
            DebugUITools.setLaunchPerspective((ILaunchConfigurationType)iLaunchConfigurationType, (String)"debug", (String)"perspective_default");
            iLaunchConfiguration = iLaunchConfigurationWorkingCopy.doSave();
        }
        catch (CoreException coreException) {
            MTJLogger.log((int)2, (String)"createConfiguration", (Throwable)coreException);
        }
        return iLaunchConfiguration;
    }

    private String getLaunchingJadFileLocation(IFile iFile) {
        IMidletSuiteProject iMidletSuiteProject = this.getMidletSuiteProject(iFile);
        IPath iPath = LaunchingUtils.getJadLaunchBasePath((IMTJProject)iMidletSuiteProject);
        IPath iPath2 = iPath.append(iFile.getName());
        String string = iPath2.toPortableString();
        return string;
    }

    private List<ILaunchConfiguration> getCandidateConfigs(IFile iFile) {
        ILaunchConfigurationType iLaunchConfigurationType = this.getEmulatorConfigType();
        List<ILaunchConfiguration> list = Collections.emptyList();
        try {
            ILaunchConfiguration[] iLaunchConfigurationArray = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurations(iLaunchConfigurationType);
            list = new ArrayList(iLaunchConfigurationArray.length);
            ILaunchConfiguration[] iLaunchConfigurationArray2 = iLaunchConfigurationArray;
            int n = iLaunchConfigurationArray.length;
            int n2 = 0;
            while (n2 < n) {
                ILaunchConfiguration iLaunchConfiguration = iLaunchConfigurationArray2[n2];
                boolean bl = iLaunchConfiguration.getAttribute("mtj.do_jad_launch", false);
                String string = iLaunchConfiguration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, "");
                String string2 = iLaunchConfiguration.getAttribute("mtj.specified_jad_url", "");
                if (bl && string.equals(iFile.getProject().getName()) && string2.indexOf(iFile.getName()) >= 0) {
                    list.add(iLaunchConfiguration);
                }
                ++n2;
            }
        }
        catch (CoreException coreException) {
            MTJLogger.log((int)2, (String)"getCandidateConfigs", (Throwable)coreException);
        }
        this.jadFile = iFile;
        return list;
    }

    private ILaunchConfigurationType getEmulatorConfigType() {
        ILaunchManager iLaunchManager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType iLaunchConfigurationType = iLaunchManager.getLaunchConfigurationType("MTJ.emulatorLaunchConfigurationType");
        return iLaunchConfigurationType;
    }

    private IJavaProject getJavaProject(IFile iFile) {
        IProject iProject = iFile.getProject();
        IJavaProject iJavaProject = JavaCore.create((IProject)iProject);
        return iJavaProject;
    }

    private IMidletSuiteProject getMidletSuiteProject(IFile iFile) {
        IJavaProject iJavaProject = this.getJavaProject(iFile);
        IMidletSuiteProject iMidletSuiteProject = MidletSuiteFactory.getMidletSuiteProject((IJavaProject)iJavaProject);
        return iMidletSuiteProject;
    }

    private IFile getRuntimeJadFile(IMidletSuiteProject iMidletSuiteProject) {
        IFolder iFolder = LaunchingUtils.getEmulationFolder((IMTJProject)iMidletSuiteProject);
        IFile iFile = iFolder.getFile(iMidletSuiteProject.getJadFileName());
        return iFile;
    }

    private boolean isProjectJad(IFile iFile) {
        IMidletSuiteProject iMidletSuiteProject = this.getMidletSuiteProject(iFile);
        String string = iMidletSuiteProject.getJadFileName();
        return string.equals(iFile.getName());
    }

    @Override
    protected List<ILaunchConfiguration> getLaunchConfigurations(ISelection iSelection) {
        IFile iFile = null;
        Object object = ((IStructuredSelection)iSelection).getFirstElement();
        if (object instanceof IFile) {
            iFile = (IFile)object;
            if (!this.isProjectJad(iFile)) {
                IMidletSuiteProject iMidletSuiteProject = this.getMidletSuiteProject(iFile);
                iFile = this.getRuntimeJadFile(iMidletSuiteProject);
            }
        } else if (object instanceof IProject) {
            IJavaProject iJavaProject = JavaCore.create((IProject)((IProject)object));
            IMidletSuiteProject iMidletSuiteProject = MidletSuiteFactory.getMidletSuiteProject((IJavaProject)iJavaProject);
            iFile = this.getRuntimeJadFile(iMidletSuiteProject);
        } else if (object instanceof IJavaProject) {
            IMidletSuiteProject iMidletSuiteProject = MidletSuiteFactory.getMidletSuiteProject((IJavaProject)((IJavaProject)object));
            iFile = this.getRuntimeJadFile(iMidletSuiteProject);
        }
        if (iFile == null) {
            return null;
        }
        return this.getCandidateConfigs(iFile);
    }

    @Override
    protected List<ILaunchConfiguration> getLaunchConfigurations(IEditorPart iEditorPart) {
        IEditorInput iEditorInput = iEditorPart.getEditorInput();
        IFile iFile = (IFile)iEditorInput.getAdapter(IFile.class);
        if (iFile == null) {
            return null;
        }
        if (!this.isProjectJad(iFile)) {
            IMidletSuiteProject iMidletSuiteProject = this.getMidletSuiteProject(iFile);
            iFile = this.getRuntimeJadFile(iMidletSuiteProject);
        }
        return this.getCandidateConfigs(iFile);
    }
}

