/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.build.preverifier;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.IStreamListener;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStreamMonitor;
import org.eclipse.debug.core.model.IStreamsProxy;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.mtj.core.MTJCore;
import org.eclipse.mtj.core.build.preverifier.IPreverifier;
import org.eclipse.mtj.core.persistence.IPersistenceProvider;
import org.eclipse.mtj.core.persistence.PersistenceException;
import org.eclipse.mtj.core.project.IMTJProject;
import org.eclipse.mtj.internal.core.build.BuildConsoleProxy;
import org.eclipse.mtj.internal.core.build.BuildLoggingConfiguration;
import org.eclipse.mtj.internal.core.build.IBuildConsoleProxy;
import org.eclipse.mtj.internal.core.build.preverifier.IClassErrorInformation;
import org.eclipse.mtj.internal.core.build.preverifier.IPreverificationErrorLocation;
import org.eclipse.mtj.internal.core.build.preverifier.PreverificationError;
import org.eclipse.mtj.internal.core.build.preverifier.PreverificationErrorLocation;
import org.eclipse.mtj.internal.core.build.preverifier.PreverificationErrorLocationType;
import org.eclipse.mtj.internal.core.build.preverifier.PreverificationErrorType;
import org.eclipse.mtj.internal.core.util.TemporaryFileManager;
import org.eclipse.mtj.internal.core.util.Utils;
import org.eclipse.mtj.internal.core.util.log.MTJLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProguardPreverifier
implements IPreverifier {
    private static final String[] CANDIDATE_JAVA_LOCATIONS = new String[]{"bin" + File.separatorChar + "java", "bin" + File.separatorChar + "java.exe", "jre" + File.separatorChar + "bin" + File.separatorChar + "java", "jre" + File.separatorChar + "bin" + File.separatorChar + "java.exe"};
    private static final int MAX_COMMAND_LENGTH = 2000;
    private static final String PREV_ERR_REGEX = "^Unable to access jarfile (\\S*)$";
    private static ProguardPreverifier proguardPreverifier;
    private static final Pattern PREV_ERR_PATTERN;
    private String proguardJarFilePath = MTJCore.getProguardJarFile().getAbsolutePath();

    static {
        PREV_ERR_PATTERN = Pattern.compile(PREV_ERR_REGEX, 8);
    }

    public static ProguardPreverifier getInstance() {
        if (proguardPreverifier == null) {
            proguardPreverifier = new ProguardPreverifier();
        }
        return proguardPreverifier;
    }

    private ProguardPreverifier() {
    }

    @Override
    public File getPreverifierExecutable() {
        return null;
    }

    @Override
    public void loadUsing(IPersistenceProvider iPersistenceProvider) throws PersistenceException {
    }

    public PreverificationError[] preverify(IMTJProject iMTJProject, IResource[] iResourceArray, IFolder iFolder, IProgressMonitor iProgressMonitor) throws CoreException {
        Object[] objectArray;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        this.ensureFolderExists(iFolder, iProgressMonitor);
        ArrayList<String> arrayList2 = this.constructCommandLine();
        File file = iFolder.getLocation().toFile();
        String[] stringArray = this.getProguardFinalConfigurationParameters(iMTJProject, file.getAbsolutePath());
        ArrayList<String> arrayList3 = new ArrayList<String>(arrayList2);
        this.addOutputToInJar(arrayList3, iMTJProject);
        int n = 0;
        while (n < iResourceArray.length) {
            IResource iResource = iResourceArray[n];
            switch (iResource.getType()) {
                case 2: 
                case 4: {
                    this.addFileToInJar(arrayList3, iResource.getLocation().toOSString());
                    break;
                }
                case 1: {
                    if (!iResource.getName().endsWith(".jar")) break;
                    this.addFileToInJar(arrayList3, iResource.getLocation().toOSString());
                }
            }
            if (this.commandLength(arrayList3) > 2000) {
                String[] stringArray2;
                String[] stringArray3 = stringArray;
                int n2 = stringArray.length;
                int n3 = 0;
                while (n3 < n2) {
                    stringArray2 = stringArray3[n3];
                    arrayList3.add((String)stringArray2);
                    ++n3;
                }
                stringArray2 = arrayList3.toArray(new String[arrayList3.size()]);
                objectArray = this.runPreverifier(stringArray2, null, iProgressMonitor);
                arrayList.addAll(Arrays.asList(objectArray));
                arrayList3 = new ArrayList<String>(arrayList2);
                this.addOutputToInJar(arrayList3, iMTJProject);
            }
            ++n;
        }
        if (arrayList3.size() != arrayList2.size()) {
            objectArray = stringArray;
            int n4 = stringArray.length;
            int n5 = 0;
            while (n5 < n4) {
                String string = objectArray[n5];
                arrayList3.add(string);
                ++n5;
            }
            String[] stringArray4 = arrayList3.toArray(new String[arrayList3.size()]);
            PreverificationError[] preverificationErrorArray = this.runPreverifier(stringArray4, null, iProgressMonitor);
            arrayList.addAll(Arrays.asList(preverificationErrorArray));
        }
        return arrayList.toArray(new PreverificationError[arrayList.size()]);
    }

    public PreverificationError[] preverifyJarFile(IMTJProject iMTJProject, File file, IFolder iFolder, IProgressMonitor iProgressMonitor) throws CoreException {
        File file2 = new File("");
        try {
            file2 = TemporaryFileManager.instance.createTempDirectory(String.valueOf(file.getName().replace('.', '_')) + "_", ".tmp");
        }
        catch (IOException iOException) {
            Status status = new Status(4, "org.eclipse.mtj.core", "Failed to create directory.", (Throwable)iOException);
            throw new CoreException((IStatus)status);
        }
        file2.mkdirs();
        try {
            Utils.extractArchive(file, file2);
        }
        catch (SecurityException securityException) {
            Status status = new Status(4, "org.eclipse.mtj.core", "Failed to inflate jar file due to a security violation.", (Throwable)securityException);
            throw new CoreException((IStatus)status);
        }
        catch (IOException iOException) {
            Status status = new Status(4, "org.eclipse.mtj.core", "Failed to inflate jar file.", (Throwable)iOException);
            throw new CoreException((IStatus)status);
        }
        File file3 = new File("");
        try {
            file3 = TemporaryFileManager.instance.createTempDirectory(String.valueOf(file.getName().replace('.', '_')) + "_", ".tmp");
        }
        catch (IOException iOException) {
            Status status = new Status(4, "org.eclipse.mtj.core", "Failed to create directory.", (Throwable)iOException);
            throw new CoreException((IStatus)status);
        }
        file3.mkdirs();
        ArrayList<String> arrayList = this.constructCommandLine();
        arrayList.add(file2.toString());
        String[] stringArray = arrayList.toArray(new String[arrayList.size()]);
        PreverificationError[] preverificationErrorArray = this.runPreverifier(stringArray, null, iProgressMonitor);
        FileFilter fileFilter = new FileFilter(){

            public boolean accept(File file) {
                return file.isDirectory() || !file.getName().endsWith(".class");
            }
        };
        try {
            Utils.copy(file2, file3, fileFilter);
        }
        catch (SecurityException securityException) {
            Status status = new Status(4, "org.eclipse.mtj.core", "Failed copy specified source due to a security violation.", (Throwable)securityException);
            throw new CoreException((IStatus)status);
        }
        catch (IOException iOException) {
            Status status = new Status(4, "org.eclipse.mtj.core", "Failed to copy specified source.", (Throwable)iOException);
            throw new CoreException((IStatus)status);
        }
        File file4 = new File(iFolder.getLocation().toFile(), file.getName());
        try {
            Utils.createArchive(file4, file3);
        }
        catch (IOException iOException) {
            Status status = new Status(4, "org.eclipse.mtj.core", "Failed to create zip source folder.", (Throwable)iOException);
            throw new CoreException((IStatus)status);
        }
        return preverificationErrorArray;
    }

    @Override
    public void storeUsing(IPersistenceProvider iPersistenceProvider) throws PersistenceException {
    }

    private void addFileToInJar(List<String> list, String string) throws JavaModelException {
        if (string != null) {
            list.add("-injars");
            list.add("'" + string + "'");
        }
    }

    private void addOutputToInJar(List<String> list, IMTJProject iMTJProject) throws JavaModelException {
        String string = null;
        String string2 = iMTJProject.getProject().getLocation().toOSString();
        String string3 = iMTJProject.getJavaProject().getOutputLocation().removeFirstSegments(1).toOSString();
        string = String.valueOf(string2) + File.separatorChar + string3;
        if (string != null) {
            list.add("-injars");
            list.add("'" + string + "'");
        }
    }

    private int commandLength(ArrayList<String> arrayList) {
        int n = 0;
        Iterator<String> iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            String string = iterator.next();
            n += string.toString().length();
            if (!iterator.hasNext()) continue;
            ++n;
        }
        return n;
    }

    private ArrayList<String> constructCommandLine() throws CoreException {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(this.getJavaExecutable().getAbsolutePath());
        arrayList.add("-jar");
        arrayList.add(this.proguardJarFilePath);
        return arrayList;
    }

    private void ensureFolderExists(IFolder iFolder, IProgressMonitor iProgressMonitor) throws CoreException {
        if (!iFolder.exists()) {
            iFolder.create(true, true, iProgressMonitor);
        }
    }

    private String getFullClasspath(IMTJProject iMTJProject) throws CoreException {
        IJavaProject iJavaProject = iMTJProject.getJavaProject();
        String[] stringArray = JavaRuntime.computeDefaultRuntimeClassPath((IJavaProject)iJavaProject);
        StringBuffer stringBuffer = new StringBuffer();
        int n = 1;
        while (n < stringArray.length) {
            if (n != 1) {
                stringBuffer.append(File.pathSeparatorChar);
            }
            stringBuffer.append("'" + stringArray[n] + "'");
            ++n;
        }
        return stringBuffer.toString();
    }

    private File getJavaExecutable() {
        File file = null;
        IVMInstall iVMInstall = JavaRuntime.getDefaultVMInstall();
        File file2 = iVMInstall.getInstallLocation();
        int n = 0;
        while (n < CANDIDATE_JAVA_LOCATIONS.length) {
            String string = CANDIDATE_JAVA_LOCATIONS[n];
            File file3 = new File(file2, string);
            if (file3.exists()) {
                file = file3;
                break;
            }
            ++n;
        }
        return file;
    }

    private String[] getProguardFinalConfigurationParameters(IMTJProject iMTJProject, String string) throws CoreException {
        return new String[]{"-outjars", "'" + string + "'", "-libraryjars", this.getFullClasspath(iMTJProject), "'-ignorewarnings'", "-dontusemixedcaseclassnames", "-dontshrink", "-dontoptimize", "-dontobfuscate", "-microedition"};
    }

    private void handleErrorReceived(String string, List<PreverificationError> list) {
        Matcher matcher = PREV_ERR_PATTERN.matcher(string = string.trim());
        if (matcher.find()) {
            if (matcher.groupCount() > 0) {
                Object object;
                Object object2;
                final String string2 = matcher.group(1);
                String string3 = "Error preverifying class";
                if (matcher.end() < string.length()) {
                    object2 = new StringBuffer(string3);
                    ((StringBuffer)object2).append(": ");
                    object = string.substring(matcher.end());
                    object = ((String)object).trim();
                    ((StringBuffer)object2).append((String)object);
                    string3 = ((StringBuffer)object2).toString();
                }
                object2 = new IClassErrorInformation(){

                    public String getName() {
                        return string2;
                    }

                    public String getSourceFile() {
                        return null;
                    }
                };
                object = new PreverificationErrorLocation(PreverificationErrorLocationType.UNKNOWN_LOCATION, (IClassErrorInformation)object2);
                PreverificationError preverificationError = new PreverificationError(PreverificationErrorType.UNKNOWN_ERROR, (IPreverificationErrorLocation)object, string);
                list.add(preverificationError);
            }
        } else {
            MTJLogger.log(2, string);
        }
    }

    private PreverificationError[] runPreverifier(String[] stringArray, String[] stringArray2, IProgressMonitor iProgressMonitor) throws CoreException {
        final ArrayList arrayList = new ArrayList();
        IProcess iProcess = Utils.launchApplication(stringArray, null, stringArray2, "Preverifier", "CLDC Preverifier");
        IStreamsProxy iStreamsProxy = iProcess.getStreamsProxy();
        if (BuildLoggingConfiguration.getInstance().isPreverifierOutputEnabled()) {
            BuildConsoleProxy.getInstance().traceln("======================== Launching Preverification =========================");
            BuildConsoleProxy.getInstance().addConsoleStreamListener(IBuildConsoleProxy.Stream.ERROR, iStreamsProxy.getErrorStreamMonitor());
            BuildConsoleProxy.getInstance().addConsoleStreamListener(IBuildConsoleProxy.Stream.OUTPUT, iStreamsProxy.getOutputStreamMonitor());
        }
        iStreamsProxy.getErrorStreamMonitor().addListener(new IStreamListener(){

            public void streamAppended(String string, IStreamMonitor iStreamMonitor) {
                ProguardPreverifier.this.handleErrorReceived(string, arrayList);
            }
        });
        while (!iProgressMonitor.isCanceled() && !iProcess.isTerminated()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (BuildLoggingConfiguration.getInstance().isPreverifierOutputEnabled()) {
            BuildConsoleProxy.getInstance().traceln("======================== Preverification exited with code: " + iProcess.getExitValue());
        }
        return arrayList.toArray(new PreverificationError[arrayList.size()]);
    }
}

