/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.core.project.runtime;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.mtj.core.persistence.PersistenceException;
import org.eclipse.mtj.core.project.runtime.MTJRuntime;
import org.eclipse.mtj.core.project.runtime.event.AddMTJRuntimeEvent;
import org.eclipse.mtj.core.project.runtime.event.IMTJRuntimeListChangeListener;
import org.eclipse.mtj.core.project.runtime.event.RemoveMTJRuntimeEvent;
import org.eclipse.mtj.core.project.runtime.event.SwitchActiveMTJRuntimeEvent;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MTJRuntimeList
extends ArrayList<MTJRuntime> {
    public static final String ELEM_CONFIGURATIONS = "configurations";
    private static final long serialVersionUID = -8304504334314517586L;
    private List<IMTJRuntimeListChangeListener> listeners = new ArrayList<IMTJRuntimeListChangeListener>();

    public MTJRuntimeList() {
    }

    public MTJRuntimeList(Element runtimeListElement) throws PersistenceException {
        NodeList configs = runtimeListElement.getElementsByTagName("configuration");
        int i = 0;
        while (i < configs.getLength()) {
            MTJRuntime config = new MTJRuntime((Element)configs.item(i));
            this.add(config);
            ++i;
        }
    }

    @Override
    public boolean add(MTJRuntime runtime) {
        boolean result = super.add(runtime);
        if (!result) {
            return result;
        }
        AddMTJRuntimeEvent event = new AddMTJRuntimeEvent(this, runtime);
        for (IMTJRuntimeListChangeListener listener : this.listeners) {
            listener.mtjRuntimeAdded(event);
        }
        return result;
    }

    @Override
    public boolean addAll(Collection<? extends MTJRuntime> runtimes) throws NullPointerException {
        boolean modified = false;
        for (MTJRuntime mTJRuntime : runtimes) {
            modified = this.add(mTJRuntime);
        }
        return modified;
    }

    public void addMTJRuntimeListChangeListener(IMTJRuntimeListChangeListener listener) {
        this.listeners.add(listener);
    }

    public MTJRuntime getActiveMTJRuntime() {
        for (MTJRuntime c : this) {
            if (!c.isActive()) continue;
            return c;
        }
        return null;
    }

    @Override
    public boolean remove(Object o) {
        boolean result = super.remove(o);
        if (!result) {
            return result;
        }
        if (o instanceof MTJRuntime) {
            MTJRuntime removedConfig = (MTJRuntime)o;
            RemoveMTJRuntimeEvent event = new RemoveMTJRuntimeEvent(this, removedConfig);
            for (IMTJRuntimeListChangeListener listener : this.listeners) {
                listener.mtjRuntimeRemoved(event);
            }
        }
        return result;
    }

    @Override
    public boolean removeAll(Collection<?> runtimes) {
        boolean modified = false;
        for (Object o : runtimes) {
            modified = this.remove(o);
        }
        return modified;
    }

    public void removeMTJRuntimeListChangeListener(IMTJRuntimeListChangeListener listener) {
        this.listeners.remove(listener);
    }

    public void switchActiveMTJRuntime(MTJRuntime runtime) {
        MTJRuntime oldActiveConfig = this.getActiveMTJRuntime();
        if (oldActiveConfig != null) {
            this.getActiveMTJRuntime().setActive(false);
        }
        runtime.setActive(true);
        SwitchActiveMTJRuntimeEvent event = new SwitchActiveMTJRuntimeEvent(this, oldActiveConfig, runtime);
        for (IMTJRuntimeListChangeListener listener : this.listeners) {
            listener.activeMTJRuntimeSwitched(event);
        }
    }
}

