/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.build;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildSpecManipulator {
    private IProject project;
    private IProjectDescription projectDescription;
    private boolean updated;
    private ArrayList<ICommand> commands;

    public BuildSpecManipulator(IProject project) throws CoreException {
        this.project = project;
        this.projectDescription = project.getDescription();
    }

    public void addBuilderAfter(String relativeBuilder, String builder, Map<?, ?> arguments) throws CoreException {
        ArrayList<ICommand> commands = this.getCommands();
        ICommand command = this.newCommand(builder, arguments);
        int relativeIndex = this.indexOf(relativeBuilder);
        if (relativeIndex == -1 || relativeIndex == commands.size() - 1) {
            commands.add(command);
        } else {
            commands.add(relativeIndex + 1, command);
        }
        this.updated = true;
    }

    public void addBuilderBefore(String relativeBuilder, String builder, Map<?, ?> arguments) throws CoreException {
        ArrayList<ICommand> commands = this.getCommands();
        ICommand command = this.newCommand(builder, arguments);
        int relativeIndex = this.indexOf(relativeBuilder);
        if (relativeIndex == -1 || commands.size() == 0) {
            commands.add(command);
        } else {
            commands.add(relativeIndex, command);
        }
        this.updated = true;
    }

    public void commitChanges(IProgressMonitor monitor) throws CoreException {
        if (this.updated) {
            IProjectDescription description = this.project.getDescription();
            ICommand[] commandArray = this.commands.toArray(new ICommand[this.commands.size()]);
            description.setBuildSpec(commandArray);
            this.project.setDescription(description, monitor);
            this.updated = false;
        }
    }

    public boolean hasArguments(String builder) throws CoreException {
        boolean hasArgs = false;
        int index = this.indexOf(builder);
        if (index != -1) {
            ICommand command = this.getCommands().get(index);
            Map args = command.getArguments();
            hasArgs = args != null && args.size() > 0;
        }
        return hasArgs;
    }

    public boolean hasBuilder(String builder) throws CoreException {
        return this.indexOf(builder) != -1;
    }

    public int indexOf(String builder) throws CoreException {
        int index = -1;
        ArrayList<ICommand> list = this.getCommands();
        if (list.size() > 0) {
            int i = 0;
            while (i < list.size()) {
                ICommand command = list.get(i);
                if (command.getBuilderName().equals(builder)) {
                    index = i;
                    break;
                }
                ++i;
            }
        }
        return index;
    }

    public void replaceBuilder(String builder, Map<?, ?> arguments) throws CoreException {
        ArrayList<ICommand> commands = this.getCommands();
        ICommand command = this.newCommand(builder, arguments);
        int relativeIndex = this.indexOf(builder);
        if (relativeIndex != -1) {
            commands.set(relativeIndex, command);
            this.updated = true;
        }
    }

    public void removeBuilder(String builder) throws CoreException {
        int index = this.indexOf(builder);
        if (index != -1) {
            this.getCommands().remove(index);
            this.updated = true;
        }
    }

    private ICommand newCommand(String builder, Map<?, ?> arguments) {
        ICommand command = this.projectDescription.newCommand();
        command.setBuilderName(builder);
        if (arguments != null) {
            command.setArguments(arguments);
        }
        return command;
    }

    private ArrayList<ICommand> getCommands() throws CoreException {
        if (this.commands == null) {
            ICommand[] commandArray = this.projectDescription.getBuildSpec();
            this.commands = new ArrayList<ICommand>(Arrays.asList(commandArray));
        }
        return this.commands;
    }

    public boolean isFirstBuilder(String builderId) throws CoreException {
        boolean result = false;
        ArrayList<ICommand> commands = this.getCommands();
        String id = ((ICommand)commands.get(0)).getBuilderName();
        if (id != null && id.equals(builderId)) {
            result = true;
        }
        return result;
    }

    public boolean isLastBuilder(String builderId) throws CoreException {
        boolean result = false;
        ArrayList<ICommand> commands = this.getCommands();
        String id = ((ICommand)commands.get(commands.size() - 1)).getBuilderName();
        if (id != null && id.equals(builderId)) {
            result = true;
        }
        return result;
    }

    public void setBuilderArguments(String builderId, Map<String, String> args) throws CoreException {
        ArrayList<ICommand> commands = this.getCommands();
        for (ICommand command : commands) {
            if (!command.getBuilderName().equals(builderId)) continue;
            command.setArguments(args);
            this.updated = true;
            break;
        }
    }
}

