/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.build.preverifier;

import java.io.File;
import java.io.FileFilter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.IStreamListener;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStreamMonitor;
import org.eclipse.debug.core.model.IStreamsProxy;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMInstallType;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.mtj.core.build.preverifier.IPreverificationError;
import org.eclipse.mtj.core.build.preverifier.IPreverifier;
import org.eclipse.mtj.core.persistence.IPersistenceProvider;
import org.eclipse.mtj.core.persistence.PersistenceException;
import org.eclipse.mtj.core.project.IMTJProject;
import org.eclipse.mtj.internal.core.PreferenceAccessor;
import org.eclipse.mtj.internal.core.build.BuildConsoleProxy;
import org.eclipse.mtj.internal.core.build.BuildLoggingConfiguration;
import org.eclipse.mtj.internal.core.build.IBuildConsoleProxy;
import org.eclipse.mtj.internal.core.build.preverifier.IClassErrorInformation;
import org.eclipse.mtj.internal.core.build.preverifier.PreverificationError;
import org.eclipse.mtj.internal.core.build.preverifier.PreverificationErrorLocation;
import org.eclipse.mtj.internal.core.build.preverifier.PreverificationErrorLocationType;
import org.eclipse.mtj.internal.core.build.preverifier.PreverificationErrorType;
import org.eclipse.mtj.internal.core.build.preverifier.StandardPreverifierParameters;
import org.eclipse.mtj.internal.core.util.EnvironmentVariables;
import org.eclipse.mtj.internal.core.util.MTJStatusHandler;
import org.eclipse.mtj.internal.core.util.TemporaryFileManager;
import org.eclipse.mtj.internal.core.util.Utils;
import org.eclipse.mtj.internal.core.util.log.MTJLogger;
import org.osgi.framework.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StandardPreverifier
implements IPreverifier {
    public static final String BUILD_ARG_PREVERIFY_CLASSES = "preverifyClasses";
    public static final String BUILD_ARG_PREVERIFY_LIBS = "preverifyLibraries";
    public static final String BUILD_ARG_PREVERIFY_TARGET = "preverifyTargetProject";
    private static final String PREV_ERR_REGEX = "^Error preverifying class (\\S*)$";
    private static final Pattern PREV_ERR_PATTERN = Pattern.compile("^Error preverifying class (\\S*)$", 8);
    private BuildConsoleProxy consoleProxy = BuildConsoleProxy.getInstance();
    private StandardPreverifierParameters parameters;
    private File preverifierExecutable;

    public StandardPreverifierParameters getParameters() {
        return this.parameters;
    }

    @Override
    public File getPreverifierExecutable() {
        return this.preverifierExecutable;
    }

    @Override
    public void loadUsing(IPersistenceProvider persistenceProvider) throws PersistenceException {
        String preverifierExeString = persistenceProvider.loadString("preverifierExecutable");
        this.preverifierExecutable = new File(preverifierExeString);
        this.parameters = (StandardPreverifierParameters)persistenceProvider.loadPersistable("parameters");
    }

    @Override
    public IPreverificationError[] preverify(IMTJProject midletProject, IResource[] toVerify, IFolder outputFolder, IProgressMonitor monitor) throws CoreException {
        this.ensureOutputFolderExists(outputFolder, monitor);
        IPath outputFolderLocation = outputFolder.getLocation();
        if (outputFolderLocation == null) {
            Status status = new Status(4, "org.eclipse.mtj.core", "Failed To Get The Preverification Output Folder Location");
            throw new CoreException((IStatus)status);
        }
        File outputFolderAsFile = outputFolderLocation.toFile();
        ArrayList<String> baseArguments = this.constructCommandLine(midletProject, outputFolderAsFile, monitor);
        ArrayList<String> arguments = new ArrayList<String>(baseArguments);
        ArrayList<String> classNames = new ArrayList<String>(toVerify.length);
        IResource[] iResourceArray = toVerify;
        int n = toVerify.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            IPath resLoc = resource.getLocation();
            switch (resource.getType()) {
                case 2: 
                case 4: {
                    if (resLoc == null) break;
                    classNames.add(resLoc.toOSString());
                    break;
                }
                case 1: {
                    if (resource.getName().endsWith(".class")) {
                        this.addClassTarget(classNames, resource);
                        break;
                    }
                    if (!resource.getName().endsWith(".jar") || resLoc == null) break;
                    classNames.add(resLoc.toOSString());
                }
            }
            ++n2;
        }
        ArrayList<IPreverificationError> allErrors = new ArrayList<IPreverificationError>();
        if (classNames.size() > 0) {
            File preverifierArguments = null;
            try {
                try {
                    preverifierArguments = File.createTempFile("mtj.preverifier.", null);
                    String argsFname = preverifierArguments.getAbsolutePath();
                    FileWriter os = new FileWriter(preverifierArguments);
                    String args = classNames.toString();
                    args = args.substring(1, args.length() - 1);
                    args = args.replaceAll(", ", " ");
                    os.write(args);
                    os.write("\n");
                    os.close();
                    arguments.add("@" + argsFname);
                    String[] commandLine = arguments.toArray(new String[arguments.size()]);
                    IPreverificationError[] errors = this.runPreverifier(commandLine, null, monitor);
                    allErrors.addAll(Arrays.asList(errors));
                }
                catch (IOException e) {
                    Status status = new Status(4, "org.eclipse.mtj.core", "Failed to create temp file for preverification.", (Throwable)e);
                    throw new CoreException((IStatus)status);
                }
            }
            finally {
                if (preverifierArguments != null && preverifierArguments.exists()) {
                    preverifierArguments.delete();
                }
            }
        }
        return allErrors.toArray(new IPreverificationError[allErrors.size()]);
    }

    @Override
    public IPreverificationError[] preverifyJarFile(IMTJProject midletProject, File jarFile, IFolder outputFolder, IProgressMonitor monitor) throws CoreException {
        File srcDirectory = null;
        File tgtDirectory = null;
        try {
            srcDirectory = TemporaryFileManager.instance.createTempDirectory(String.valueOf(jarFile.getName().replace('.', '_')) + "_", ".tmp");
            srcDirectory.mkdirs();
            Utils.extractArchive(jarFile, srcDirectory);
            tgtDirectory = TemporaryFileManager.instance.createTempDirectory(String.valueOf(jarFile.getName().replace('.', '_')) + "_", ".tmp");
            tgtDirectory.mkdirs();
        }
        catch (SecurityException se) {
            Status status = new Status(4, "org.eclipse.mtj.core", "Failed to inflate jar file due to a security violation.", (Throwable)se);
            throw new CoreException((IStatus)status);
        }
        catch (IOException ioe) {
            Status status = new Status(4, "org.eclipse.mtj.core", "Failed to inflate jar file.", (Throwable)ioe);
            throw new CoreException((IStatus)status);
        }
        ArrayList<String> arguments = this.constructCommandLine(midletProject, tgtDirectory, monitor);
        arguments.add(srcDirectory.toString());
        String[] environment = this.getEnvironment(jarFile);
        String[] commandLine = arguments.toArray(new String[arguments.size()]);
        IPreverificationError[] errors = this.runPreverifier(commandLine, environment, monitor);
        try {
            FileFilter classFilter = new FileFilter(){

                public boolean accept(File pathname) {
                    return pathname.isDirectory() || !pathname.getName().endsWith(".class");
                }
            };
            Utils.copy(srcDirectory, tgtDirectory, classFilter);
            File outputJarFile = new File(outputFolder.getLocation().toFile(), jarFile.getName());
            Utils.createArchive(outputJarFile, tgtDirectory);
        }
        catch (IOException ioe) {
            Status status = new Status(4, "org.eclipse.mtj.core", "Failed to re-jar the output of the preverification into the requested jar file.", (Throwable)ioe);
            throw new CoreException((IStatus)status);
        }
        return errors;
    }

    public void setParameters(StandardPreverifierParameters parameters) {
        this.parameters = parameters;
    }

    public void setPreverifierExecutable(File preverifierExecutable) {
        this.preverifierExecutable = preverifierExecutable;
    }

    @Override
    public void storeUsing(IPersistenceProvider persistenceProvider) throws PersistenceException {
        persistenceProvider.storeString("preverifierExecutable", this.preverifierExecutable.toString());
        persistenceProvider.storePersistable("parameters", this.parameters);
    }

    private void addClasspath(ArrayList<String> args, IMTJProject mtjProject) throws CoreException {
        String classpath = this.getFullClasspath(mtjProject);
        args.add("-classpath");
        args.add(classpath);
    }

    private void addClassTarget(List<String> args, IResource resource) throws JavaModelException {
        String className;
        IProject project = resource.getProject();
        IJavaProject javaProject = JavaCore.create((IProject)project);
        if (javaProject != null && (className = this.extractClassName(javaProject, resource)) != null) {
            args.add(className);
        }
    }

    private void addOutputDirArg(ArrayList<String> args, File outputDir) {
        args.add("-d");
        args.add(outputDir.toString());
    }

    private ArrayList<String> constructCommandLine(IMTJProject mtjProject, File outputFolder, IProgressMonitor monitor) throws CoreException {
        String[] configurationParameters;
        ArrayList<String> cmdArgs = new ArrayList<String>();
        cmdArgs.add(this.preverifierExecutable.toString());
        String[] stringArray = configurationParameters = this.getCLDCConfigurationParameters(mtjProject);
        int n = configurationParameters.length;
        int n2 = 0;
        while (n2 < n) {
            String configurationParameter = stringArray[n2];
            cmdArgs.add(configurationParameter);
            ++n2;
        }
        this.addClasspath(cmdArgs, mtjProject);
        this.addOutputDirArg(cmdArgs, outputFolder);
        return cmdArgs;
    }

    private void ensureOutputFolderExists(IFolder folder, IProgressMonitor monitor) throws CoreException {
        if (!folder.exists()) {
            folder.create(true, true, monitor);
        }
    }

    private String extractClassName(IJavaProject javaProject, IResource resource) {
        IPath classPath = null;
        try {
            classPath = this.extractResourcePath(javaProject, resource);
        }
        catch (JavaModelException e) {
            MTJLogger.log(2, "Failed to extract the path from the specified IResource", e);
        }
        return classPath == null ? null : classPath.removeFileExtension().toString().replace('/', '.');
    }

    private IPath extractResourcePath(IJavaProject javaProject, IResource resource) throws JavaModelException {
        IClasspathEntry[] classpath;
        IPath resultPath = null;
        IPath projectOutputPath = javaProject.getOutputLocation().makeAbsolute();
        IPath resourcePath = resource.getFullPath();
        IClasspathEntry[] iClasspathEntryArray = classpath = javaProject.getRawClasspath();
        int n = classpath.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathEntry entry = iClasspathEntryArray[n2];
            if (entry.getEntryKind() == 3) {
                IPath entryPath = entry.getOutputLocation();
                IPath iPath = entryPath = entryPath == null ? projectOutputPath : entryPath.makeAbsolute();
                if (entryPath.isPrefixOf(resourcePath)) {
                    resultPath = resourcePath.removeFirstSegments(entryPath.segmentCount());
                }
            }
            ++n2;
        }
        return resultPath;
    }

    private String[] getEnvironment(File jarFileToVerify) throws CoreException {
        String[] environment = null;
        if (jarFileToVerify != null && !this.isJarExecutableOnPath()) {
            IVMInstall fullJDK = this.searchForVMInstallWithJar();
            if (fullJDK == null) {
                IStatus status = MTJStatusHandler.newStatus(4, 102, "Could not find jar tool executable.");
                MTJStatusHandler.statusPrompt(status, this);
            } else {
                String pathValue = new File(fullJDK.getInstallLocation(), "bin").toString();
                environment = this.getEnvironmentWithAugmentedPath(pathValue);
            }
        }
        return environment;
    }

    private String[] getEnvironmentWithAugmentedPath(String pathValue) throws CoreException {
        String[] environment = null;
        try {
            EnvironmentVariables envVars = new EnvironmentVariables();
            String path = envVars.getVariable("PATH");
            path = String.valueOf(path) + File.pathSeparator + pathValue;
            envVars.setVariable("PATH", path);
            environment = envVars.convertToStrings();
        }
        catch (IOException e) {
            MTJStatusHandler.throwCoreException(4, -999, e);
        }
        return environment;
    }

    private String getFullClasspath(IMTJProject midletProject) throws CoreException {
        IJavaProject javaProject = midletProject.getJavaProject();
        String[] entries = JavaRuntime.computeDefaultRuntimeClassPath((IJavaProject)javaProject);
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < entries.length) {
            if (i != 0) {
                sb.append(File.pathSeparatorChar);
            }
            sb.append(entries[i]);
            ++i;
        }
        return sb.toString();
    }

    private String getJarExecutable() {
        String executable = null;
        String os = System.getProperty("os.name").toLowerCase();
        executable = os.indexOf("windows 9") > -1 || os.indexOf("nt") > -1 || os.indexOf("windows 2000") > -1 || os.indexOf("windows xp") > -1 ? "jar.exe" : "jar";
        return executable;
    }

    private boolean installContainsJarExecutable(IVMInstall install) {
        File bin;
        boolean containsJar = false;
        File installLocation = install.getInstallLocation();
        if (installLocation != null && (bin = new File(installLocation, "bin")).exists()) {
            File[] matches = bin.listFiles(new FileFilter(){

                public boolean accept(File pathname) {
                    return pathname.isFile() && pathname.getName().startsWith("jar");
                }
            });
            containsJar = matches != null && matches.length > 0;
        }
        return containsJar;
    }

    private boolean isJarExecutableOnPath() throws CoreException {
        boolean onPath = false;
        String executable = this.getJarExecutable();
        try {
            EnvironmentVariables envVars = new EnvironmentVariables();
            String pathString = envVars.getVariable("PATH");
            StringTokenizer st = new StringTokenizer(pathString, File.pathSeparator);
            while (st.hasMoreTokens()) {
                File path = new File(st.nextToken());
                File jar = new File(path, executable);
                if (!jar.exists()) continue;
                onPath = true;
                break;
            }
        }
        catch (IOException e) {
            MTJStatusHandler.throwCoreException(4, -999, e);
        }
        return onPath;
    }

    private IVMInstall searchForVMInstallWithJar() {
        IVMInstall fullJDK = null;
        IVMInstall install = JavaRuntime.getDefaultVMInstall();
        if (this.installContainsJarExecutable(install)) {
            fullJDK = install;
        } else {
            IVMInstall[] installs;
            IVMInstallType installType = install.getVMInstallType();
            IVMInstall[] iVMInstallArray = installs = installType.getVMInstalls();
            int n = installs.length;
            int n2 = 0;
            while (n2 < n) {
                IVMInstall install2 = iVMInstallArray[n2];
                install = install2;
                if (this.installContainsJarExecutable(install)) {
                    fullJDK = install;
                    break;
                }
                ++n2;
            }
        }
        return fullJDK;
    }

    protected String[] getCLDCConfigurationParameters(IMTJProject midletProject) throws CoreException {
        IProject project = midletProject.getProject();
        Version configVersion = PreferenceAccessor.instance.getPreverificationConfigurationVersion(project);
        return this.isCLDC1_0(configVersion) ? this.parameters.cldc10 : this.parameters.cldc11;
    }

    protected void handleErrorReceived(String text, List<IPreverificationError> errorList) {
        Matcher matcher = PREV_ERR_PATTERN.matcher(text = text.trim());
        if (matcher.find()) {
            if (matcher.groupCount() > 0) {
                final String classname = matcher.group(1);
                String errorText = "Error preverifying class";
                if (matcher.end() < text.length()) {
                    StringBuffer sb = new StringBuffer(errorText);
                    sb.append(": ");
                    String detail = text.substring(matcher.end());
                    detail = detail.trim();
                    sb.append(detail);
                    errorText = sb.toString();
                }
                IClassErrorInformation classInfo = new IClassErrorInformation(){

                    public String getName() {
                        return classname;
                    }

                    public String getSourceFile() {
                        return null;
                    }
                };
                PreverificationErrorLocation location = new PreverificationErrorLocation(PreverificationErrorLocationType.UNKNOWN_LOCATION, classInfo);
                PreverificationError error = new PreverificationError(PreverificationErrorType.UNKNOWN_ERROR, location, text);
                errorList.add(error);
            }
        } else {
            MTJLogger.log(2, text);
        }
    }

    protected boolean isCLDC1_0(Version configVersion) {
        return configVersion.getMajor() == 1 && configVersion.getMinor() == 0;
    }

    protected IPreverificationError[] runPreverifier(String[] commandLine, String[] environment, IProgressMonitor monitor) throws CoreException {
        final ArrayList errorList = new ArrayList();
        IProcess process = Utils.launchApplication(commandLine, null, environment, "Preverifier", "CLDC Preverifier");
        IStreamsProxy proxy = process.getStreamsProxy();
        if (BuildLoggingConfiguration.getInstance().isPreverifierOutputEnabled()) {
            this.consoleProxy.traceln("======================== Launching Preverification =========================");
            this.consoleProxy.addConsoleStreamListener(IBuildConsoleProxy.Stream.ERROR, proxy.getErrorStreamMonitor());
            this.consoleProxy.addConsoleStreamListener(IBuildConsoleProxy.Stream.OUTPUT, proxy.getOutputStreamMonitor());
        }
        proxy.getErrorStreamMonitor().addListener(new IStreamListener(){

            public void streamAppended(String text, IStreamMonitor monitor) {
                StandardPreverifier.this.handleErrorReceived(text, errorList);
            }
        });
        while (!monitor.isCanceled() && !process.isTerminated()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (BuildLoggingConfiguration.getInstance().isPreverifierOutputEnabled()) {
            this.consoleProxy.traceln("======================== Preverification exited with code: " + process.getExitValue());
        }
        return errorList.toArray(new IPreverificationError[errorList.size()]);
    }
}

