/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.build.sign;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.equinox.security.storage.ISecurePreferences;
import org.eclipse.equinox.security.storage.SecurePreferencesFactory;
import org.eclipse.equinox.security.storage.StorageException;
import org.eclipse.mtj.internal.core.Messages;
import org.eclipse.mtj.internal.core.build.sign.SignatureProperties;
import org.eclipse.mtj.internal.core.util.MTJStatusHandler;
import org.eclipse.mtj.internal.core.util.log.MTJLogger;

public class PreferencesSignatureProperties
extends SignatureProperties {
    private static final String SIGNING_PREFERENCE_PATH = "mtj/preferences/signing";
    private ISecurePreferences preferences;

    public PreferencesSignatureProperties() throws CoreException {
        try {
            this.loadPropertiesFromPeferences();
        }
        catch (Exception exception) {
            MTJStatusHandler.throwCoreException(4, 999, Messages.PreferencesSignatureProperties_unableToLoadPropertiesFromPreferences);
        }
    }

    private void loadPropertiesFromPeferences() throws StorageException {
        ISecurePreferences root = SecurePreferencesFactory.getDefault();
        if (!root.nodeExists(SIGNING_PREFERENCE_PATH)) {
            return;
        }
        this.preferences = root.node(SIGNING_PREFERENCE_PATH);
        this.setKeyStoreDisplayPath(this.preferences.get("keystore", null));
        this.setPasswordStorageMethod(this.preferences.getInt("storePasswords", 0));
        this.setKeyStorePassword(this.preferences.get("KeystorePass", null));
        this.setKeyAlias(this.preferences.get("alias", null));
        this.setKeyStoreProvider(this.preferences.get("provider", null));
        this.setKeyStoreType(this.preferences.get("keystoreType", null));
    }

    public boolean save() {
        boolean saved = false;
        if (this.preferences == null) {
            ISecurePreferences root = SecurePreferencesFactory.getDefault();
            this.preferences = root.node(SIGNING_PREFERENCE_PATH);
        }
        try {
            this.preferences.clear();
            this.preferences.put("keystore", this.getKeyStoreDisplayPath(), false);
            this.preferences.put("KeystorePass", this.getKeyStorePassword(), true);
            this.preferences.putInt("storePasswords", this.getPasswordStorageMethod(), false);
            this.preferences.put("alias", this.getKeyAlias(), false);
            this.preferences.put("provider", this.getKeyStoreProvider(), false);
            this.preferences.put("keystoreType", this.getKeyStoreType(), false);
            saved = true;
        }
        catch (StorageException e) {
            MTJLogger.log(4, e);
        }
        return saved;
    }

    public boolean isProjectSpecific() {
        return false;
    }

    public void setProjectSpecific(boolean value) {
        super.setProjectSpecific(false);
    }

    public boolean isKeyStorePathExternal() {
        return true;
    }
}

