/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.project.midp;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.security.storage.ISecurePreferences;
import org.eclipse.equinox.security.storage.SecurePreferencesFactory;
import org.eclipse.equinox.security.storage.StorageException;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.mtj.core.MTJCore;
import org.eclipse.mtj.core.build.sign.ISignatureProperties;
import org.eclipse.mtj.core.persistence.PersistenceException;
import org.eclipse.mtj.core.project.midp.IMIDPMetaData;
import org.eclipse.mtj.core.project.midp.IMidletSuiteProject;
import org.eclipse.mtj.core.project.runtime.MTJRuntime;
import org.eclipse.mtj.core.project.runtime.MTJRuntimeList;
import org.eclipse.mtj.core.sdk.device.IDevice;
import org.eclipse.mtj.core.symbol.ISymbol;
import org.eclipse.mtj.core.symbol.ISymbolSet;
import org.eclipse.mtj.internal.core.MTJCoreErrors;
import org.eclipse.mtj.internal.core.build.preverifier.builder.PreverificationBuilder;
import org.eclipse.mtj.internal.core.build.sign.Base64EncDec;
import org.eclipse.mtj.internal.core.build.sign.SignatureProperties;
import org.eclipse.mtj.internal.core.project.midp.IMetaDataConstants;
import org.eclipse.mtj.internal.core.project.midp.MidletSuiteFactory;
import org.eclipse.mtj.internal.core.project.runtime.MTJRuntimeListUtils;
import org.eclipse.mtj.internal.core.util.MTJStatusHandler;
import org.eclipse.mtj.internal.core.util.Utils;
import org.eclipse.mtj.internal.core.util.log.MTJLogger;
import org.eclipse.mtj.internal.core.util.xml.XMLUtils;
import org.osgi.framework.Version;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetaData
implements IMIDPMetaData,
IMetaDataConstants {
    private MTJRuntimeList configurations;
    private IDevice device;
    private String jadFileName;
    private IProject project;
    private Element rootXmlElement;
    private SignatureProperties signatureProps;
    private Version version;
    private Hashtable<String, Properties> sdkProviderProperties;

    public MetaData(IMidletSuiteProject suite) {
        this(suite.getJavaProject().getProject());
    }

    public MetaData(IProject project) {
        this.project = project;
        try {
            this.loadMetaData();
        }
        catch (CoreException e) {
            MTJLogger.log(4, "loadMetaData() failed", e);
            this.initializeToDefaults();
        }
    }

    public IDevice getDevice() {
        return this.device;
    }

    @Override
    public String getJadFileName() {
        return this.jadFileName;
    }

    @Override
    public MTJRuntimeList getRuntimeList() {
        if (this.configurations == null) {
            this.configurations = new MTJRuntimeList();
        }
        return this.configurations;
    }

    @Override
    public ISignatureProperties getSignatureProperties() {
        return this.signatureProps;
    }

    @Override
    public Version getVersion() {
        return this.version;
    }

    @Override
    public void saveMetaData() throws CoreException {
        IFile storeFile = this.getStoreFile();
        if (storeFile == null) {
            MTJLogger.log(2, "saveMetaData failed due to null store file");
        } else {
            if (storeFile.exists() && storeFile.isReadOnly()) {
                ResourceAttributes attributes = storeFile.getResourceAttributes();
                attributes.setReadOnly(false);
                storeFile.setResourceAttributes(attributes);
            }
            this.saveMetaDataToFile(storeFile);
        }
    }

    @Override
    public void setSDKProviderMetaData(String sdkId, Properties metaData) throws IllegalArgumentException {
        if (sdkId == null || sdkId.length() == 0) {
            throw new IllegalArgumentException("The sdkId must not be null or empty.");
        }
        if (this.sdkProviderProperties == null) {
            this.sdkProviderProperties = new Hashtable();
        } else {
            this.sdkProviderProperties.remove(sdkId);
        }
        if (metaData != null) {
            this.sdkProviderProperties.put(sdkId, metaData);
        }
        if (this.sdkProviderProperties.isEmpty()) {
            this.sdkProviderProperties = null;
        }
    }

    @Override
    public Properties getSDKProviderMetaData(String sdkId) throws IllegalArgumentException {
        if (sdkId == null || sdkId.length() == 0) {
            throw new IllegalArgumentException("The sdkId must not be null or empty.");
        }
        if (this.sdkProviderProperties == null) {
            return null;
        }
        return this.sdkProviderProperties.get(sdkId);
    }

    @Override
    public void setJadFileName(String jadFileName) {
        this.jadFileName = jadFileName.replace(' ', '_');
    }

    @Override
    public void setMTJRuntimeList(MTJRuntimeList configurations) throws IllegalArgumentException {
        if (configurations == null) {
            throw new IllegalArgumentException("The runtime list must not be null.");
        }
        this.configurations = configurations;
    }

    @Override
    public void setSignatureProperties(ISignatureProperties p) {
        if (this.signatureProps == null) {
            this.signatureProps = new SignatureProperties();
        }
        this.signatureProps.copy(p);
    }

    private Cipher createCipher(int opmode) throws GeneralSecurityException {
        PBEKeySpec keySpec = new PBEKeySpec("MTJ".toCharArray());
        SecretKeyFactory keyFactory = SecretKeyFactory.getInstance("PBEWithMD5AndDES");
        SecretKey secretKey = keyFactory.generateSecret(keySpec);
        PBEParameterSpec paramSpec = new PBEParameterSpec(CRYPTO_SALT, 10);
        Cipher cipher = Cipher.getInstance(secretKey.getAlgorithm());
        cipher.init(opmode, (Key)secretKey, paramSpec);
        return cipher;
    }

    private String decodePassword(Element base, String subElementName) {
        Element subElement = XMLUtils.getFirstElementWithTagName(base, subElementName);
        if (subElement == null) {
            return null;
        }
        String encoded = XMLUtils.getElementText(subElement);
        byte[] cryptBytes = Base64EncDec.decode(encoded);
        if (cryptBytes == null) {
            return null;
        }
        try {
            byte[] passwordBytes = null;
            Cipher cipher = this.createCipher(2);
            passwordBytes = cipher.doFinal(cryptBytes);
            return new String(passwordBytes, "UTF8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
        }
        catch (GeneralSecurityException generalSecurityException) {}
        return null;
    }

    private String encodePassword(String password) {
        if (password == null) {
            return "";
        }
        try {
            byte[] passwordBytes = password.getBytes("UTF8");
            byte[] cryptBytes = null;
            Cipher cipher = this.createCipher(1);
            cryptBytes = cipher.doFinal(passwordBytes);
            return Base64EncDec.encode(cryptBytes);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
        }
        catch (GeneralSecurityException generalSecurityException) {}
        return "";
    }

    private IFile getStoreFile() {
        IFile storeFile = null;
        if (this.project != null) {
            storeFile = this.project.getFile(".mtj");
        }
        return storeFile;
    }

    private IFile getStoreIFile() {
        return this.project.getFile(".mtj");
    }

    private void initializeToDefaults() {
        this.signatureProps = new SignatureProperties();
        this.configurations = new MTJRuntimeList();
    }

    private boolean loadConfigsCompatibly(Element rootElement) throws PersistenceException {
        boolean changedDevice = this.loadDevice(rootElement);
        Element configsElement = XMLUtils.getFirstElementWithTagName(rootElement, "configurations");
        this.configurations = configsElement != null ? new MTJRuntimeList(configsElement) : new MTJRuntimeList();
        if (this.configurations.isEmpty() && this.device != null) {
            this.setDeviceIntoActiveConfig(this.device);
        }
        boolean configsGotChanged = false;
        for (MTJRuntime config : this.configurations) {
            boolean bl = configsGotChanged = config.isMatched() ? true : configsGotChanged;
        }
        return changedDevice || configsGotChanged;
    }

    private boolean loadConfigurations(Element rootElement) throws PersistenceException {
        boolean changedConfig = this.loadConfigsCompatibly(rootElement);
        MTJRuntime activeConfig = this.configurations.getActiveMTJRuntime();
        if (activeConfig != null) {
            this.device = this.configurations.getActiveMTJRuntime().getDevice();
        }
        return changedConfig;
    }

    private boolean loadDevice(Element rootElement) throws PersistenceException {
        boolean loadedDifferentDevice = false;
        Element deviceElement = XMLUtils.getFirstElementWithTagName(rootElement, "device");
        if (deviceElement != null) {
            String deviceGroup = deviceElement.getAttribute("group");
            String deviceName = deviceElement.getAttribute("name");
            this.device = MTJCore.getDeviceRegistry().getDevice(deviceGroup, deviceName);
            if (this.device == null) {
                this.device = MTJRuntimeListUtils.match(deviceGroup, deviceName);
                if (this.device != null) {
                    MTJLogger.log(1, String.valueOf(deviceGroup) + "/" + deviceName + " was converted to " + this.device.toString());
                    loadedDifferentDevice = true;
                }
            }
        }
        return loadedDifferentDevice;
    }

    private void loadMetaData() throws CoreException {
        boolean bRewrite = this.loadMetaDataFromFile();
        if (this.signatureProps == null) {
            this.signatureProps = new SignatureProperties();
            this.signatureProps.clear();
            bRewrite = true;
        }
        if (bRewrite) {
            WorkspaceJob job = new WorkspaceJob("Rewrite Project Metadata"){

                public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                    IJavaProject javaProject = JavaCore.create((IProject)MetaData.this.project);
                    IMidletSuiteProject midletProject = MidletSuiteFactory.getMidletSuiteProject(javaProject);
                    midletProject.refreshClasspath(monitor);
                    MetaData.this.saveMetaData();
                    PreverificationBuilder.cleanProject(midletProject.getProject(), true, monitor);
                    midletProject.getProject().build(6, monitor);
                    return Status.OK_STATUS;
                }
            };
            job.schedule();
        }
    }

    private boolean loadMetaDataFromFile() throws CoreException {
        IPath location;
        boolean alteredConfig = false;
        IFile storeFile = this.getStoreFile();
        if (storeFile == null) {
            this.initializeToDefaults();
        }
        if ((location = storeFile.getLocation()) != null && location.toFile().exists()) {
            try {
                File localFile = location.toFile();
                Document document = XMLUtils.readDocument(localFile);
                if (document == null) {
                    return alteredConfig;
                }
                this.rootXmlElement = document.getDocumentElement();
                if (!this.rootXmlElement.getNodeName().equals("mtjMetadata")) {
                    return alteredConfig;
                }
                this.version = XMLUtils.getVersion(document);
                this.jadFileName = this.rootXmlElement.getAttribute("jad");
                alteredConfig = this.loadConfigurations(this.rootXmlElement);
                this.loadSignatureProperties(this.rootXmlElement);
                this.loadSDKProviderProperties(this.rootXmlElement);
            }
            catch (ParserConfigurationException pce) {
                MTJStatusHandler.throwCoreException(2, 99999, pce);
            }
            catch (SAXException se) {
                MTJStatusHandler.throwCoreException(2, 99999, se);
            }
            catch (IOException ioe) {
                MTJStatusHandler.throwCoreException(2, 99999, ioe);
            }
            catch (PersistenceException e) {
                MTJStatusHandler.throwCoreException(2, 99999, e);
            }
        } else {
            this.initializeToDefaults();
        }
        return alteredConfig;
    }

    private void loadSignatureProperties(Element rootElement) throws CoreException {
        SignatureProperties sp = new SignatureProperties();
        Element signRoot = XMLUtils.getFirstElementWithTagName(rootElement, "signing");
        if (signRoot == null) {
            return;
        }
        String attr = signRoot.getAttribute("projectSpecific");
        if (attr == null) {
            return;
        }
        sp.setProjectSpecific(Boolean.valueOf(attr));
        attr = signRoot.getAttribute("signProject");
        if (attr == null) {
            return;
        }
        sp.setSignProject(Boolean.valueOf(attr));
        this.signatureProps = sp;
        Element e = XMLUtils.getFirstElementWithTagName(signRoot, "keystore");
        if (e != null) {
            sp.setKeyStoreDisplayPath(XMLUtils.getElementText(e));
        }
        if ((e = XMLUtils.getFirstElementWithTagName(signRoot, "alias")) != null) {
            sp.setKeyAlias(XMLUtils.getElementText(e));
        }
        if ((e = XMLUtils.getFirstElementWithTagName(signRoot, "provider")) != null) {
            sp.setKeyStoreProvider(XMLUtils.getElementText(e));
        }
        if ((e = XMLUtils.getFirstElementWithTagName(signRoot, "keystoreType")) != null) {
            sp.setKeyStoreType(XMLUtils.getElementText(e));
        }
        if ((e = XMLUtils.getFirstElementWithTagName(signRoot, "passwords")) != null) {
            attr = e.getAttribute("storePasswords");
            int nMethod = 0;
            if (attr != null) {
                try {
                    nMethod = Integer.valueOf(attr);
                }
                catch (Exception exception) {}
            }
            switch (nMethod) {
                case 1: {
                    sp.setPasswordStorageMethod(nMethod);
                    ISecurePreferences root = SecurePreferencesFactory.getDefault();
                    String url = Utils.getKeyringURL(this.project);
                    if (!root.nodeExists(url)) break;
                    ISecurePreferences preferences = root.node(url);
                    try {
                        sp.setKeyStorePassword(preferences.get("KeystorePass", ""));
                        sp.setKeyPassword(preferences.get("KeyPass", ""));
                    }
                    catch (StorageException e1) {
                        this.signatureProps = sp;
                        MTJCoreErrors.throwCoreExceptionError(7676, "Could not re password into keyring,", e1);
                    }
                    break;
                }
                case 2: {
                    sp.setPasswordStorageMethod(nMethod);
                    sp.setKeyStorePassword(this.decodePassword(e, "keystore"));
                    sp.setKeyPassword(this.decodePassword(e, "key"));
                    break;
                }
                default: {
                    sp.setPasswordStorageMethod(0);
                    sp.setKeyStorePassword(null);
                    sp.setKeyPassword(null);
                }
            }
        }
    }

    private void loadSDKProviderProperties(Element rootElement) throws PersistenceException {
        Element sdkProvidersPropertiesElement = XMLUtils.getFirstElementWithTagName(rootElement, "sdkProviderProperties");
        if (sdkProvidersPropertiesElement == null) {
            this.sdkProviderProperties = null;
            return;
        }
        NodeList sdkNodes = sdkProvidersPropertiesElement.getElementsByTagName("sdk");
        int s = 0;
        while (s < sdkNodes.getLength()) {
            Element sdkElement = (Element)sdkNodes.item(s);
            String sdkId = sdkElement.getAttribute("id");
            NodeList propertyNodes = sdkElement.getElementsByTagName("property");
            Properties properties = new Properties();
            int p = 0;
            while (p < propertyNodes.getLength()) {
                Element propertyElement = (Element)propertyNodes.item(p);
                String name = propertyElement.getAttribute("name");
                String value = propertyElement.getAttribute("value");
                properties.put(name, value);
                ++p;
            }
            if (this.sdkProviderProperties == null) {
                this.sdkProviderProperties = new Hashtable();
            } else {
                this.sdkProviderProperties.remove(sdkId);
            }
            this.sdkProviderProperties.put(sdkId, properties);
            ++s;
        }
    }

    private void removeChildXmlElement(Element parent, String name) {
        Element child = XMLUtils.getFirstElementWithTagName(parent, name);
        if (child != null) {
            child.getParentNode().removeChild(child);
        }
    }

    private void saveConfigurations(Element rootElement) {
        if (this.configurations == null) {
            return;
        }
        this.removeChildXmlElement(rootElement, "configurations");
        Element configsElement = XMLUtils.createChild(rootElement, "configurations");
        for (MTJRuntime config : this.configurations) {
            Element configElement = XMLUtils.createChild(configsElement, "configuration");
            configElement.setAttribute("name", config.getName());
            configElement.setAttribute("active", String.valueOf(config.isActive()));
            this.saveDevice(configElement, config.getDevice());
            this.saveSymbolSet(configElement, config.getSymbolSet());
            this.saveWorkspaceSymbolSets(configElement, config.getWorkspaceScopeSymbolSets());
        }
    }

    private void saveDevice(Element rootElement, IDevice device) {
        if (device == null) {
            return;
        }
        this.removeChildXmlElement(rootElement, "device");
        Element newDeviceElement = XMLUtils.createChild(rootElement, "device");
        newDeviceElement.setAttribute("group", device.getSDKName());
        newDeviceElement.setAttribute("name", device.getName());
    }

    private void saveMetaDataToFile(IFile storeFile) throws CoreException {
        try {
            String pluginVersion = MTJCore.getMTJCoreVersion();
            Version newVersion = new Version(pluginVersion);
            if (this.rootXmlElement == null) {
                this.rootXmlElement = XMLUtils.createRootElement("mtjMetadata", newVersion);
            } else {
                this.rootXmlElement.setAttribute("version", newVersion.toString());
            }
            if (this.jadFileName != null) {
                this.rootXmlElement.setAttribute("jad", this.jadFileName);
            }
            this.saveDevice(this.rootXmlElement, this.device);
            this.saveSignatureProps(this.rootXmlElement);
            this.saveConfigurations(this.rootXmlElement);
            this.saveSDKProviderProperties(this.rootXmlElement);
            File localFile = storeFile.getLocation().toFile();
            XMLUtils.writeDocument(localFile, this.rootXmlElement.getOwnerDocument());
            this.version = newVersion;
            this.getStoreIFile().refreshLocal(1, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (ParserConfigurationException pce) {
            MTJStatusHandler.throwCoreException(2, 99999, pce);
        }
        catch (TransformerException te) {
            MTJStatusHandler.throwCoreException(2, 99999, te);
        }
        catch (IOException ioe) {
            MTJStatusHandler.throwCoreException(2, 99999, ioe);
        }
    }

    private void saveSignatureProps(Element rootElement) throws CoreException {
        this.removeChildXmlElement(rootElement, "signing");
        Element newSignRoot = XMLUtils.createChild(rootElement, "signing");
        boolean bSign = this.signatureProps.isSignProject();
        newSignRoot.setAttribute("signProject", Boolean.toString(bSign));
        boolean bSpec = this.signatureProps.isProjectSpecific();
        newSignRoot.setAttribute("projectSpecific", Boolean.toString(bSpec));
        XMLUtils.createTextElement(newSignRoot, "alias", this.signatureProps.getKeyAlias());
        if (!bSpec) {
            return;
        }
        XMLUtils.createTextElement(newSignRoot, "keystore", this.signatureProps.getKeyStoreDisplayPath());
        XMLUtils.createTextElement(newSignRoot, "provider", this.signatureProps.getKeyStoreProvider());
        XMLUtils.createTextElement(newSignRoot, "keystoreType", this.signatureProps.getKeyStoreType());
        Element passRoot = XMLUtils.createChild(newSignRoot, "passwords");
        passRoot.setAttribute("storePasswords", Integer.toString(this.signatureProps.getPasswordStorageMethod()));
        ISecurePreferences root = SecurePreferencesFactory.getDefault();
        String url = Utils.getKeyringURL(this.project);
        if (root.nodeExists(url)) {
            ISecurePreferences preferences = root.node(url);
            preferences.clear();
        }
        switch (this.signatureProps.getPasswordStorageMethod()) {
            case 2: {
                XMLUtils.createTextElement(passRoot, "keystore", this.encodePassword(this.signatureProps.getKeyStorePassword()));
                XMLUtils.createTextElement(passRoot, "key", this.encodePassword(this.signatureProps.getKeyPassword()));
                break;
            }
            case 1: {
                ISecurePreferences node = root.node(url);
                try {
                    node.put("KeystorePass", this.signatureProps.getKeyStorePassword(), false);
                    node.put("KeyPass", this.signatureProps.getKeyPassword(), false);
                }
                catch (StorageException e) {
                    MTJCoreErrors.throwCoreExceptionError(7676, "Could not save password into keyring,", e);
                }
                break;
            }
        }
    }

    private void saveSDKProviderProperties(Element rootElement) throws CoreException {
        if (this.sdkProviderProperties == null || this.sdkProviderProperties.isEmpty()) {
            return;
        }
        this.removeChildXmlElement(rootElement, "sdkProviderProperties");
        Element sdkProvidersPropertiesElement = XMLUtils.createChild(rootElement, "sdkProviderProperties");
        Enumeration<String> sdkProviderIds = this.sdkProviderProperties.keys();
        while (sdkProviderIds.hasMoreElements()) {
            String id = sdkProviderIds.nextElement();
            Properties properties = this.sdkProviderProperties.get(id);
            Element sdkElement = XMLUtils.createChild(sdkProvidersPropertiesElement, "sdk");
            sdkElement.setAttribute("id", id);
            Enumeration<?> propertyNames = properties.propertyNames();
            while (propertyNames.hasMoreElements()) {
                String name = (String)propertyNames.nextElement();
                String value = properties.getProperty(name);
                Element propertyElement = XMLUtils.createChild(sdkElement, "property");
                propertyElement.setAttribute("name", name);
                propertyElement.setAttribute("value", value);
            }
        }
    }

    private void saveSymbol(Element symbolSetElement, ISymbol symbol) {
        Element symbolElement = XMLUtils.createChild(symbolSetElement, "symbol");
        symbolElement.setAttribute("name", symbol.getName());
        symbolElement.setAttribute("value", symbol.getValue());
    }

    private void saveSymbolSet(Element configElement, ISymbolSet symbolSet) {
        if (symbolSet == null) {
            return;
        }
        Element symbolSetElement = XMLUtils.createChild(configElement, "symbolSet");
        symbolSetElement.setAttribute("name", symbolSet.getName());
        for (ISymbol symbol : symbolSet.getSymbols()) {
            this.saveSymbol(symbolSetElement, symbol);
        }
    }

    private void saveWorkspaceSymbolSets(Element configElement, List<ISymbolSet> workspaceScopeSymbolSets) {
        if (workspaceScopeSymbolSets == null || workspaceScopeSymbolSets.isEmpty()) {
            return;
        }
        for (ISymbolSet s : workspaceScopeSymbolSets) {
            Element symbolSetElement = XMLUtils.createChild(configElement, "workspaceSymbolSet");
            symbolSetElement.setAttribute("name", s.getName());
        }
    }

    private void setDeviceIntoActiveConfig(IDevice device) {
        MTJRuntime activeConfig = this.configurations.getActiveMTJRuntime();
        if (activeConfig != null) {
            activeConfig.setDevice(device);
            return;
        }
        if (activeConfig == null && !this.configurations.isEmpty()) {
            activeConfig = (MTJRuntime)this.configurations.get(0);
        }
        if (activeConfig == null) {
            activeConfig = new MTJRuntime(device.getName());
            activeConfig.setSymbolSet(device.getSymbolSet());
        }
        activeConfig.setActive(true);
        activeConfig.setDevice(device);
        this.configurations.add(activeConfig);
    }
}

