/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.sdk.device;

import org.eclipse.mtj.core.MTJCore;
import org.eclipse.mtj.core.persistence.PersistenceException;
import org.eclipse.mtj.core.sdk.device.IDevice;
import org.eclipse.mtj.internal.core.sdk.device.DeviceMatchCache;
import org.eclipse.mtj.internal.core.sdk.device.IDeviceMatchCache;
import org.eclipse.mtj.internal.core.sdk.device.IDeviceMatcher;

public class CachedDeviceMatcher
implements IDeviceMatcher {
    public IDevice match(String deviceGroup, String deviceName) {
        String[] cachedValue = this.getCachedValue(deviceGroup, deviceName);
        if (cachedValue != null) {
            try {
                IDevice cachedDevice = MTJCore.getDeviceRegistry().getDevice(cachedValue[0], cachedValue[1]);
                return cachedDevice;
            }
            catch (PersistenceException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private String[] getCachedValue(String deviceGroup, String deviceName) {
        IDeviceMatchCache cache = DeviceMatchCache.getInstance();
        String[] cachedValue = cache.getValueFromCache(cache.createKey(deviceGroup, deviceName));
        return cachedValue;
    }

    public String[] match(String configurationName, String deviceGroup, String deviceName) {
        String[] cachedValue = this.getCachedValue(deviceGroup, deviceName);
        if (cachedValue != null) {
            return new String[]{cachedValue[1], cachedValue[0], cachedValue[1]};
        }
        return null;
    }
}

