/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.sdk.device.midp;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.eclipse.mtj.core.sdk.device.IAPI;
import org.eclipse.mtj.core.sdk.device.midp.MIDPAPIType;
import org.eclipse.mtj.internal.core.sdk.device.midp.MIDPAPI;
import org.eclipse.mtj.internal.core.sdk.device.midp.UEIAPIManifestAttributes;
import org.osgi.framework.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class APIRegistry {
    public static List<IAPI> getAPIs(File jarFile) {
        HashMap<String, IAPI> apis;
        block16: {
            apis = new HashMap<String, IAPI>();
            JarFile jar = null;
            try {
                try {
                    jar = new JarFile(jarFile);
                    IAPI api = APIRegistry.createAPIFromManifest(jar);
                    if (api != null) {
                        apis.put(api.toString(), api);
                    }
                }
                catch (IOException iOException) {
                    if (jar != null) {
                        try {
                            jar.close();
                        }
                        catch (IOException iOException2) {}
                    }
                    break block16;
                }
            }
            catch (Throwable throwable) {
                if (jar != null) {
                    try {
                        jar.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (jar != null) {
                try {
                    jar.close();
                }
                catch (IOException iOException) {}
            }
        }
        if (apis.size() == 0) {
            IAPI unknown = APIRegistry.createUnknownAPI(jarFile);
            apis.put(unknown.getIdentifier(), unknown);
        }
        ArrayList<IAPI> result = new ArrayList<IAPI>(apis.values());
        return result;
    }

    private static IAPI createAPIFromManifest(JarFile jarFile) throws IOException {
        Attributes attributes;
        String identifier;
        MIDPAPI api = null;
        Manifest manifest = jarFile.getManifest();
        if (manifest != null && (identifier = (attributes = manifest.getMainAttributes()).getValue(UEIAPIManifestAttributes.API.toString())) != null) {
            api = new MIDPAPI();
            api.setIdentifier(identifier);
            api.setName(attributes.getValue(UEIAPIManifestAttributes.API_NAME.toString()));
            api.setType(APIRegistry.getTypeFromManifest(attributes));
            api.setVersion(APIRegistry.getVersionFromManifest(attributes));
        }
        return api;
    }

    private static IAPI createUnknownAPI(File libraryFile) {
        MIDPAPI api = new MIDPAPI();
        api.setIdentifier(libraryFile.getName());
        api.setName("Unknown Library");
        api.setType(MIDPAPIType.UNKNOWN);
        api.setVersion(new Version("1.0"));
        return api;
    }

    private static MIDPAPIType getTypeFromManifest(Attributes attributes) {
        MIDPAPIType type = MIDPAPIType.UNKNOWN;
        String typeString = attributes.getValue(UEIAPIManifestAttributes.API_TYPE.toString());
        if (typeString == null || typeString.equalsIgnoreCase(MIDPAPIType.OPTIONAL.toString())) {
            type = MIDPAPIType.OPTIONAL;
        } else if (typeString.equalsIgnoreCase(MIDPAPIType.PROFILE.toString())) {
            type = MIDPAPIType.PROFILE;
        } else if (typeString.equalsIgnoreCase(MIDPAPIType.CONFIGURATION.toString())) {
            type = MIDPAPIType.CONFIGURATION;
        }
        return type;
    }

    private static Version getVersionFromManifest(Attributes attributes) {
        Version version = null;
        String versionString = attributes.getValue(UEIAPIManifestAttributes.API_VERSION.toString());
        version = versionString != null ? new Version(versionString) : new Version("0.0.0");
        return version;
    }

    private APIRegistry() {
    }
}

