/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.text.l10n;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.mtj.internal.core.MTJPluginSchemas;
import org.eclipse.mtj.internal.core.Messages;
import org.eclipse.mtj.internal.core.text.IDocumentElementNode;
import org.eclipse.mtj.internal.core.text.l10n.L10nEntry;
import org.eclipse.mtj.internal.core.text.l10n.L10nMarkerError;
import org.eclipse.mtj.internal.core.text.l10n.L10nModel;
import org.eclipse.mtj.internal.core.text.l10n.L10nObject;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class L10nLocale
extends L10nObject {
    private static final long serialVersionUID = 1L;
    private Vector<L10nEntry> entryList = new Vector();
    private Schema schema;

    public L10nLocale(L10nModel model) {
        super(model, "locale");
    }

    @Override
    public boolean canBeParent() {
        return true;
    }

    public String getLanguageCode() {
        return this.getXMLAttributeValue("language");
    }

    public String getCountryCode() {
        return this.getXMLAttributeValue("country");
    }

    public void setLanguageCode(String lc) {
        this.setXMLAttribute("language", lc);
    }

    public void setCountryCode(String cc) {
        this.setXMLAttribute("country", cc);
    }

    public String getLocaleName() {
        this.migrateFromPrevVersion();
        return NLS.bind((String)"{0}-{1}", (Object[])new String[]{this.getLanguageCode(), this.getCountryCode()});
    }

    @Override
    public String getName() {
        return this.getLocaleName();
    }

    @Override
    public int getType() {
        return 1;
    }

    @Override
    public void validate() {
        if (!this.validateLocaleSchema()) {
            IDocumentElementNode[] entries = this.getChildNodes();
            int i = 0;
            while (i < entries.length) {
                block13: {
                    L10nEntry entry;
                    try {
                        entry = (L10nEntry)entries[i];
                    }
                    catch (Exception exception) {
                        break block13;
                    }
                    entry.validate();
                }
                ++i;
            }
        } else {
            String code;
            String[] countries = Locale.getISOCountries();
            String[] languages = Locale.getISOLanguages();
            String lc = this.getLanguageCode();
            String cc = this.getCountryCode();
            boolean ccValid = false;
            boolean lcValid = false;
            String[] stringArray = countries;
            int n = countries.length;
            int n2 = 0;
            while (n2 < n) {
                code = stringArray[n2];
                if (code.equalsIgnoreCase(cc)) {
                    ccValid = true;
                    break;
                }
                ++n2;
            }
            stringArray = languages;
            n = languages.length;
            n2 = 0;
            while (n2 < n) {
                code = stringArray[n2];
                if (code.equalsIgnoreCase(lc)) {
                    lcValid = true;
                    break;
                }
                ++n2;
            }
            String message = "";
            if (!ccValid || !lcValid) {
                if (!lcValid) {
                    message = Messages.L10nLocale_0;
                }
                if (!ccValid) {
                    message = String.valueOf(message) + Messages.L10nLocale_2;
                }
                this.setStatus((IStatus)new Status(4, "org.eclipse.mtj.core", message));
            } else {
                this.setStatus((IStatus)new Status(0, "org.eclipse.mtj.core", "Valid Locale"));
            }
            this.syncronizeEntryStates();
        }
    }

    private void syncronizeEntryStates() {
        IDocumentElementNode[] entryNodes = this.getChildNodes();
        LinkedList<L10nEntry> cache = new LinkedList<L10nEntry>();
        IDocumentElementNode[] iDocumentElementNodeArray = entryNodes;
        int n = entryNodes.length;
        int n2 = 0;
        while (n2 < n) {
            block9: {
                L10nEntry entry;
                IDocumentElementNode entryNode = iDocumentElementNodeArray[n2];
                try {
                    entry = (L10nEntry)entryNode;
                }
                catch (Exception exception) {
                    break block9;
                }
                if (!cache.contains(entry)) {
                    List<L10nEntry> duplicates = this.findDuplicatedEntries(entry);
                    if (duplicates.size() > 0) {
                        int j = 0;
                        while (j < duplicates.size()) {
                            block10: {
                                L10nEntry duplicate;
                                try {
                                    duplicate = duplicates.get(j);
                                }
                                catch (Exception exception) {
                                    break block10;
                                }
                                duplicate.setStatus((IStatus)new Status(4, "org.eclipse.mtj.core", Messages.L10nLocale_4));
                                cache.add(duplicate);
                            }
                            ++j;
                        }
                        entry.setStatus((IStatus)new Status(4, "org.eclipse.mtj.core", Messages.L10nLocale_5));
                    } else {
                        entry.setStatus((IStatus)new Status(0, "org.eclipse.mtj.core", null));
                    }
                }
            }
            ++n2;
        }
    }

    private List<L10nEntry> findDuplicatedEntries(L10nLocale locale, String key) {
        IDocumentElementNode[] nodes;
        LinkedList<L10nEntry> duplicates = new LinkedList<L10nEntry>();
        IDocumentElementNode[] iDocumentElementNodeArray = nodes = locale.getChildNodes();
        int n = nodes.length;
        int n2 = 0;
        while (n2 < n) {
            L10nEntry entry;
            IDocumentElementNode node = iDocumentElementNodeArray[n2];
            if (node instanceof L10nEntry && (entry = (L10nEntry)node) != null && entry.getKey() != null && key != null && entry.getKey().toUpperCase().equals(key.toUpperCase())) {
                duplicates.add(entry);
            }
            ++n2;
        }
        return duplicates;
    }

    public List<L10nEntry> findDuplicatedEntries(L10nEntry localeEntry) {
        List<L10nEntry> duplicates = this.findDuplicatedEntries((L10nLocale)localeEntry.getParent(), localeEntry.getKey());
        duplicates.remove(localeEntry);
        return duplicates;
    }

    public L10nEntry getEntry(String key) {
        IDocumentElementNode[] nodes;
        L10nEntry result = null;
        IDocumentElementNode[] iDocumentElementNodeArray = nodes = this.getChildNodes();
        int n = nodes.length;
        int n2 = 0;
        while (n2 < n) {
            IDocumentElementNode node = iDocumentElementNodeArray[n2];
            L10nEntry entry = (L10nEntry)node;
            if (entry.getKey().toUpperCase().equals(key.toUpperCase())) {
                result = entry;
                break;
            }
            ++n2;
        }
        return result;
    }

    private void migrateFromPrevVersion() {
        boolean fail;
        block7: {
            fail = false;
            String name = this.getXMLAttributeValue("name");
            if (name != null) {
                if (this.getLanguageCode() == null && this.getCountryCode() == null) {
                    try {
                        StringTokenizer tokenizer = new StringTokenizer(name, "-");
                        if (tokenizer.countTokens() == 2) {
                            this.setLanguageCode(tokenizer.nextToken());
                            this.setCountryCode(tokenizer.nextToken());
                            break block7;
                        }
                        fail = true;
                    }
                    catch (Exception exception) {
                        fail = true;
                    }
                } else {
                    this.setXMLAttribute("name", null);
                }
            }
        }
        if (fail) {
            this.setStatus((IStatus)new Status(4, "org.eclipse.mtj.core", Messages.L10nLocale_7));
        }
    }

    public Vector<L10nMarkerError> getMarkerErrors() {
        IDocumentElementNode[] entryNodes = this.getChildNodes();
        Vector<L10nMarkerError> markerErrors = new Vector<L10nMarkerError>();
        int errorLine = -1;
        int i = 0;
        while (i < entryNodes.length) {
            block5: {
                try {
                    L10nEntry entry = (L10nEntry)entryNodes[i];
                    if (entry.getStatus().isOK()) break block5;
                    try {
                        int offSet = this.getModel().getDocument().getLineOfOffset(entry.getOffset());
                        int length = entry.getLength();
                        errorLine = offSet + this.getModel().getDocument().getNumberOfLines(entry.getOffset(), length);
                    }
                    catch (BadLocationException badLocationException) {
                        break block5;
                    }
                    L10nMarkerError marker = new L10nMarkerError(entry.getStatus().getMessage(), errorLine);
                    markerErrors.add(marker);
                }
                catch (Exception exception) {}
            }
            ++i;
        }
        return markerErrors;
    }

    public L10nEntry createEntry() {
        L10nEntry entry = null;
        entry = new L10nEntry(this.getModel());
        this.entryList.add(entry);
        return entry;
    }

    @Override
    public IDocumentElementNode removeChildNode(IDocumentElementNode child, boolean fireEvent) {
        this.entryList.remove(child);
        return super.removeChildNode(child, fireEvent);
    }

    private boolean validateLocaleSchema() {
        boolean isOK = true;
        String doc = this.toString();
        BufferedInputStream is = null;
        try {
            is = new BufferedInputStream(new ByteArrayInputStream(doc.getBytes("UTF-8")));
            String schemaLang = "http://www.w3.org/2001/XMLSchema";
            SchemaFactory factory = SchemaFactory.newInstance(schemaLang);
            if (this.schema == null) {
                this.schema = factory.newSchema(MTJPluginSchemas.getInstance().create("locale.xsd"));
            }
            Validator validator = this.schema.newValidator();
            validator.validate(new StreamSource(is));
            Status status = new Status(0, "org.eclipse.mtj.core", null);
            this.setStatus((IStatus)status);
        }
        catch (Exception ex) {
            Status status = new Status(4, "org.eclipse.mtj.core", ex.getMessage(), (Throwable)ex);
            this.setStatus((IStatus)status);
            isOK = false;
        }
        return isOK;
    }
}

