/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.util;

import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.mtj.core.MTJCore;
import org.eclipse.mtj.internal.core.util.IClasspathEntryVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClasspathEntryVisitorRunner {
    private boolean breadthFirst;

    public ClasspathEntryVisitorRunner() {
        this(false);
    }

    public ClasspathEntryVisitorRunner(boolean breadthFirst) {
        this.breadthFirst = breadthFirst;
    }

    public void run(IJavaProject javaProject, IClasspathEntryVisitor entryVisitor, IProgressMonitor monitor) throws CoreException {
        if (javaProject != null) {
            IClasspathEntry[] entries;
            ArrayList<IJavaProject> breadthFirstProjects = new ArrayList<IJavaProject>();
            IClasspathEntry[] iClasspathEntryArray = entries = javaProject.getRawClasspath();
            int n = entries.length;
            int n2 = 0;
            while (n2 < n) {
                IClasspathEntry entry = iClasspathEntryArray[n2];
                this.visitEntry(javaProject, entry, entryVisitor, breadthFirstProjects, monitor);
                ++n2;
            }
            for (IJavaProject jProject : breadthFirstProjects) {
                this.run(jProject, entryVisitor, monitor);
            }
        }
    }

    private void visitContainerEntry(IJavaProject javaProject, IClasspathEntry entry, IClasspathEntryVisitor entryVisitor, ArrayList<IJavaProject> breadthFirstProjects, IProgressMonitor monitor) throws CoreException {
        IPath containerPath = entry.getPath();
        if (entryVisitor.visitContainerBegin(entry, javaProject, containerPath, monitor)) {
            IClasspathEntry[] entries;
            IClasspathContainer cpContainer = JavaCore.getClasspathContainer((IPath)containerPath, (IJavaProject)javaProject);
            IClasspathEntry[] iClasspathEntryArray = entries = cpContainer.getClasspathEntries();
            int n = entries.length;
            int n2 = 0;
            while (n2 < n) {
                IClasspathEntry entry2 = iClasspathEntryArray[n2];
                this.visitEntry(javaProject, entry2, entryVisitor, breadthFirstProjects, monitor);
                ++n2;
            }
            entryVisitor.visitContainerEnd(entry, javaProject, containerPath, monitor);
        }
    }

    private void visitEntry(IJavaProject javaProject, IClasspathEntry entry, IClasspathEntryVisitor entryVisitor, ArrayList<IJavaProject> breadthFirstProjects, IProgressMonitor monitor) throws CoreException {
        switch (entry.getEntryKind()) {
            case 5: {
                this.visitContainerEntry(javaProject, entry, entryVisitor, breadthFirstProjects, monitor);
                break;
            }
            case 1: {
                this.visitLibraryEntry(javaProject, entry, entryVisitor, monitor);
                break;
            }
            case 2: {
                this.visitProjectEntry(javaProject, entry, entryVisitor, breadthFirstProjects, monitor);
                break;
            }
            case 3: {
                this.visitSourceEntry(javaProject, entry, entryVisitor, monitor);
                break;
            }
            case 4: {
                this.visitVariableEntry(javaProject, entry, entryVisitor, breadthFirstProjects, monitor);
            }
        }
    }

    private void visitLibraryEntry(IJavaProject javaProject, IClasspathEntry entry, IClasspathEntryVisitor entryVisitor, IProgressMonitor monitor) throws CoreException {
        entryVisitor.visitLibraryEntry(entry, javaProject, monitor);
    }

    private void visitProjectEntry(IJavaProject javaProject, IClasspathEntry entry, IClasspathEntryVisitor entryVisitor, ArrayList<IJavaProject> breadthFirstProjects, IProgressMonitor monitor) throws CoreException {
        IPath projectPath = entry.getPath();
        IProject project = (IProject)MTJCore.getWorkspace().getRoot().findMember(projectPath);
        if (project == null) {
            return;
        }
        IJavaProject jProject = JavaCore.create((IProject)project);
        if (entryVisitor.visitProject(entry, javaProject, jProject, monitor)) {
            if (this.breadthFirst) {
                breadthFirstProjects.add(jProject);
            } else {
                this.run(jProject, entryVisitor, monitor);
            }
        }
    }

    private void visitSourceEntry(IJavaProject javaProject, IClasspathEntry entry, IClasspathEntryVisitor entryVisitor, IProgressMonitor monitor) throws CoreException {
        entryVisitor.visitSourceEntry(entry, javaProject, monitor);
    }

    private void visitVariableEntry(IJavaProject javaProject, IClasspathEntry entry, IClasspathEntryVisitor entryVisitor, ArrayList<IJavaProject> breadthFirstProjects, IProgressMonitor monitor) throws CoreException {
        IClasspathEntry entry2;
        String variableName = entry.getPath().lastSegment();
        if (entryVisitor.visitVariable(entry, javaProject, variableName, monitor) && (entry2 = JavaCore.getResolvedClasspathEntry((IClasspathEntry)entry)) != null) {
            this.visitEntry(javaProject, entry2, entryVisitor, breadthFirstProjects, monitor);
        }
    }
}

