/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.mtj.core.project.IMTJProject;
import org.eclipse.mtj.core.project.runtime.MTJRuntime;
import org.eclipse.mtj.core.project.runtime.MTJRuntimeList;
import org.eclipse.mtj.internal.core.build.MTJBuildProperties;
import org.eclipse.mtj.internal.core.project.midp.MidletSuiteFactory;
import org.eclipse.mtj.internal.core.util.Utils;
import org.eclipse.mtj.internal.core.util.log.MTJLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MTJBuildPropertiesResourceListener
implements IResourceChangeListener {
    public void resourceChanged(IResourceChangeEvent event) {
        IResourceDelta delta = event.getDelta();
        if (delta == null) {
            return;
        }
        try {
            IProject project;
            MTJBuildPropertiesVisitor visitor = new MTJBuildPropertiesVisitor();
            delta.accept((IResourceDeltaVisitor)visitor);
            IResource properties = visitor.getBuildProperties();
            if (properties != null && (project = properties.getProject()) != null) {
                IMTJProject mtjProject = MidletSuiteFactory.getMidletSuiteProject(project.getName());
                if (mtjProject == null) {
                    return;
                }
                MTJBuildProperties.getBuildProperties(mtjProject).load();
            }
        }
        catch (CoreException e) {
            MTJLogger.log(4, e);
        }
        try {
            AddsAndRemovesCollector collector = new AddsAndRemovesCollector();
            delta.accept((IResourceDeltaVisitor)collector);
            List<IResourceDelta> sourceDeltas = this.filterResourceDeltas(collector.getResourceDeltas());
            this.updateBuildProperties(sourceDeltas);
        }
        catch (Exception e) {
            MTJLogger.log(4, e);
        }
    }

    private void updateBuildProperties(List<IResourceDelta> sourceDeltas) throws IOException {
        for (IResourceDelta sourceDelta : sourceDeltas) {
            IResource resource = sourceDelta.getResource();
            IProject project = resource.getProject();
            if (project == null) {
                return;
            }
            if (!MidletSuiteFactory.isMidletSuiteProject(project)) continue;
            IMTJProject mtjProject = MidletSuiteFactory.getMidletSuiteProject(project.getName());
            MTJBuildProperties buildProperties = MTJBuildProperties.getBuildProperties(mtjProject);
            MTJRuntimeList runtimes = mtjProject.getRuntimeList();
            boolean hasChanged = false;
            for (MTJRuntime runtime : runtimes) {
                boolean hasMarkers;
                if (sourceDelta.getKind() == 2) {
                    boolean bl = hasMarkers = (sourceDelta.getFlags() & 0x2000) != 0;
                    if (hasMarkers) continue;
                    buildProperties.deleteResource(resource);
                    hasChanged = true;
                    continue;
                }
                if (sourceDelta.getKind() != 1) continue;
                boolean bl = hasMarkers = (sourceDelta.getFlags() & 0x1000) != 0;
                if (hasMarkers) continue;
                buildProperties.includeResource(resource, runtime);
                hasChanged = true;
            }
            if (!hasChanged) continue;
            buildProperties.store();
        }
    }

    private List<IResourceDelta> filterResourceDeltas(List<IResourceDelta> resourceDeltas) throws CoreException {
        ArrayList<IResourceDelta> sourceDeltas = new ArrayList<IResourceDelta>();
        for (IResourceDelta resourceDelta : resourceDeltas) {
            IResource resource = resourceDelta.getResource();
            IProject project = resource.getProject();
            if (!project.isAccessible() || !project.hasNature("org.eclipse.jdt.core.javanature")) continue;
            IJavaProject javaProject = JavaCore.create((IProject)project);
            IResource[] iResourceArray = Utils.getSourceFolders(javaProject);
            int n = iResourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResource folder = iResourceArray[n2];
                if (folder.getProjectRelativePath().isPrefixOf(resource.getProjectRelativePath())) {
                    sourceDeltas.add(resourceDelta);
                }
                ++n2;
            }
        }
        return sourceDeltas;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AddsAndRemovesCollector
    implements IResourceDeltaVisitor {
        private List<IResourceDelta> deltas = new ArrayList<IResourceDelta>();

        public boolean visit(IResourceDelta delta) throws CoreException {
            IResource resource = delta.getResource();
            int kind = delta.getKind();
            if ((kind == 1 || kind == 2) && resource.getProject() != null && resource.getType() == 1) {
                this.deltas.add(delta);
            }
            return true;
        }

        public List<IResourceDelta> getResourceDeltas() {
            return this.deltas;
        }
    }

    class MTJBuildPropertiesVisitor
    implements IResourceDeltaVisitor {
        private IResource properties;

        MTJBuildPropertiesVisitor() {
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            IResource properties;
            IResource resource;
            IProject project;
            boolean hasContentChanged;
            boolean bl = hasContentChanged = (delta.getFlags() & 0x100) != 0;
            if (delta.getKind() == 4 && hasContentChanged && (project = (resource = delta.getResource()).getProject()) != null && project.hasNature("org.eclipse.mtj.core.nature") && (properties = project.findMember("build.properties")) != null && properties.equals((Object)resource)) {
                this.properties = resource;
            }
            return this.properties == null;
        }

        public IResource getBuildProperties() {
            return this.properties;
        }
    }
}

