/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.actions.l10n;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.mtj.internal.core.l10n.L10nApi;
import org.eclipse.mtj.internal.core.text.l10n.L10nLocale;
import org.eclipse.mtj.internal.core.text.l10n.L10nLocales;
import org.eclipse.mtj.internal.core.text.l10n.L10nModel;
import org.eclipse.mtj.internal.core.text.l10n.L10nObject;
import org.eclipse.mtj.internal.core.util.log.MTJLogger;
import org.eclipse.mtj.internal.ui.MTJUIMessages;
import org.eclipse.mtj.internal.ui.actions.AbstractJavaProjectAction;
import org.eclipse.mtj.internal.ui.actions.l10n.EnableLocalizationAction;
import org.eclipse.mtj.internal.ui.dialog.StringLocalizationCandidatesDialog;
import org.eclipse.mtj.internal.ui.wizards.l10n.StringLocalizationWizard;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalizeStringsAction
extends AbstractJavaProjectAction {
    public void run(IAction action) {
        try {
            ICompilationUnit[] classes;
            L10nModel model;
            L10nLocales locales;
            IJavaProject javaProject = this.getJavaProject(this.selection);
            if (javaProject == null) {
                return;
            }
            IProject project = javaProject.getProject();
            if (!project.hasNature("org.eclipse.mtj.core.l10nNature")) {
                EnableLocalizationAction enableL10n = new EnableLocalizationAction();
                enableL10n.selectionChanged(action, (ISelection)new StructuredSelection((Object)javaProject));
                enableL10n.run(action);
                if (!project.hasNature("org.eclipse.mtj.core.l10nNature")) {
                    MessageDialog.openInformation((Shell)this.getShell(), (String)MTJUIMessages.LocalizeStringsAction_errorDialogTitle, (String)MTJUIMessages.LocalizeStringsAction_projectL10nNotEnabled);
                    return;
                }
            }
            if ((locales = (model = L10nApi.loadL10nModel((IProject)project)).getLocales()).getChildCount() == 0) {
                L10nLocale locale = new L10nLocale(model);
                locale.setLanguageCode("en");
                locale.setCountryCode("US");
                locales.addChild((L10nObject)locale);
                model.save();
            }
            if ((classes = this.getCandiateClasses()).length == 0) {
                return;
            }
            ICompilationUnit target = null;
            if (classes.length > 1) {
                StringLocalizationCandidatesDialog dialog = new StringLocalizationCandidatesDialog(this.getShell(), classes);
                if (dialog.open() == 0) {
                    target = dialog.getSelectedClass();
                }
            } else {
                target = classes[0];
            }
            if (target != null) {
                StringLocalizationWizard wizard = new StringLocalizationWizard(target, model);
                WizardDialog dialog = new WizardDialog(this.getShell(), (IWizard)wizard);
                dialog.create();
                dialog.open();
            }
        }
        catch (CoreException e) {
            MTJLogger.log((int)4, (Throwable)e);
        }
    }

    private ICompilationUnit[] getCandiateClasses() {
        ArrayList<ICompilationUnit> result = new ArrayList<ICompilationUnit>();
        if (this.selection != null && !this.selection.isEmpty()) {
            Object[] objects;
            Object[] objectArray = objects = this.selection.toArray();
            int n = objects.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n2];
                if (object instanceof ICompilationUnit) {
                    result.add((ICompilationUnit)object);
                } else if (object instanceof IPackageFragment) {
                    IPackageFragment ppackage = (IPackageFragment)object;
                    this.collectPackageClasses(result, ppackage);
                } else if (object instanceof IPackageFragmentRoot) {
                    IPackageFragmentRoot source = (IPackageFragmentRoot)object;
                    this.collectSourceClasses(result, source);
                } else if (object instanceof IJavaProject) {
                    IJavaProject javaProject = (IJavaProject)object;
                    this.collectProjectClasses(result, javaProject);
                }
                ++n2;
            }
        }
        return result.toArray(new ICompilationUnit[0]);
    }

    private void collectProjectClasses(List<ICompilationUnit> result, IJavaProject javaProject) {
        try {
            IPackageFragmentRoot[] roots;
            IPackageFragmentRoot[] iPackageFragmentRootArray = roots = javaProject.getPackageFragmentRoots();
            int n = roots.length;
            int n2 = 0;
            while (n2 < n) {
                IPackageFragmentRoot root = iPackageFragmentRootArray[n2];
                if (root.getKind() == 1) {
                    this.collectSourceClasses(result, root);
                }
                ++n2;
            }
        }
        catch (JavaModelException e) {
            MTJLogger.log((int)4, (Throwable)e);
        }
    }

    private void collectSourceClasses(List<ICompilationUnit> result, IPackageFragmentRoot source) {
        try {
            IJavaElement[] children;
            IJavaElement[] iJavaElementArray = children = source.getChildren();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                IJavaElement child = iJavaElementArray[n2];
                if (child instanceof IPackageFragment) {
                    this.collectPackageClasses(result, (IPackageFragment)child);
                }
                ++n2;
            }
        }
        catch (JavaModelException e) {
            MTJLogger.log((int)4, (Throwable)e);
        }
    }

    private void collectPackageClasses(List<ICompilationUnit> result, IPackageFragment ppackage) {
        try {
            IJavaElement[] children;
            IJavaElement[] iJavaElementArray = children = ppackage.getChildren();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                IJavaElement child = iJavaElementArray[n2];
                if (child instanceof IPackageFragment) {
                    this.collectPackageClasses(result, (IPackageFragment)child);
                } else if (child instanceof ICompilationUnit) {
                    result.add((ICompilationUnit)child);
                }
                ++n2;
            }
        }
        catch (JavaModelException e) {
            MTJLogger.log((int)4, (Throwable)e);
        }
    }

    @Override
    protected IJavaProject getJavaProject(Object selected) {
        IJavaProject javaProject = super.getJavaProject(selected);
        if (javaProject == null && selected instanceof IStructuredSelection) {
            Object object = this.selection.getFirstElement();
            if (object instanceof IJavaProject) {
                javaProject = (IJavaProject)object;
            } else if (object instanceof IJavaElement) {
                javaProject = ((IJavaElement)object).getJavaProject();
            }
        }
        return javaProject;
    }
}

