/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.editors.jad.form.pages;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.mtj.internal.ui.MTJUIMessages;
import org.eclipse.mtj.internal.ui.editors.jad.form.JADFormEditor;
import org.eclipse.mtj.ui.editors.jad.AbstractJADEditorPage;
import org.eclipse.mtj.ui.editors.jad.IManifestPreferenceStore;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class JADUserDefinedPropertiesEditorPage
extends AbstractJADEditorPage {
    private static final String NEW_KEY = "New_Key";
    private static final String NEW_VALUE = "New Value";
    private static final String PROP_KEY = "key";
    private static final String PROP_VALUE = "value";
    private static final String[] PROPERTIES = new String[]{"key", "value"};
    private static final List<String> PROPERTY_LIST = Arrays.asList(PROPERTIES);
    private static final String USER_DEFINED_PAGEID = "user_defined";
    private Button addButton;
    private Button removeButton;
    private TableViewer tableViewer;
    private List<KeyValuePair> userDefinedProperties = new ArrayList<KeyValuePair>();

    public JADUserDefinedPropertiesEditorPage() {
        super(USER_DEFINED_PAGEID, MTJUIMessages.JADUserDefinedPropertiesEditorPage_title);
    }

    public JADUserDefinedPropertiesEditorPage(JADFormEditor editor, String title) {
        super(editor, USER_DEFINED_PAGEID, title);
    }

    public void doSave(IProgressMonitor monitor) {
        IManifestPreferenceStore store = this.getPreferenceStore();
        for (KeyValuePair entry : this.userDefinedProperties) {
            store.setValue(entry.fields[0], entry.fields[1]);
        }
        this.setDirty(false);
    }

    public void editorInputChanged() {
        this.updateMidletProperties();
    }

    public String getTitle() {
        return MTJUIMessages.JADUserDefinedPropertiesEditorPage_title;
    }

    public boolean isManagingProperty(String property) {
        return false;
    }

    public void setFocus() {
        this.tableViewer.getTable().setFocus();
    }

    private void addItem() {
        KeyValuePair keyValuePair = new KeyValuePair(NEW_KEY, NEW_VALUE);
        this.userDefinedProperties.add(keyValuePair);
        this.tableViewer.refresh();
        this.setDirty(true);
    }

    private void createButtons(FormToolkit toolkit, Composite parent) {
        Composite composite = toolkit.createComposite(parent);
        FillLayout layout = new FillLayout();
        layout.type = 512;
        composite.setLayout((Layout)layout);
        this.addButton = toolkit.createButton(composite, MTJUIMessages.JADUserDefinedPropertiesEditorPage_add_btn_label, 8);
        this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                JADUserDefinedPropertiesEditorPage.this.addItem();
            }
        });
        toolkit.createLabel(composite, "");
        this.removeButton = toolkit.createButton(composite, MTJUIMessages.JADUserDefinedPropertiesEditorPage_remove_btn_label, 8);
        this.removeButton.setEnabled(false);
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                JADUserDefinedPropertiesEditorPage.this.removeSelectedItems();
            }
        });
    }

    private void createTableViewer(FormToolkit toolkit, Composite parent) {
        String[] columns = new String[]{MTJUIMessages.JADUserDefinedPropertiesEditorPage_key_column, MTJUIMessages.JADUserDefinedPropertiesEditorPage_value_column};
        int styles = 68356;
        Table table = toolkit.createTable(parent, styles);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        table.setLayoutData((Object)new GridData(1808));
        table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableItem selected = (TableItem)e.item;
                JADUserDefinedPropertiesEditorPage.this.removeButton.setEnabled(selected.getParent().getSelectionCount() > 0);
            }
        });
        this.tableViewer = new TableViewer(table);
        TableLayout layout = new TableLayout();
        int width = 100 / columns.length;
        String[] stringArray = columns;
        int n = columns.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            TableColumn column = new TableColumn(table, 0);
            column.setText(element);
            layout.addColumnData((ColumnLayoutData)new ColumnWeightData(width));
            ++n2;
        }
        table.setLayout((Layout)layout);
        this.tableViewer.setContentProvider((IContentProvider)new TableContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new TableLabelProvider());
        this.tableViewer.setCellModifier((ICellModifier)new CellModifier());
        this.tableViewer.setColumnProperties(PROPERTIES);
        this.tableViewer.setCellEditors(new CellEditor[]{new TextCellEditor((Composite)table), new TextCellEditor((Composite)table)});
        this.tableViewer.setInput((Object)this.getEditorInput());
        this.tableViewer.refresh();
    }

    private boolean isUserDefinedPropertyKey(String key) {
        JADFormEditor jadEditor = (JADFormEditor)this.getEditor();
        return jadEditor.isUserDefinedPropertyKey(key);
    }

    private void removeSelectedItems() {
        int[] indices = this.tableViewer.getTable().getSelectionIndices();
        int i = indices.length;
        while (i > 0) {
            int index = indices[i - 1];
            KeyValuePair keyValuePair = this.userDefinedProperties.remove(index);
            this.getPreferenceStore().setToDefault(keyValuePair.fields[0]);
            --i;
        }
        this.setDirty(true);
        this.tableViewer.refresh();
    }

    private void updateMidletProperties() {
        String[] names;
        this.userDefinedProperties.clear();
        IManifestPreferenceStore store = this.getPreferenceStore();
        String[] stringArray = names = store.preferenceNames();
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String propName = stringArray[n2];
            if (this.isUserDefinedPropertyKey(propName)) {
                this.userDefinedProperties.add(new KeyValuePair(propName, store.getString(propName)));
            }
            ++n2;
        }
        if (this.tableViewer != null) {
            this.tableViewer.refresh();
        }
    }

    protected void createFormContent(IManagedForm managedForm) {
        super.createFormContent(managedForm);
        FormToolkit toolkit = managedForm.getToolkit();
        Composite parent = managedForm.getForm().getBody();
        parent.setLayoutData((Object)new GridData(1808));
        parent.setLayout((Layout)new GridLayout(2, false));
        new Label(parent, 0);
        new Label(parent, 0);
        this.createTableViewer(toolkit, parent);
        this.createButtons(toolkit, parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.mtj.ui.help_JADUserDefinedPropertiesEditorPage");
    }

    protected String getHelpResource() {
        return "/org.eclipse.mtj.doc.user/html/reference/editors/jad_editor/user_defined.html";
    }

    protected String getSectionDescription() {
        return MTJUIMessages.JADUserDefinedPropertiesEditorPage_sectionDescription;
    }

    protected String getSectionTitle() {
        return MTJUIMessages.JADUserDefinedPropertiesEditorPage_sectionTitle;
    }

    protected void setInput(IEditorInput input) {
        super.setInput(input);
        if (this.tableViewer != null) {
            this.tableViewer.setInput((Object)input);
        }
        this.updateMidletProperties();
    }

    private class CellModifier
    implements ICellModifier {
        private CellModifier() {
        }

        public boolean canModify(Object element, String property) {
            return true;
        }

        public Object getValue(Object element, String property) {
            String value = null;
            if (element instanceof KeyValuePair) {
                KeyValuePair pair = (KeyValuePair)element;
                int fieldIndex = this.getFieldIndex(property);
                if (fieldIndex != -1) {
                    value = pair.fields[fieldIndex];
                }
            }
            return value;
        }

        public void modify(Object element, String property, Object value) {
            if (element instanceof TableItem) {
                Object data = ((TableItem)element).getData();
                String newValue = (String)value;
                if (data instanceof KeyValuePair) {
                    int fieldIndex = this.getFieldIndex(property);
                    KeyValuePair pair = (KeyValuePair)data;
                    if (fieldIndex != -1) {
                        this.updateField(pair, property, fieldIndex, newValue);
                    }
                }
            }
        }

        private int getFieldIndex(String property) {
            return PROPERTY_LIST.indexOf(property);
        }

        private void updateField(KeyValuePair pair, String property, int fieldIndex, String newValue) {
            if (!pair.fields[fieldIndex].equals(newValue)) {
                pair.fields[fieldIndex] = newValue;
                JADUserDefinedPropertiesEditorPage.this.setDirty(true);
                JADUserDefinedPropertiesEditorPage.this.tableViewer.update((Object)pair, new String[]{property});
            }
        }
    }

    private static class KeyValuePair {
        String[] fields;

        KeyValuePair(String key, String value) {
            this.fields = new String[]{key, value};
        }
    }

    private class TableContentProvider
    implements IStructuredContentProvider {
        private TableContentProvider() {
        }

        public void dispose() {
        }

        public Object[] getElements(Object inputElement) {
            return JADUserDefinedPropertiesEditorPage.this.userDefinedProperties.toArray(new Object[JADUserDefinedPropertiesEditorPage.this.userDefinedProperties.size()]);
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private static class TableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private TableLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            KeyValuePair pair = (KeyValuePair)element;
            return pair.fields[columnIndex];
        }
    }
}

