/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.editors.jad.form.pages;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.mtj.internal.ui.MTJUIMessages;
import org.eclipse.mtj.internal.ui.MTJUIPluginImages;
import org.eclipse.mtj.internal.ui.editors.IModelListener;
import org.eclipse.mtj.internal.ui.editors.jad.form.JADFormEditor;
import org.eclipse.mtj.internal.ui.editors.jad.form.pages.MidletType;
import org.eclipse.mtj.internal.ui.editors.jad.form.pages.MidletTypeDetailsPage;
import org.eclipse.mtj.internal.ui.editors.jad.form.pages.MidletsModel;
import org.eclipse.mtj.internal.ui.forms.blocks.DetailPage;
import org.eclipse.mtj.internal.ui.forms.blocks.MasterLabelProvider;
import org.eclipse.mtj.internal.ui.forms.blocks.NamedObject;
import org.eclipse.mtj.internal.ui.forms.blocks.ScrolledPropertiesBlock;
import org.eclipse.mtj.ui.editors.jad.AbstractJADEditorPage;
import org.eclipse.mtj.ui.editors.jad.IManifestPreferenceStore;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.IDetailsPage;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;

public class MidletsEditorPage
extends AbstractJADEditorPage
implements IModelListener {
    public static final String MIDLET_PREFIX = "MIDlet-";
    public static final String MIDLETS_PAGEID = "midlets";
    private Button add;
    private ScrolledPropertiesBlock block;
    private Button down;
    private int midletcount = 0;
    private MidletsModel model;
    private Button remove;
    private int storedMidletCount;
    private Button up;
    List<DetailPage> list = new ArrayList<DetailPage>();

    public MidletsEditorPage() {
        super(MIDLETS_PAGEID, MTJUIMessages.MidletsEditorPage_title);
        this.model = new MidletsModel(null);
        this.model.addModelListener(this);
    }

    public MidletsEditorPage(JADFormEditor editor, String title) {
        super(editor, MIDLETS_PAGEID, title);
        this.model = new MidletsModel(null);
        this.model.addModelListener(this);
    }

    public void doSave(IProgressMonitor monitor) {
        IManifestPreferenceStore store = this.getPreferenceStore();
        Object[] midlets = this.model.getContents();
        int currentMidletCount = midlets.length;
        int i = 0;
        while (i < currentMidletCount) {
            store.setValue(MIDLET_PREFIX + (i + 1), ((MidletType)midlets[i]).toString());
            ++i;
        }
        while (i < this.storedMidletCount) {
            store.setToDefault(MIDLET_PREFIX + (i + 1));
            ++i;
        }
        this.midletcount = currentMidletCount;
        this.storedMidletCount = currentMidletCount;
        this.setDirty(false);
    }

    public void editorInputChanged() {
        if (this.model != null) {
            this.model.clear();
        }
        this.updateMidletProperties();
        this.midletcount = 0;
        if (this.block != null) {
            this.block.refresh();
        }
        for (DetailPage page : this.list) {
            if (page.getObjectClass() != MidletType.class) continue;
            IDetailsPage detailsPage = page.getDetailsPage();
            detailsPage.selectionChanged(null, this.block.getCurrentSelectedItem());
        }
    }

    public String getTitle() {
        return MTJUIMessages.MidletsEditorPage_title;
    }

    public boolean isManagingProperty(String property) {
        boolean manages = property.startsWith(MIDLET_PREFIX);
        if (manages) {
            String value = property.substring(MIDLET_PREFIX.length());
            try {
                Integer.parseInt(value);
            }
            catch (NumberFormatException numberFormatException) {
                manages = false;
            }
        }
        return manages;
    }

    public void modelChanged(Object[] objects, String type, String property) {
        this.block.refresh();
        this.setDirty(true);
    }

    public void setFocus() {
    }

    private void addMouseListenersToButtons() {
        this.add.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                MidletsEditorPage.this.midletcount = MidletsEditorPage.this.model.getContents().length + 1;
                String midletName = MidletsEditorPage.MIDLET_PREFIX + String.valueOf(MidletsEditorPage.this.midletcount);
                MidletType midlet = new MidletType(midletName, midletName, "", "");
                MidletsEditorPage.this.model.add(new NamedObject[]{midlet}, true);
                MidletsEditorPage.this.remove.setEnabled(true);
                if (MidletsEditorPage.this.midletcount > 1) {
                    MidletsEditorPage.this.up.setEnabled(true);
                    MidletsEditorPage.this.down.setEnabled(true);
                }
                MidletsEditorPage.this.block.setCurrentSelectedItem((ISelection)new StructuredSelection((Object)midlet));
                MidletsEditorPage.this.block.refresh();
            }

            public void mouseUp(MouseEvent e) {
            }
        });
        this.remove.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                IStructuredSelection ssel = (IStructuredSelection)MidletsEditorPage.this.block.getCurrentSelectedItem();
                if (ssel.size() == 1) {
                    MidletType type = (MidletType)ssel.getFirstElement();
                    MidletsEditorPage.this.model.remove(new MidletType[]{type}, true);
                    MidletsEditorPage.this.midletcount = MidletsEditorPage.this.model.getContents().length;
                    if (MidletsEditorPage.this.midletcount == 0) {
                        MidletsEditorPage.this.remove.setEnabled(false);
                    }
                    if (MidletsEditorPage.this.midletcount > 1) {
                        MidletsEditorPage.this.up.setEnabled(true);
                        MidletsEditorPage.this.down.setEnabled(true);
                    }
                }
            }

            public void mouseUp(MouseEvent e) {
            }
        });
        this.up.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                IStructuredSelection seletion;
                if (MidletsEditorPage.this.up.isEnabled() && (seletion = (IStructuredSelection)MidletsEditorPage.this.block.getCurrentSelectedItem()).size() == 1) {
                    MidletType type = (MidletType)seletion.getFirstElement();
                    MidletsEditorPage.this.model.reorder(type, MidletsModel.Direction.UP);
                }
            }

            public void mouseUp(MouseEvent e) {
            }
        });
        this.down.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                IStructuredSelection seletion;
                if (MidletsEditorPage.this.down.isEnabled() && (seletion = (IStructuredSelection)MidletsEditorPage.this.block.getCurrentSelectedItem()).size() == 1) {
                    MidletType type = (MidletType)seletion.getFirstElement();
                    MidletsEditorPage.this.model.reorder(type, MidletsModel.Direction.DOWN);
                }
            }

            public void mouseUp(MouseEvent e) {
            }
        });
    }

    private void updateMidletProperties() {
        IManifestPreferenceStore store = this.getPreferenceStore();
        ArrayList<MidletType> midlets = new ArrayList<MidletType>();
        int i = 1;
        while (i < 1000) {
            String propName = MIDLET_PREFIX + i;
            if (!store.contains(propName)) break;
            String propValue = store.getString(propName);
            MidletType midletType = new MidletType(propName, propValue);
            midletType.setName(midletType.getMidletName(), false);
            midlets.add(midletType);
            ++this.storedMidletCount;
            ++i;
        }
        this.midletcount = this.storedMidletCount;
        if (!midlets.isEmpty()) {
            this.model.add(midlets.toArray(new NamedObject[0]), false);
        }
    }

    protected void createFormContent(IManagedForm managedForm) {
        this.list.add(new DetailPage(MidletType.class, new MidletTypeDetailsPage(this.getJavaProject())));
        this.block = new ScrolledPropertiesBlock(this, new MasterContentProvider(), new MidletMasterLabelProvider(), this.list);
        ScrolledForm form = managedForm.getForm();
        FormToolkit toolkit = managedForm.getToolkit();
        form.setText(this.getTitle());
        toolkit.decorateFormHeading(form.getForm());
        this.createErrorMessageHandler(managedForm);
        final String href = this.getHelpResource();
        if (href != null) {
            IToolBarManager manager = form.getToolBarManager();
            Action helpAction = new Action(MTJUIMessages.MidletsEditorPage_help_action){

                public void run() {
                    PlatformUI.getWorkbench().getHelpSystem().displayHelpResource(href);
                }
            };
            helpAction.setImageDescriptor(MTJUIPluginImages.DESC_LINKTOHELP);
            manager.add((IAction)helpAction);
        }
        form.updateToolBar();
        this.block.createContent(managedForm);
        this.add = this.block.getButtonBarBlock().getButton(0);
        this.add.setEnabled(true);
        this.remove = this.block.getButtonBarBlock().getButton(1);
        this.up = this.block.getButtonBarBlock().getButton(2);
        this.down = this.block.getButtonBarBlock().getButton(3);
        this.addMouseListenersToButtons();
        if (this.midletcount > 0) {
            this.remove.setEnabled(true);
            if (this.midletcount > 1) {
                this.up.setEnabled(true);
                this.down.setEnabled(true);
            }
        }
    }

    protected String getHelpResource() {
        return "/org.eclipse.mtj.doc.user/html/reference/editors/jad_editor/midlets.html";
    }

    protected void setInput(IEditorInput input) {
        super.setInput(input);
        this.setDirty(false);
        this.updateMidletProperties();
    }

    class MasterContentProvider
    implements IStructuredContentProvider {
        MasterContentProvider() {
        }

        public void dispose() {
        }

        public Object[] getElements(Object inputElement) {
            return MidletsEditorPage.this.model.getContents();
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    class MidletMasterLabelProvider
    extends MasterLabelProvider {
        MidletMasterLabelProvider() {
        }

        public Image getColumnImage(Object obj, int index) {
            return MTJUIPluginImages.DESC_MIDLET_ICON.createImage();
        }

        public String getColumnText(Object obj, int index) {
            return ((MidletType)obj).getName();
        }
    }
}

