/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.editors.jad.form.pages;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.ui.ILaunchShortcut;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.mtj.core.project.IMTJProject;
import org.eclipse.mtj.core.project.midp.IMidletSuiteProject;
import org.eclipse.mtj.core.project.runtime.event.AddMTJRuntimeEvent;
import org.eclipse.mtj.core.project.runtime.event.IMTJRuntimeChangeListener;
import org.eclipse.mtj.core.project.runtime.event.IMTJRuntimeListChangeListener;
import org.eclipse.mtj.core.project.runtime.event.MTJRuntimeDeviceChangeEvent;
import org.eclipse.mtj.core.project.runtime.event.MTJRuntimeNameChangeEvent;
import org.eclipse.mtj.core.project.runtime.event.MTJRuntimeWorkspaceSymbolSetsChangeEvent;
import org.eclipse.mtj.core.project.runtime.event.RemoveMTJRuntimeEvent;
import org.eclipse.mtj.core.project.runtime.event.SwitchActiveMTJRuntimeEvent;
import org.eclipse.mtj.core.sdk.device.IDevice;
import org.eclipse.mtj.internal.core.project.midp.MidletSuiteFactory;
import org.eclipse.mtj.internal.core.project.runtime.MTJRuntimeListUtils;
import org.eclipse.mtj.internal.core.util.Utils;
import org.eclipse.mtj.internal.ui.MTJUIMessages;
import org.eclipse.mtj.internal.ui.MTJUIPluginImages;
import org.eclipse.mtj.internal.ui.configurations.ConfigManageComponent;
import org.eclipse.mtj.internal.ui.editors.FormLayoutFactory;
import org.eclipse.mtj.internal.ui.editors.jad.form.JADFormEditor;
import org.eclipse.mtj.internal.ui.preferences.ExtendedStringFieldEditor;
import org.eclipse.mtj.internal.ui.wizards.export.antenna.AntennaExportAction;
import org.eclipse.mtj.internal.ui.wizards.export.packaging.ExportPackageAction;
import org.eclipse.mtj.ui.editors.jad.JADPropertiesEditorPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;

public class OverviewEditorPage
extends JADPropertiesEditorPage
implements IPropertyChangeListener,
IMTJRuntimeListChangeListener,
IMTJRuntimeChangeListener {
    private static final String OVERVIEW_PAGEID = "overview";
    private ConfigManageComponent configManager;
    private String loadedJarUrl;
    private IMidletSuiteProject midletProject;
    private IJavaProject project = JavaCore.create((IProject)((JADFormEditor)this.getEditor()).getJadFile().getProject());

    public OverviewEditorPage(JADFormEditor editor) {
        super(editor, OVERVIEW_PAGEID, MTJUIMessages.OverviewEditorPage_title);
        this.midletProject = MidletSuiteFactory.getMidletSuiteProject((IJavaProject)this.project);
    }

    public void activeMTJRuntimeSwitched(SwitchActiveMTJRuntimeEvent event) {
        this.setDirty(MTJRuntimeListUtils.isMTJRuntimeListDirty((IMTJProject)this.midletProject));
    }

    public void mtjRuntimeAdded(AddMTJRuntimeEvent event) {
        this.setDirty(MTJRuntimeListUtils.isMTJRuntimeListDirty((IMTJProject)this.midletProject));
    }

    public void mtjRuntimeRemoved(RemoveMTJRuntimeEvent event) {
        this.setDirty(MTJRuntimeListUtils.isMTJRuntimeListDirty((IMTJProject)this.midletProject));
    }

    public void deviceChanged(MTJRuntimeDeviceChangeEvent event) {
        this.setDirty(MTJRuntimeListUtils.isMTJRuntimeListDirty((IMTJProject)this.midletProject));
    }

    public void dispose() {
        super.dispose();
        if (this.isDirty()) {
            this.configManager.performCancel();
        }
        this.configManager.dispose();
    }

    public void doSave(IProgressMonitor monitor) {
        super.doSave(monitor);
        this.validateFields();
        String currentJarUrl = this.getPreferenceStore().getString("MIDlet-Jar-URL");
        Text jarURLControl = null;
        FieldEditor[] fieldEditorArray = this.fieldEditors;
        int n = this.fieldEditors.length;
        int n2 = 0;
        while (n2 < n) {
            String fieldEditorLabel;
            FieldEditor field = fieldEditorArray[n2];
            if (field instanceof ExtendedStringFieldEditor && (fieldEditorLabel = field.getLabelText()).equals(MTJUIMessages.RequiredJADDesciptorsProvider_midlet_jar_url)) {
                jarURLControl = ((ExtendedStringFieldEditor)field).getFieldEditorTextControl();
                break;
            }
            ++n2;
        }
        if (!Utils.isValidFileName((String)currentJarUrl)) {
            this.getPreferenceStore().putValue("MIDlet-Jar-URL", this.loadedJarUrl);
            this.getErrorMessageManager().removeMessage((Object)("textLength_" + MTJUIMessages.RequiredJADDesciptorsProvider_midlet_jar_url), (Control)jarURLControl);
        } else if (!currentJarUrl.substring(currentJarUrl.length() - 4).equalsIgnoreCase(".jar")) {
            this.getPreferenceStore().putValue("MIDlet-Jar-URL", this.loadedJarUrl);
            this.getErrorMessageManager().removeMessage((Object)("textLength_" + MTJUIMessages.RequiredJADDesciptorsProvider_midlet_jar_url), (Control)jarURLControl);
        }
        if (!currentJarUrl.equals(this.loadedJarUrl)) {
            ((JADFormEditor)this.getEditor()).setCleanRequired(true);
        }
        IDevice device = this.configManager.getActiveConfiguration().getDevice();
        if (this.midletProject != null && device != null) {
            try {
                this.midletProject.refreshClasspath(monitor);
                this.configManager.performFinish();
                this.midletProject.saveMetaData();
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
    }

    public void validateFields() {
        IFile applicationDescriptorFile = this.midletProject.getApplicationDescriptorFile();
        try {
            Utils.removeAllErrorMarkers((IResource)applicationDescriptorFile);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        FieldEditor[] fieldEditorArray = this.fieldEditors;
        int n = this.fieldEditors.length;
        int n2 = 0;
        while (n2 < n) {
            FieldEditor field = fieldEditorArray[n2];
            if (field instanceof ExtendedStringFieldEditor) {
                String fieldEditorLabel = field.getLabelText();
                Text control = ((ExtendedStringFieldEditor)field).getFieldEditorTextControl();
                if (!fieldEditorLabel.equals(MTJUIMessages.RequiredJADDesciptorsProvider_midlet_jar_url) && control.getText().equals("")) {
                    this.getErrorMessageManager().addMessage((Object)("textLength_" + fieldEditorLabel), MTJUIMessages.OverviewEditorPage_empty_field_error_msg, null, 3, (Control)control);
                    try {
                        Utils.createErrorMarker((IResource)applicationDescriptorFile, (String)(String.valueOf(fieldEditorLabel) + ":" + MTJUIMessages.OverviewEditorPage_empty_field_error_msg));
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                    }
                }
            }
            ++n2;
        }
    }

    public String getTitle() {
        return MTJUIMessages.OverviewEditorPage_title;
    }

    public void linkActivated(HyperlinkEvent e) {
        String href = (String)e.getHref();
        if (href.equals("package")) {
            new ExportPackageAction(this.getJavaProject()).run();
        } else if (href.equals("antenna")) {
            new AntennaExportAction(this.project).run();
        } else if (href.startsWith("launchShortcut.")) {
            this.handleLaunchShortcut(href);
        }
    }

    public void nameChanged(MTJRuntimeNameChangeEvent event) {
        this.setDirty(MTJRuntimeListUtils.isMTJRuntimeListDirty((IMTJProject)this.midletProject));
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals("field_editor_value")) {
            if (event.getSource() instanceof ExtendedStringFieldEditor) {
                String fieldEditorLabel = ((FieldEditor)event.getSource()).getLabelText();
                Text c = ((ExtendedStringFieldEditor)((Object)event.getSource())).getFieldEditorTextControl();
                if (event.getNewValue().equals("")) {
                    this.getErrorMessageManager().addMessage((Object)("textLength_" + fieldEditorLabel), MTJUIMessages.OverviewEditorPage_empty_field_error_msg, null, 3, (Control)c);
                } else if (((ExtendedStringFieldEditor)((Object)event.getSource())).getPreferenceName().equals("MIDlet-Jar-URL")) {
                    String jarFileName = (String)event.getNewValue();
                    if (!jarFileName.substring(jarFileName.length() - 4).equalsIgnoreCase(".jar")) {
                        this.getErrorMessageManager().addMessage((Object)("textLength_" + fieldEditorLabel), MTJUIMessages.J2MEProjectPropertiesPage_validatePage_jar_error, null, 3, (Control)c);
                    } else if (!Utils.isValidFileName((String)jarFileName)) {
                        this.getErrorMessageManager().addMessage((Object)("textLength_" + fieldEditorLabel), MTJUIMessages.OverviewEditorPage_invalid_jar_file_name, null, 3, (Control)c);
                    } else {
                        this.getErrorMessageManager().removeMessage((Object)("textLength_" + fieldEditorLabel), (Control)c);
                    }
                } else {
                    this.getErrorMessageManager().removeMessage((Object)("textLength_" + fieldEditorLabel), (Control)c);
                }
            }
            this.setDirty(true);
        }
    }

    public void symbolSetChanged() {
        this.setDirty(MTJRuntimeListUtils.isMTJRuntimeListDirty((IMTJProject)this.midletProject));
    }

    public void workspaceScopeSymbolSetsChanged(MTJRuntimeWorkspaceSymbolSetsChangeEvent event) {
        this.setDirty(MTJRuntimeListUtils.isMTJRuntimeListDirty((IMTJProject)this.midletProject));
    }

    private void createDebuginSection(IManagedForm managedForm, Composite parent, FormToolkit toolkit) {
        Section section = this.createStaticSection(toolkit, parent, MTJUIMessages.OverviewEditorPage_debugging_section_title);
        Composite container = this.createStaticSectionClient(toolkit, (Composite)section, null);
        FormText text = this.createClient(container, MTJUIMessages.overviewPage_launchsection_debuglinks, toolkit, this);
        text.setImage("debugMidlet", MTJUIPluginImages.DESC_DEBUG_MIDLET.createImage());
        text.setImage("debugjad", MTJUIPluginImages.DESC_DEBUG_JAD.createImage());
        text.setImage("debugOta", MTJUIPluginImages.DESC_DEBUG_OTA.createImage());
        section.setClient((Control)container);
    }

    private void createExportingSection(IManagedForm managedForm, Composite parent, FormToolkit toolkit) {
        Section section = this.createStaticSection(toolkit, parent, MTJUIMessages.OverviewEditorPage_exporting_section_title);
        Composite container = this.createStaticSectionClient(toolkit, (Composite)section, null);
        FormText text = this.createClient(container, MTJUIMessages.overviewPage_exporting, toolkit, this);
        text.setImage("antenna", MTJUIPluginImages.DESC_ANT.createImage());
        section.setClient((Control)container);
    }

    private void createOverviewSection(IManagedForm managedForm, Composite parent, FormToolkit toolkit) {
        Section section = this.createStaticBasicSection(toolkit, parent, MTJUIMessages.overviewPage_requiredsection_title, MTJUIMessages.overviewPage_requiredsection_description);
        Composite sectionClient = this.createStaticSectionClient(toolkit, (Composite)section, null);
        sectionClient.setLayout((Layout)FormLayoutFactory.createSectionClientTableWrapLayout(false, 1));
        this.createSectionContent(managedForm, sectionClient, this);
        section.setClient((Control)sectionClient);
    }

    private void createPackagingSection(IManagedForm managedForm, Composite parent, FormToolkit toolkit) {
        Section section = this.createStaticSection(toolkit, parent, MTJUIMessages.OverviewEditorPage_packaging_section_title);
        Composite container = this.createStaticSectionClient(toolkit, (Composite)section, null);
        FormText text = this.createClient(container, MTJUIMessages.overviewPage_deploying, toolkit, this);
        text.setImage("package", MTJUIPluginImages.DESC_PACKAGE.createImage());
        section.setClient((Control)container);
    }

    private void createRunningSection(IManagedForm managedForm, Composite parent, FormToolkit toolkit) {
        Section section = this.createStaticSection(toolkit, parent, MTJUIMessages.OverviewEditorPage_running_section_title);
        Composite container = this.createStaticSectionClient(toolkit, (Composite)section, null);
        FormText text = this.createClient(container, MTJUIMessages.overviewPage_launchsection_runlinks, toolkit, this);
        text.setImage("runMidlet", MTJUIPluginImages.DESC_RUN_MIDLET.createImage());
        text.setImage("runjad", MTJUIPluginImages.DESC_RUN_JAD.createImage());
        text.setImage("runOta", MTJUIPluginImages.DESC_RUN_OTA.createImage());
        section.setClient((Control)container);
    }

    private void createRuntimeSection(IManagedForm managedForm, Composite parent, FormToolkit toolkit) {
        Section section = this.createStaticBasicSection(toolkit, parent, MTJUIMessages.overviewPage_runtimesection_title, MTJUIMessages.overviewPage_runtimesection_description);
        Composite sectionClient = this.createStaticSectionClient(toolkit, (Composite)section, null);
        sectionClient.setLayout((Layout)FormLayoutFactory.createSectionClientGridLayout(true, 1));
        this.createRuntimeSectionContent(managedForm, sectionClient, this);
        section.setClient((Control)sectionClient);
    }

    private void createRuntimeSectionContent(IManagedForm managedForm, Composite sectionClient, OverviewEditorPage overviewEditorPage) {
        this.configManager = new ConfigManageComponent(this.midletProject);
        this.configManager.setIncludeGroup(false);
        this.configManager.createContents(sectionClient);
        this.configManager.setConfigurationsChangeListener(this);
        this.configManager.setConfigurationChangeListener(this);
    }

    private void fillEditorPageBody(IManagedForm managedForm) {
        FormToolkit toolkit = managedForm.getToolkit();
        Composite body = managedForm.getForm().getBody();
        body.setLayout((Layout)FormLayoutFactory.createFormTableWrapLayout(true, 2));
        Composite left = toolkit.createComposite(body);
        left.setLayout((Layout)FormLayoutFactory.createFormPaneTableWrapLayout(false, 1));
        left.setLayoutData((Object)new TableWrapData(256));
        this.createOverviewSection(managedForm, left, toolkit);
        this.createPackagingSection(managedForm, left, toolkit);
        this.createExportingSection(managedForm, left, toolkit);
        Composite right = toolkit.createComposite(body);
        right.setLayout((Layout)FormLayoutFactory.createFormPaneTableWrapLayout(false, 1));
        right.setLayoutData((Object)new TableWrapData(256));
        this.createRunningSection(managedForm, right, toolkit);
        this.createDebuginSection(managedForm, right, toolkit);
        this.createRuntimeSection(managedForm, right, toolkit);
    }

    private void handleLaunchShortcut(String href) {
        IConfigurationElement[] elements;
        int index = (href = href.substring(15)).indexOf(46);
        if (index < 0) {
            return;
        }
        String mode = href.substring(0, index);
        String id = href.substring(index + 1);
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = elements = registry.getConfigurationElementsFor("org.eclipse.debug.ui.launchShortcuts");
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            if (id.equals(element.getAttribute("id"))) {
                try {
                    ILaunchShortcut shortcut = (ILaunchShortcut)element.createExecutableExtension("class");
                    shortcut.launch((ISelection)new StructuredSelection((Object)this.project), mode);
                }
                catch (CoreException coreException) {}
            }
            ++n2;
        }
    }

    protected void addContextHelp(Composite c) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)c, "org.eclipse.mtj.ui.help_JADRequiredPropertiesEditorPage");
    }

    protected void createFormContent(IManagedForm managedForm) {
        ScrolledForm form = managedForm.getForm();
        FormToolkit toolkit = managedForm.getToolkit();
        form.setText(this.getTitle());
        toolkit.decorateFormHeading(form.getForm());
        this.createErrorMessageHandler(managedForm);
        final String href = this.getHelpResource();
        if (href != null) {
            IToolBarManager manager = form.getToolBarManager();
            Action helpAction = new Action(MTJUIMessages.OverviewEditorPage_help_action){

                public void run() {
                    PlatformUI.getWorkbench().getHelpSystem().displayHelpResource(href);
                }
            };
            helpAction.setImageDescriptor(MTJUIPluginImages.DESC_LINKTOHELP);
            manager.add((IAction)helpAction);
        }
        form.updateToolBar();
        this.fillEditorPageBody(managedForm);
        this.validateFields();
    }

    protected String getHelpResource() {
        return "/org.eclipse.mtj.doc.user/html/reference/editors/jad_editor/overview.html";
    }

    protected String getSectionDescription() {
        return "";
    }

    protected String getSectionTitle() {
        return "";
    }

    protected void setInput(IEditorInput input) {
        super.setInput(input);
        this.loadedJarUrl = this.getPreferenceStore().getString("MIDlet-Jar-URL");
    }
}

