/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.editors.jad.form.pages;

import java.io.File;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.mtj.core.build.sign.ISignatureProperties;
import org.eclipse.mtj.core.project.IMTJProjectListener;
import org.eclipse.mtj.core.project.midp.IMidletSuiteProject;
import org.eclipse.mtj.core.project.midp.IMidletSuiteProjectListener;
import org.eclipse.mtj.internal.core.project.midp.MidletSuiteFactory;
import org.eclipse.mtj.internal.core.sign.DefaultKeyStoreManager;
import org.eclipse.mtj.internal.core.sign.KeyStoreEntry;
import org.eclipse.mtj.internal.core.sign.KeyStoreManagerException;
import org.eclipse.mtj.internal.core.sign.SecurityPermissionsScanner;
import org.eclipse.mtj.internal.core.util.log.MTJLogger;
import org.eclipse.mtj.internal.ui.MTJUIMessages;
import org.eclipse.mtj.internal.ui.MTJUIPluginImages;
import org.eclipse.mtj.internal.ui.dialog.SecurityPermissionsDialog;
import org.eclipse.mtj.internal.ui.dialog.SigningPasswordDialog;
import org.eclipse.mtj.internal.ui.editors.jad.form.JADFormEditor;
import org.eclipse.mtj.internal.ui.forms.blocks.GenericListBlock;
import org.eclipse.mtj.internal.ui.forms.blocks.GenericListBlockItem;
import org.eclipse.mtj.internal.ui.forms.blocks.GenericListBlockListener;
import org.eclipse.mtj.ui.editors.jad.AbstractJADEditorPage;
import org.eclipse.mtj.ui.editors.jad.IManifestPreferenceStore;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.dialogs.CheckedTreeSelectionDialog;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SigningJADEditorPage
extends AbstractJADEditorPage {
    public static final String ID = "signing";
    private static final String COMMA = ",";
    private static final String TITLE = MTJUIMessages.PermissionsPage_title;
    private Combo combo;
    private Button enableButton;
    private GenericListBlock<SecurityPermissionListItem> optPermissionBlock;
    private List<SecurityPermissionListItem> optPermissions;
    private IMidletSuiteProjectListener projectListener;
    private GenericListBlock<SecurityPermissionListItem> reqPermissionBlock;
    private List<SecurityPermissionListItem> reqPermissions = new LinkedList<SecurityPermissionListItem>();

    public SigningJADEditorPage(JADFormEditor editor) {
        super(editor, ID, TITLE);
        this.optPermissions = new LinkedList<SecurityPermissionListItem>();
        this.listenForProjectSignatureUpdates();
    }

    @Override
    public void dispose() {
        super.dispose();
        IMidletSuiteProject midletSuiteProject = MidletSuiteFactory.getMidletSuiteProject((IJavaProject)this.getJavaProject());
        if (midletSuiteProject != null) {
            midletSuiteProject.removeMTJProjectListener((IMTJProjectListener)this.projectListener);
        }
    }

    public void doSave(IProgressMonitor monitor) {
        IManifestPreferenceStore store = this.getPreferenceStore();
        String requiredPermissions = this.getPermissionsListAsString(ListId.Required);
        store.setValue("MIDlet-Permissions", requiredPermissions);
        String optionalPermissions = this.getPermissionsListAsString(ListId.Optional);
        store.setValue("MIDlet-Permissions-Opt", optionalPermissions);
        this.updateProjectSigningState();
        this.setDirty(false);
    }

    @Override
    public void editorInputChanged() {
        String optPermissions;
        int n;
        IManifestPreferenceStore store = this.getPreferenceStore();
        this.reqPermissions.clear();
        this.optPermissions.clear();
        String reqPermissions = store.getString("MIDlet-Permissions");
        if (reqPermissions.length() > 0) {
            String[] permissions;
            String[] stringArray = permissions = reqPermissions.split(COMMA);
            n = permissions.length;
            int n2 = 0;
            while (n2 < n) {
                String permission = stringArray[n2];
                this.reqPermissions.add(new SecurityPermissionListItem(permission));
                ++n2;
            }
        }
        if ((optPermissions = store.getString("MIDlet-Permissions-Opt")).length() > 0) {
            String[] permissions;
            String[] stringArray = permissions = optPermissions.split(COMMA);
            int n3 = permissions.length;
            n = 0;
            while (n < n3) {
                String permission = stringArray[n];
                this.optPermissions.add(new SecurityPermissionListItem(permission));
                ++n;
            }
        }
        if (this.reqPermissionBlock != null) {
            this.reqPermissionBlock.update();
        }
        if (this.optPermissionBlock != null) {
            this.optPermissionBlock.update();
        }
    }

    @Override
    public String getTitle() {
        return TITLE;
    }

    @Override
    public boolean isManagingProperty(String property) {
        return false;
    }

    public void setActive(boolean active) {
        super.setActive(active);
        if (active) {
            this.getErrorMessageManager().removeAllMessages();
        }
    }

    private void addPermissions(ListId listId) {
        CheckedTreeSelectionDialog dialog = SecurityPermissionsDialog.createDialog(this.getPartControl().getShell());
        if (dialog.open() == 0) {
            Object[] result = dialog.getResult();
            GenericListBlock<SecurityPermissionListItem> block = null;
            List<SecurityPermissionListItem> list = null;
            switch (listId) {
                case Required: {
                    block = this.reqPermissionBlock;
                    list = this.reqPermissions;
                    break;
                }
                case Optional: {
                    block = this.optPermissionBlock;
                    list = this.optPermissions;
                }
            }
            if (list != null) {
                this.addPermissionsToList(list, result);
                block.update();
            }
        }
    }

    private void addPermissionsToList(List<SecurityPermissionListItem> permissionsList, Object[] result) {
        Object[] objectArray = result;
        int n = result.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            if (object instanceof SecurityPermissionsDialog.PermissionNode) {
                boolean isNew = true;
                String permission = ((SecurityPermissionsDialog.PermissionNode)object).getPermission();
                for (SecurityPermissionListItem item : permissionsList) {
                    if (!item.getText().equals(permission)) continue;
                    isNew = false;
                    break;
                }
                if (isNew) {
                    permissionsList.add(new SecurityPermissionListItem(permission));
                }
            }
            ++n2;
        }
        this.setDirty(true);
    }

    private void createAliasSection(IManagedForm managedForm, Composite body) {
        FormToolkit toolkit = managedForm.getToolkit();
        GridData gridData = new GridData(4, 0x1000000, true, false);
        gridData.horizontalSpan = 2;
        Composite sectionBody = this.createSection(managedForm, body, MTJUIMessages.PermissionsPage_signProperties, null, gridData);
        sectionBody.setLayout((Layout)new GridLayout(2, false));
        toolkit.createLabel(sectionBody, MTJUIMessages.PermissionsPage_keyAlias);
        this.combo = new Combo(sectionBody, 12);
        gridData = new GridData(4, 0x1000000, true, false);
        this.combo.setLayoutData((Object)gridData);
        this.combo.setFocus();
        this.combo.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                SigningJADEditorPage.this.setDirty(true);
            }
        });
    }

    private void createListsSection(IManagedForm managedForm, Composite body) {
        Composite reqSectionBody = this.createSection(managedForm, body, MTJUIMessages.PermissionsPage_requiredPermissionsTitle, MTJUIMessages.PermissionsPage_requiredPermissionsMessage, new GridData(4, 4, true, true));
        reqSectionBody.setLayout((Layout)new GridLayout(1, false));
        this.reqPermissionBlock = new GenericListBlock<SecurityPermissionListItem>(reqSectionBody, 2050, 62, this.reqPermissions);
        this.reqPermissionBlock.addGenericListBlockListener(new GenericListBlockListener<SecurityPermissionListItem>(){

            @Override
            public void addButtonPressed() {
                SigningJADEditorPage.this.addPermissions(ListId.Required);
            }

            @Override
            public void downButtonPressed() {
                SigningJADEditorPage.this.setDirty(true);
            }

            @Override
            public void itemsRemoved(List<SecurityPermissionListItem> _items) {
                SigningJADEditorPage.this.setDirty(true);
            }

            @Override
            public void scan() {
                SigningJADEditorPage.this.scanProjectClasses(ListId.Required);
            }

            @Override
            public void upButtonPressed() {
                SigningJADEditorPage.this.setDirty(true);
            }
        });
        Composite optSectionBody = this.createSection(managedForm, body, MTJUIMessages.PermissionsPage_optionalPermissionsTitle, MTJUIMessages.PermissionsPage_optionalPermissionsMessage, new GridData(4, 4, true, true));
        optSectionBody.setLayout((Layout)new GridLayout(1, false));
        this.optPermissionBlock = new GenericListBlock<SecurityPermissionListItem>(optSectionBody, 2050, 62, this.optPermissions);
        this.optPermissionBlock.addGenericListBlockListener(new GenericListBlockListener<SecurityPermissionListItem>(){

            @Override
            public void addButtonPressed() {
                SigningJADEditorPage.this.addPermissions(ListId.Optional);
            }

            @Override
            public void downButtonPressed() {
                SigningJADEditorPage.this.setDirty(true);
            }

            @Override
            public void itemsRemoved(List<SecurityPermissionListItem> _items) {
                SigningJADEditorPage.this.setDirty(true);
            }

            @Override
            public void scan() {
                SigningJADEditorPage.this.scanProjectClasses(ListId.Optional);
            }

            @Override
            public void upButtonPressed() {
                SigningJADEditorPage.this.setDirty(true);
            }
        });
    }

    private Composite createSection(IManagedForm managedForm, Composite listsParent, String text, String description, GridData gridData) {
        FormToolkit toolkit = managedForm.getToolkit();
        Section section = toolkit.createSection(listsParent, 384);
        if (text != null) {
            section.setText(text);
        }
        if (description != null) {
            section.setDescription(description);
        }
        section.setLayoutData((Object)gridData);
        section.setLayout((Layout)new GridLayout(1, false));
        Composite client = toolkit.createComposite((Composite)section, 0);
        client.setLayoutData((Object)new GridData(4, 4, true, true));
        section.setClient((Control)client);
        return client;
    }

    private void createTopSection(IManagedForm managedForm, Composite body) {
        FormToolkit toolkit = managedForm.getToolkit();
        this.enableButton = toolkit.createButton(body, MTJUIMessages.PermissionsPage_signPackage, 32);
        this.enableButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                SigningJADEditorPage.this.updateWidgetsStates(SigningJADEditorPage.this.enableButton.getSelection());
                SigningJADEditorPage.this.setDirty(true);
            }
        });
        ISignatureProperties signProperties = this.getProjectSignatureProperties();
        if (signProperties != null) {
            this.enableButton.setSelection(signProperties.isSignProject());
        }
        GridData gridData = new GridData(16384, 0x1000000, false, false);
        gridData.horizontalSpan = 2;
        this.enableButton.setLayoutData((Object)gridData);
    }

    private String getPermissionsListAsString(ListId listId) {
        StringBuffer buffer = new StringBuffer();
        List<SecurityPermissionListItem> list = null;
        switch (listId) {
            case Required: {
                list = this.reqPermissions;
                break;
            }
            case Optional: {
                list = this.optPermissions;
            }
        }
        if (list != null) {
            for (SecurityPermissionListItem item : list) {
                if (buffer.length() > 0) {
                    buffer.append(COMMA);
                }
                buffer.append(item.getText().trim());
            }
        }
        return buffer.toString();
    }

    private ISignatureProperties getProjectSignatureProperties() {
        ISignatureProperties signProperties = null;
        IMidletSuiteProject midletProject = null;
        try {
            midletProject = MidletSuiteFactory.getMidletSuiteProject((IJavaProject)this.getJavaProject());
            signProperties = midletProject.getSignatureProperties();
        }
        catch (CoreException e) {
            String message = NLS.bind((String)"Unable to get project signing properties: {0}", (Object)e.getMessage());
            MTJLogger.log((int)4, (String)message);
            this.getErrorMessageManager().addMessage((Object)message, message, null, 3);
        }
        return signProperties;
    }

    private void listAliases(final Combo combo) {
        Display.getDefault().asyncExec(new Runnable(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void run() {
                String message;
                ISignatureProperties properties = null;
                String password = null;
                String path = null;
                File file = null;
                combo.removeAll();
                properties = SigningJADEditorPage.this.getProjectSignatureProperties();
                if (properties == null) {
                    return;
                }
                try {
                    path = properties.getAbsoluteKeyStorePath(SigningJADEditorPage.this.getJavaProject().getProject());
                    if (path == null) {
                        return;
                    }
                }
                catch (CoreException e) {
                    MTJLogger.log((int)4, (String)NLS.bind((String)"Unable to get keystore path: {0}", (Object)e.getMessage()));
                }
                file = new File(path);
                if (!file.exists() || !file.isFile()) {
                    return;
                }
                if (properties.getPasswordStorageMethod() == 0) {
                    SigningPasswordDialog dialog = new SigningPasswordDialog(SigningJADEditorPage.this.getPartControl().getShell(), false);
                    dialog.setTitle("KeyStore Password");
                    if (dialog.open() != 0) return;
                    password = dialog.getPassword();
                } else {
                    password = properties.getKeyStorePassword();
                }
                try {
                    DefaultKeyStoreManager manager = new DefaultKeyStoreManager(file, password);
                    manager.setProvider(properties.getKeyStoreProvider());
                    manager.setKeystoreType(properties.getKeyStoreType());
                    List entries = manager.getEntries();
                    for (KeyStoreEntry entry : entries) {
                        if (entry.getType() != KeyStoreEntry.Type.KEY_PAIR) continue;
                        combo.add(entry.getAlias());
                    }
                }
                catch (KeyStoreManagerException e) {
                    message = NLS.bind((String)"Unable to get keystore aliases: {0}", (Object)e.getMessage());
                    MTJLogger.log((int)4, (String)message);
                    SigningJADEditorPage.this.getErrorMessageManager().addMessage((Object)message, message, null, 3);
                }
                catch (Exception e) {
                    message = e.getMessage();
                    MTJLogger.log((int)4, (String)message);
                    SigningJADEditorPage.this.getErrorMessageManager().addMessage((Object)message, message, null, 3);
                }
                String alias = properties.getKeyAlias();
                if (alias == null) {
                    return;
                }
                int i = 0;
                while (i < combo.getItemCount()) {
                    if (alias.equals(combo.getItem(i))) {
                        combo.select(i);
                    }
                    ++i;
                }
            }
        });
    }

    private void listenForProjectSignatureUpdates() {
        this.projectListener = new IMidletSuiteProjectListener(){

            public void classpathRefreshed() {
            }

            public void jadFileNameChanged() {
            }

            public void metaDataSaved() {
            }

            public void packageCreated() {
            }

            public void signaturePropertiesChanged() {
                if (SigningJADEditorPage.this.enableButton != null && !SigningJADEditorPage.this.enableButton.isDisposed() && SigningJADEditorPage.this.enableButton.getSelection()) {
                    SigningJADEditorPage.this.listAliases(SigningJADEditorPage.this.combo);
                }
            }

            public void tempKeyPasswordChanged() {
            }

            public void tempKeystorePasswordChanged() {
            }
        };
        IMidletSuiteProject midletSuiteProject = MidletSuiteFactory.getMidletSuiteProject((IJavaProject)this.getJavaProject());
        if (midletSuiteProject != null) {
            midletSuiteProject.addMTJProjectListener((IMTJProjectListener)this.projectListener);
        }
    }

    private void scanProjectClasses(ListId listId) {
        IMidletSuiteProject midletSuiteProject = MidletSuiteFactory.getMidletSuiteProject((IJavaProject)this.getJavaProject());
        if (midletSuiteProject == null) {
            return;
        }
        CheckedTreeSelectionDialog dialog = SecurityPermissionsDialog.createDialog(this.getPartControl().getShell());
        SecurityPermissionsScanner scanner = new SecurityPermissionsScanner(midletSuiteProject);
        List permissionsGroups = scanner.getRequiredPermissions();
        dialog.setInitialSelections(permissionsGroups.toArray());
        if (dialog.open() == 0) {
            Object[] result = dialog.getResult();
            GenericListBlock<SecurityPermissionListItem> block = null;
            List<SecurityPermissionListItem> list = null;
            switch (listId) {
                case Required: {
                    block = this.reqPermissionBlock;
                    list = this.reqPermissions;
                    break;
                }
                case Optional: {
                    block = this.optPermissionBlock;
                    list = this.optPermissions;
                }
            }
            if (list != null) {
                this.addPermissionsToList(list, result);
                block.update();
            }
        }
    }

    private void updateProjectSigningState() {
        ISignatureProperties signProperties = null;
        IMidletSuiteProject midletProject = null;
        midletProject = MidletSuiteFactory.getMidletSuiteProject((IJavaProject)this.getJavaProject());
        signProperties = this.getProjectSignatureProperties();
        if (signProperties == null) {
            return;
        }
        try {
            signProperties.setSignProject(this.enableButton.getSelection());
            int selectedIndex = this.combo.getSelectionIndex();
            if (selectedIndex >= 0) {
                signProperties.setKeyAlias(this.combo.getItem(selectedIndex));
            }
            midletProject.setSignatureProperties(signProperties);
            midletProject.saveMetaData();
        }
        catch (CoreException e) {
            MTJLogger.log((int)4, (Throwable)e);
        }
    }

    @Override
    protected void createFormContent(IManagedForm managedForm) {
        FormToolkit toolkit = managedForm.getToolkit();
        ScrolledForm form = managedForm.getForm();
        form.setExpandHorizontal(true);
        form.setExpandVertical(true);
        toolkit.decorateFormHeading(form.getForm());
        this.createErrorMessageHandler(managedForm);
        form.setText(this.getTitle());
        Composite body = form.getBody();
        body.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout layout = new GridLayout(2, true);
        layout.horizontalSpacing = 10;
        layout.verticalSpacing = 20;
        body.setLayout((Layout)layout);
        this.createTopSection(managedForm, body);
        this.createAliasSection(managedForm, body);
        this.createListsSection(managedForm, body);
        this.updateWidgetsStates(this.enableButton.getSelection());
        form.reflow(true);
    }

    @Override
    protected String getHelpResource() {
        return null;
    }

    protected void setInput(IEditorInput input) {
        super.setInput(input);
        this.editorInputChanged();
    }

    protected void updateWidgetsStates(boolean state) {
        this.combo.setEnabled(state);
        if (state) {
            this.listAliases(this.combo);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ListId {
        Optional,
        Required;

    }

    private class SecurityPermissionListItem
    implements GenericListBlockItem {
        private String permission;

        public SecurityPermissionListItem(String _permission) {
            this.permission = _permission;
        }

        public boolean equals(Object obj) {
            if (obj instanceof SecurityPermissionListItem) {
                SecurityPermissionListItem other = (SecurityPermissionListItem)obj;
                return this.getText().equals(other.getText());
            }
            return super.equals(obj);
        }

        public Image getImage() {
            return MTJUIPluginImages.DESC_PERMISSION_OBJ.createImage();
        }

        public String getText() {
            return this.permission;
        }

        public int hashCode() {
            String text = this.getText();
            int hash = 0;
            int i = 0;
            while (i < text.length()) {
                hash += text.charAt(i);
                ++i;
            }
            return hash;
        }
    }
}

