/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.editors.l10n.details;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.mtj.internal.core.text.l10n.L10nEntry;
import org.eclipse.mtj.internal.ui.MTJUIMessages;
import org.eclipse.mtj.internal.ui.editor.FormEntryAdapter;
import org.eclipse.mtj.internal.ui.editors.l10n.LocalesTreeSection;
import org.eclipse.mtj.internal.ui.editors.l10n.LocalizationDataEditor;
import org.eclipse.mtj.internal.ui.editors.l10n.details.L10nAbstractDetails;
import org.eclipse.mtj.internal.ui.forms.parts.FormEntry;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.events.HyperlinkEvent;

public class L10nEntryDetails
extends L10nAbstractDetails {
    private FormEntry keyEntry = null;
    private L10nEntry localeEntry = null;
    private FormEntry valueEntry = null;

    public L10nEntryDetails(LocalesTreeSection masterSection) {
        super(masterSection, "l10n-context");
    }

    public void commit(boolean onSave) {
        super.commit(onSave);
        this.keyEntry.commit();
        this.valueEntry.commit();
    }

    public void createFields(Composite parent) {
        this.createKeyWidget(parent);
        this.createSpace(parent);
        this.createValueWidget(parent);
    }

    public void hookListeners() {
        this.createLocaleEntryListeners();
        this.createPageEntryListeners();
    }

    public void selectionChanged(IFormPart part, ISelection selection) {
        Object object = this.getFirstSelectedObject(selection);
        if (object != null && object instanceof L10nEntry) {
            this.setData((L10nEntry)object);
            this.updateFields();
        }
    }

    public void setData(L10nEntry object) {
        this.localeEntry = object;
    }

    public void updateFields() {
        if (this.localeEntry != null) {
            this.updateKeyEntry(this.isEditableElement());
            this.updateValueEntry(this.isEditableElement());
        }
    }

    private void createLocaleEntryListeners() {
        this.keyEntry.setFormEntryListener(new FormEntryAdapter(this){

            public void textValueChanged(FormEntry entry) {
                if (L10nEntryDetails.this.localeEntry != null) {
                    L10nEntryDetails.this.localeEntry.setKey(L10nEntryDetails.this.keyEntry.getValue());
                    L10nEntryDetails.this.localeEntry.getParent().validate();
                    FormEditor editor = L10nEntryDetails.this.getPage().getEditor();
                    if (editor instanceof LocalizationDataEditor) {
                        ((LocalizationDataEditor)editor).updateMessageManager(L10nEntryDetails.this.localeEntry.getLocales());
                    }
                }
            }
        });
    }

    private void createKeyWidget(Composite parent) {
        this.createLabel(parent, this.getManagedForm().getToolkit(), MTJUIMessages.L10nEntryDetails_keyWidgetLabel);
        this.keyEntry = new FormEntry(parent, this.getManagedForm().getToolkit(), MTJUIMessages.L10nEntryDetails_keyEntry_label, 0);
    }

    private void createPageEntryListeners() {
        this.valueEntry.setFormEntryListener(new FormEntryAdapter(this){

            public void browseButtonSelected(FormEntry entry) {
            }

            public void linkActivated(HyperlinkEvent e) {
            }

            public void textValueChanged(FormEntry entry) {
                if (L10nEntryDetails.this.localeEntry != null) {
                    L10nEntryDetails.this.localeEntry.setValue(L10nEntryDetails.this.valueEntry.getValue());
                }
            }
        });
    }

    private void createValueWidget(Composite parent) {
        this.createLabel(parent, this.getManagedForm().getToolkit(), MTJUIMessages.L10nEntryDetails_valueWidget_label);
        this.valueEntry = new FormEntry(parent, this.getManagedForm().getToolkit(), MTJUIMessages.L10nEntryDetails_valueEntry_label, 0);
    }

    private void updateKeyEntry(boolean editable) {
        this.keyEntry.setValue(this.localeEntry.getKey(), true);
        this.keyEntry.setEditable(editable);
    }

    private void updateValueEntry(boolean editable) {
        this.valueEntry.setValue(this.localeEntry.getValue(), true);
        this.valueEntry.setEditable(editable);
    }

    protected String getDetailsDescription() {
        return MTJUIMessages.L10nEntryDetails_detailsDescription;
    }

    protected String getDetailsTitle() {
        return MTJUIMessages.L10nEntryDetails_detailsTitle;
    }
}

