/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.forms.blocks;

import java.util.ArrayList;
import org.eclipse.mtj.internal.ui.MTJUIMessages;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class ButtonBarBlock {
    public static final int BUTTON_ADD = 2;
    public static final int BUTTON_ADD_INDEX = 0;
    public static final int BUTTON_DOWN = 16;
    public static final int BUTTON_DOWN_INDEX = 3;
    public static final int BUTTON_REMOVE = 4;
    public static final int BUTTON_REMOVE_INDEX = 1;
    public static final int BUTTON_UP = 8;
    public static final int BUTTON_UP_INDEX = 2;
    public static final int BUTTON_SCAN = 32;
    public static final int BUTTON_SCAN_INDEX = 4;
    public static final int BUTTON_ALL = 62;
    private ArrayList<Button> buttons;

    public ButtonBarBlock(Composite parent, FormToolkit toolkit, int buttons) {
        this.initialize(parent, toolkit, buttons);
    }

    public ButtonBarBlock(Composite parent, int buttons) {
        this.initialize(parent, buttons);
    }

    public void addButtonListener(int button, int eventType, Listener listener) {
        this.buttons.get(button).addListener(eventType, listener);
    }

    public Button getButton(int index) {
        return this.buttons.get(index);
    }

    public boolean isButtonEnabled(int index) {
        return this.buttons.get(index).isEnabled();
    }

    public void setButtonMouseListener(int index, MouseListener listener) {
        this.buttons.get(index).addMouseListener(listener);
    }

    public void setEnabled(int index, boolean enabled) {
        this.buttons.get(index).setEnabled(enabled);
    }

    private void initialize(Composite parent, FormToolkit toolkit, int _buttons) {
        this.buttons = new ArrayList(4);
        if ((_buttons & 2) != 0) {
            Button add = toolkit.createButton(parent, MTJUIMessages.buttonBarBlock_button_add, 8);
            add.setEnabled(false);
            this.buttons.add(add);
        }
        if ((_buttons & 4) != 0) {
            Button remove = toolkit.createButton(parent, MTJUIMessages.buttonBarBlock_button_remove, 8);
            remove.setEnabled(false);
            this.buttons.add(remove);
        }
        if ((_buttons & 8) != 0) {
            Button up = toolkit.createButton(parent, MTJUIMessages.buttonBarBlock_button_up, 8);
            up.setEnabled(false);
            this.buttons.add(up);
        }
        if ((_buttons & 0x10) != 0) {
            Button down = toolkit.createButton(parent, MTJUIMessages.buttonBarBlock_button_down, 8);
            down.setEnabled(false);
            this.buttons.add(down);
        }
        if ((_buttons & 0x20) != 0) {
            Button scan = toolkit.createButton(parent, MTJUIMessages.ButtonBarBlock_Scan, 8);
            scan.setEnabled(false);
            this.buttons.add(scan);
        }
    }

    private void initialize(Composite parent, int _buttons) {
        this.buttons = new ArrayList(4);
        if ((_buttons & 2) != 0) {
            Button add = new Button(parent, 8);
            add.setText(MTJUIMessages.buttonBarBlock_button_add);
            add.setEnabled(false);
            this.buttons.add(add);
        }
        if ((_buttons & 4) != 0) {
            Button remove = new Button(parent, 8);
            remove.setText(MTJUIMessages.buttonBarBlock_button_remove);
            remove.setEnabled(false);
            this.buttons.add(remove);
        }
        if ((_buttons & 8) != 0) {
            Button up = new Button(parent, 8);
            up.setText(MTJUIMessages.buttonBarBlock_button_up);
            up.setEnabled(false);
            this.buttons.add(up);
        }
        if ((_buttons & 0x10) != 0) {
            Button down = new Button(parent, 8);
            down.setText(MTJUIMessages.buttonBarBlock_button_down);
            down.setEnabled(false);
            this.buttons.add(down);
        }
        if ((_buttons & 0x20) != 0) {
            Button scan = new Button(parent, 8);
            scan.setText(MTJUIMessages.ButtonBarBlock_Scan);
            scan.setEnabled(false);
            this.buttons.add(scan);
        }
    }

    public void setEnabled(boolean state) {
        for (Button button : this.buttons) {
            button.setEnabled(state);
        }
    }
}

