/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.forms.blocks;

import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.mtj.internal.ui.MTJUIMessages;
import org.eclipse.mtj.internal.ui.MTJUIPluginImages;
import org.eclipse.mtj.internal.ui.forms.blocks.ButtonBarBlock;
import org.eclipse.mtj.internal.ui.forms.blocks.DetailPage;
import org.eclipse.mtj.internal.ui.forms.blocks.MasterLabelProvider;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.forms.DetailsPart;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.MasterDetailsBlock;
import org.eclipse.ui.forms.SectionPart;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScrolledPropertiesBlock
extends MasterDetailsBlock {
    private ButtonBarBlock buttonBarBlock = null;
    private ISelection currentSelectedItem;
    private List<DetailPage> detailPages;
    private IStructuredContentProvider masterContentProvider;
    private MasterLabelProvider masterLabelProvider;
    private FormPage page;
    private TableViewer viewer;

    public ScrolledPropertiesBlock(FormPage page, IStructuredContentProvider contentProvider, MasterLabelProvider labelProvider, List<DetailPage> detailPages) {
        this.page = page;
        this.masterContentProvider = contentProvider;
        this.masterLabelProvider = labelProvider;
        this.detailPages = detailPages;
    }

    public ButtonBarBlock getButtonBarBlock() {
        return this.buttonBarBlock;
    }

    public ISelection getCurrentSelectedItem() {
        return this.currentSelectedItem;
    }

    public IStructuredContentProvider getMasterContentProvider() {
        return this.masterContentProvider;
    }

    public MasterLabelProvider getMasterLabelProvider() {
        return this.masterLabelProvider;
    }

    public void refresh() {
        this.viewer.refresh();
        this.currentSelectedItem = this.viewer.getSelection();
    }

    public void setCurrentSelectedItem(ISelection selection) {
        this.viewer.setSelection(selection);
    }

    public void setMasterContentProvider(IStructuredContentProvider masterContentProvider) {
        this.masterContentProvider = masterContentProvider;
    }

    public void setMasterLabelProvider(MasterLabelProvider masterLabelProvider) {
        this.masterLabelProvider = masterLabelProvider;
    }

    protected void createMasterPart(final IManagedForm managedForm, Composite parent) {
        FormToolkit toolkit = managedForm.getToolkit();
        Section section = toolkit.createSection(parent, 384);
        section.setText(MTJUIMessages.ScrolledPropertiesBlock_midlet_list_section_title);
        section.setDescription(MTJUIMessages.ScrolledPropertiesBlock_midlet_list_section_description);
        section.marginWidth = 10;
        section.marginHeight = 5;
        Composite client = toolkit.createComposite((Composite)section, 64);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 2;
        layout.marginHeight = 2;
        client.setLayout((Layout)layout);
        new Label(client, 0);
        new Label(client, 0);
        Table table = toolkit.createTable(client, 0);
        GridData gd = new GridData(1808);
        gd.heightHint = 20;
        gd.widthHint = 100;
        table.setLayoutData((Object)gd);
        toolkit.paintBordersFor(client);
        Composite composite = toolkit.createComposite(client);
        FillLayout ButtonBarBlockLayout = new FillLayout(512);
        ButtonBarBlockLayout.spacing = 3;
        composite.setLayout((Layout)ButtonBarBlockLayout);
        this.buttonBarBlock = new ButtonBarBlock(composite, toolkit, 30);
        section.setClient((Control)client);
        final SectionPart spart = new SectionPart(section);
        managedForm.addPart((IFormPart)spart);
        this.viewer = new TableViewer(table);
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ScrolledPropertiesBlock.this.currentSelectedItem = event.getSelection();
                managedForm.fireSelectionChanged((IFormPart)spart, event.getSelection());
            }
        });
        this.viewer.setContentProvider((IContentProvider)this.masterContentProvider);
        this.viewer.setLabelProvider((IBaseLabelProvider)this.masterLabelProvider);
        this.viewer.setInput((Object)this.page.getEditor().getEditorInput());
    }

    protected void createToolBarActions(IManagedForm managedForm) {
        final ScrolledForm form = managedForm.getForm();
        Action haction = new Action("hor", 8){

            public void run() {
                ScrolledPropertiesBlock.this.sashForm.setOrientation(256);
                form.reflow(true);
            }
        };
        haction.setChecked(true);
        haction.setToolTipText(MTJUIMessages.ScrolledPropertiesBlock_hor_action_toolTipText);
        haction.setImageDescriptor(MTJUIPluginImages.DESC_HORIZONTAL);
        Action vaction = new Action("ver", 8){

            public void run() {
                ScrolledPropertiesBlock.this.sashForm.setOrientation(512);
                form.reflow(true);
            }
        };
        vaction.setChecked(false);
        vaction.setToolTipText(MTJUIMessages.ScrolledPropertiesBlock_ver_action_toolTipText);
        vaction.setImageDescriptor(MTJUIPluginImages.DESC_VERTICAL);
        form.getToolBarManager().add((IAction)haction);
        form.getToolBarManager().add((IAction)vaction);
    }

    protected void registerPages(DetailsPart detailsPart) {
        Iterator<DetailPage> iterator = this.detailPages.iterator();
        while (iterator.hasNext()) {
            DetailPage detailPage;
            DetailPage type = detailPage = iterator.next();
            detailsPart.registerPage(type.getObjectClass(), type.getDetailsPage());
        }
    }
}

