/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.launching;

import java.io.File;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.debug.ui.launchConfigurations.JavaLaunchTab;
import org.eclipse.jdt.debug.ui.launchConfigurations.JavaMainTab;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.mtj.core.MTJCore;
import org.eclipse.mtj.internal.core.util.log.MTJLogger;
import org.eclipse.mtj.internal.ui.MTJUIMessages;
import org.eclipse.mtj.internal.ui.util.MidletSelectionDialogCreator;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.dialogs.SelectionDialog;

public class MidletTab
extends JavaLaunchTab {
    private Button jadBrowseButton;
    private Button jadRadio;
    private Text jadText;
    private JavaMainTab javaMainTab = new JavaMainTab();
    private Button midletRadio;
    private Text midletText;
    private Button otaRadio;
    private Button projectButton;
    private Label projectLabel;
    private Text projectText;
    private Button searchButton;

    public void createControl(Composite parent) {
        Composite comp = new Composite(parent, 0);
        this.setControl((Control)comp);
        comp.setLayout((Layout)new GridLayout());
        this.createVerticalSpacer(comp, 3);
        this.createProjectComponents(comp);
        this.createVerticalSpacer(comp, 3);
        this.createExecutableComponents(comp);
        this.updateEnablement();
    }

    public String getId() {
        return this.javaMainTab.getId();
    }

    public Image getImage() {
        return this.javaMainTab.getImage();
    }

    public String getName() {
        return MTJUIMessages.MidletTab_tab_name;
    }

    public void initializeFrom(ILaunchConfiguration config) {
        this.updateProjectFromConfig(config);
        String midletName = this.getStringOrDefault(config, IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, "");
        this.midletText.setText(midletName);
        String jadUrl = this.getStringOrDefault(config, "mtj.specified_jad_url", "");
        this.jadText.setText(jadUrl);
        boolean doOTA = true;
        boolean doJAD = false;
        try {
            doOTA = config.getAttribute("mtj.do_ota", true);
            doJAD = config.getAttribute("mtj.do_jad_launch", false);
        }
        catch (CoreException coreException) {}
        this.midletRadio.setSelection(!doOTA && !doJAD);
        this.jadRadio.setSelection(doJAD);
        this.otaRadio.setSelection(doOTA && !doJAD);
        this.updateEnablement();
    }

    public boolean isValid(ILaunchConfiguration config) {
        File jadFile;
        String errorMessage = null;
        String name = this.projectText.getText().trim();
        if (name.length() > 0 && !MTJCore.getWorkspace().getRoot().getProject(name).exists()) {
            errorMessage = MTJUIMessages.MidletTab_project_does_not_exist_error;
        }
        if (errorMessage == null && this.midletRadio.getSelection() && (name = this.midletText.getText().trim()).length() == 0) {
            errorMessage = MTJUIMessages.MidletTab_MIDlet_not_specified_error;
        }
        if (errorMessage == null && this.jadRadio.getSelection() && !(jadFile = new File(this.jadText.getText())).exists()) {
            errorMessage = MTJUIMessages.MidletTab_invalid_JAD_URL_specified_error;
        }
        this.setErrorMessage(errorMessage);
        return errorMessage == null;
    }

    public void performApply(ILaunchConfigurationWorkingCopy config) {
        config.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, this.projectText.getText().trim());
        config.setAttribute("mtj.do_jad_launch", this.jadRadio.getSelection());
        config.setAttribute("mtj.specified_jad_url", this.jadText.getText());
        config.setAttribute("mtj.do_ota", this.otaRadio.getSelection());
        config.setAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, this.midletText.getText());
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy config) {
        IJavaElement javaElement = this.getContext();
        if (javaElement != null) {
            this.initializeJavaProject(javaElement, config);
        } else {
            config.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, "");
        }
        config.setAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, "");
    }

    private IJavaProject chooseJavaProject() {
        IJavaProject project = null;
        JavaElementLabelProvider labelProvider = new JavaElementLabelProvider(JavaElementLabelProvider.SHOW_DEFAULT);
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)labelProvider);
        dialog.setTitle(MTJUIMessages.MidletTab_chooseJavaProject_title);
        dialog.setMessage(MTJUIMessages.MidletTab_chooseJavaProject_message);
        try {
            IWorkspaceRoot root = MTJCore.getWorkspace().getRoot();
            dialog.setElements((Object[])JavaCore.create((IWorkspaceRoot)root).getJavaProjects());
        }
        catch (JavaModelException jme) {
            MTJLogger.log((int)2, (Throwable)jme);
        }
        IJavaProject javaProject = this.getJavaProject();
        if (javaProject != null) {
            dialog.setInitialSelections(new Object[]{javaProject});
        }
        if (dialog.open() == 0) {
            project = (IJavaProject)dialog.getFirstResult();
        }
        return project;
    }

    private void createExecutableComponents(Composite parent) {
        Font font = parent.getFont();
        Group group = new Group(parent, 0);
        group.setText(MTJUIMessages.MidletTab_executable_text);
        GridLayout mainLayout = new GridLayout(3, false);
        mainLayout.marginHeight = 0;
        mainLayout.marginWidth = 0;
        group.setLayout((Layout)mainLayout);
        GridData gd = new GridData(768);
        group.setLayoutData((Object)gd);
        group.setFont(font);
        this.createMidletComponents(group);
        this.createJadComponents(group);
        this.otaRadio = new Button((Composite)group, 16);
        this.otaRadio.setText(MTJUIMessages.MidletTab_ota_text);
        this.otaRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MidletTab.this.updateEnablement();
                MidletTab.this.updateLaunchConfigurationDialog();
            }
        });
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.otaRadio.setLayoutData((Object)gd);
    }

    private void createJadComponents(Group parent) {
        Font font = parent.getFont();
        this.jadRadio = new Button((Composite)parent, 16);
        this.jadRadio.setText(MTJUIMessages.MidletTab_jad_url_text);
        this.jadRadio.setSelection(false);
        this.jadRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MidletTab.this.updateEnablement();
                MidletTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.jadText = new Text((Composite)parent, 2052);
        GridData gd = new GridData(768);
        this.jadText.setLayoutData((Object)gd);
        this.jadText.setFont(font);
        this.jadText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                MidletTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.jadBrowseButton = this.createPushButton((Composite)parent, MTJUIMessages.MidletTab_browse_btn, null);
        this.jadBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                MidletTab.this.handleJadBrowseSelected();
            }
        });
    }

    private void createMidletComponents(Group parent) {
        Font font = parent.getFont();
        this.midletRadio = new Button((Composite)parent, 16);
        this.midletRadio.setText(MTJUIMessages.MidletTab_midlet_text);
        this.midletRadio.setSelection(true);
        this.midletRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MidletTab.this.updateEnablement();
                MidletTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.midletText = new Text((Composite)parent, 2052);
        GridData gd = new GridData(768);
        this.midletText.setLayoutData((Object)gd);
        this.midletText.setFont(font);
        this.midletText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                MidletTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.searchButton = this.createPushButton((Composite)parent, MTJUIMessages.MidletTab_search_btn, null);
        this.searchButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                MidletTab.this.handleSearchButtonSelected();
            }
        });
    }

    private void createProjectComponents(Composite parent) {
        Font font = parent.getFont();
        Composite projComp = new Composite(parent, 0);
        GridLayout projLayout = new GridLayout();
        projLayout.numColumns = 2;
        projLayout.marginHeight = 0;
        projLayout.marginWidth = 0;
        projComp.setLayout((Layout)projLayout);
        GridData gd = new GridData(768);
        projComp.setLayoutData((Object)gd);
        projComp.setFont(font);
        this.projectLabel = new Label(projComp, 0);
        this.projectLabel.setText(MTJUIMessages.MidletTab_project_text);
        gd = new GridData();
        gd.horizontalSpan = 2;
        this.projectLabel.setLayoutData((Object)gd);
        this.projectLabel.setFont(font);
        this.projectText = new Text(projComp, 2052);
        gd = new GridData(768);
        this.projectText.setLayoutData((Object)gd);
        this.projectText.setFont(font);
        this.projectText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                MidletTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.projectButton = this.createPushButton(projComp, MTJUIMessages.MidletTab_browse_btn, null);
        this.projectButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                IJavaProject project = MidletTab.this.chooseJavaProject();
                if (project != null) {
                    String projectName = project.getElementName();
                    MidletTab.this.projectText.setText(projectName);
                }
            }
        });
    }

    private String getStringOrDefault(ILaunchConfiguration launchConfig, String attributeName, String defaultValue) {
        String value = null;
        try {
            value = launchConfig.getAttribute(attributeName, defaultValue);
        }
        catch (CoreException e) {
            MTJLogger.log((int)2, (Throwable)e);
            value = defaultValue;
        }
        return value;
    }

    private void updateEnablement() {
        boolean doMidlet = this.midletRadio.getSelection();
        this.midletText.setEnabled(doMidlet);
        this.searchButton.setEnabled(doMidlet);
        boolean doJAD = this.jadRadio.getSelection();
        this.jadText.setEnabled(doJAD);
        this.jadBrowseButton.setEnabled(doJAD);
        this.projectText.setEnabled(!doJAD);
        this.projectButton.setEnabled(!doJAD);
    }

    protected IJavaProject getJavaProject() {
        IJavaProject javaProject = null;
        String projectName = this.projectText.getText().trim();
        if (projectName.length() > 0) {
            IProject project = MTJCore.getWorkspace().getRoot().getProject(projectName);
            javaProject = JavaCore.create((IProject)project);
        }
        return javaProject;
    }

    protected void handleJadBrowseSelected() {
        FileDialog fileDialog = new FileDialog(this.getShell());
        fileDialog.setFilterExtensions(new String[]{"*.jad"});
        fileDialog.setFilterNames(new String[]{"JAD File"});
        String filename = fileDialog.open();
        if (filename != null) {
            this.jadText.setText(filename);
        }
    }

    protected void handleSearchButtonSelected() {
        try {
            IType type;
            Object[] results;
            IJavaProject javaProject = this.getJavaProject();
            SelectionDialog dialog = MidletSelectionDialogCreator.createMidletSelectionDialog(this.getShell(), (IRunnableContext)this.getLaunchConfigurationDialog(), javaProject, false);
            if (dialog.open() == 0 && (results = dialog.getResult()) != null && results.length > 0 && (type = (IType)results[0]) != null) {
                this.midletText.setText(type.getFullyQualifiedName());
                javaProject = type.getJavaProject();
                this.projectText.setText(javaProject.getElementName());
            }
        }
        catch (JavaModelException e) {
            MTJLogger.log((int)4, (String)MTJUIMessages.MidletTab_handleSearchButtonSelected_error, (Throwable)e);
        }
    }

    protected void updateProjectFromConfig(ILaunchConfiguration config) {
        String projectName = "";
        try {
            projectName = config.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, "");
        }
        catch (CoreException ce) {
            MTJLogger.log((int)2, (String)MTJUIMessages.MidletTab_updateProjectFromConfig_error, (Throwable)ce);
        }
        this.projectText.setText(projectName);
    }
}

