/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.launching;

import java.util.List;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.ILaunchShortcut;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.mtj.internal.ui.MTJUIMessages;
import org.eclipse.mtj.internal.ui.MTJUIPlugin;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class NonJavaLaunchShortcut
implements ILaunchShortcut {
    public void launch(ISelection selection, String mode) {
        List<ILaunchConfiguration> candidates = null;
        candidates = this.getLaunchConfigurations(selection);
        this.doLaunch(candidates, mode);
    }

    public void launch(IEditorPart editor, String mode) {
        List<ILaunchConfiguration> candidates = null;
        candidates = this.getLaunchConfigurations(editor);
        this.doLaunch(candidates, mode);
    }

    private void doLaunch(List<ILaunchConfiguration> candidates, String mode) {
        ILaunchConfiguration target = null;
        if (candidates == null) {
            return;
        }
        int candidateCount = candidates.size();
        if (candidateCount < 1) {
            target = this.createConfiguration();
        } else if (candidateCount == 1) {
            target = candidates.get(0);
        } else {
            ILaunchConfiguration config = this.chooseConfiguration(candidates);
            if (config != null) {
                target = config;
            }
        }
        DebugUITools.launch((ILaunchConfiguration)target, (String)mode);
    }

    protected abstract List<ILaunchConfiguration> getLaunchConfigurations(ISelection var1);

    protected abstract List<ILaunchConfiguration> getLaunchConfigurations(IEditorPart var1);

    protected abstract ILaunchConfiguration createConfiguration();

    private ILaunchConfiguration chooseConfiguration(List<ILaunchConfiguration> configList) {
        IDebugModelPresentation labelProvider = DebugUITools.newDebugModelPresentation();
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)labelProvider);
        dialog.setElements(configList.toArray());
        dialog.setTitle(MTJUIMessages.launch_configSelection_title);
        dialog.setMessage(MTJUIMessages.launch_configSelection_message);
        dialog.setMultipleSelection(false);
        int result = dialog.open();
        labelProvider.dispose();
        if (result == 0) {
            return (ILaunchConfiguration)dialog.getFirstResult();
        }
        return null;
    }

    private Shell getShell() {
        Shell shell = null;
        IWorkbenchWindow workbenchWindow = MTJUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
        if (workbenchWindow != null) {
            shell = workbenchWindow.getShell();
        }
        return shell;
    }
}

