/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.launching;

import java.util.Map;
import java.util.Stack;
import org.eclipse.debug.ui.console.IConsole;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.mtj.internal.core.launching.StackTraceEntry;
import org.eclipse.mtj.internal.core.launching.StackTraceParser;
import org.eclipse.mtj.internal.core.launching.StackTraceParserException;
import org.eclipse.mtj.internal.core.util.log.MTJLogger;
import org.eclipse.mtj.internal.ui.launching.MTJConsoleHyperLink;
import org.eclipse.mtj.internal.ui.launching.MTJConsoleLineTracker;
import org.eclipse.ui.console.IHyperlink;
import org.eclipse.ui.console.IPatternMatchListener;
import org.eclipse.ui.console.PatternMatchEvent;
import org.eclipse.ui.console.TextConsole;

public abstract class StackTraceMatcher
implements IPatternMatchListener {
    protected MTJConsoleLineTracker tracker;
    protected StackTraceParser parser;

    public StackTraceMatcher(MTJConsoleLineTracker _tracker, StackTraceParser _parser) {
        this.tracker = _tracker;
        this.parser = _parser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void matchFound(PatternMatchEvent event) {
        try {
            Stack<StackTraceEntry> stack = new Stack<StackTraceEntry>();
            String trace = this.tracker.getConsole().getDocument().get(event.getOffset(), event.getLength());
            String[] lines = trace.split(System.getProperty("line.separator"));
            Map<String, StackTraceEntry> cachedTrace = this.tracker.getCachedTrace();
            int i = 0;
            while (i < lines.length) {
                Map<String, StackTraceEntry> map = cachedTrace;
                synchronized (map) {
                    StackTraceEntry entry = cachedTrace.get(lines[i]);
                    if (entry == null) {
                        entry = new StackTraceEntry(lines[i]);
                        cachedTrace.put(lines[i], entry);
                    }
                    stack.push(entry);
                }
                ++i;
            }
            Stack linedStack = this.parser.parseStackTrace(stack);
            IConsole console = this.tracker.getConsole();
            while (!linedStack.isEmpty()) {
                StackTraceEntry stackEntry = (StackTraceEntry)linedStack.pop();
                for (IRegion region : stackEntry.getRegions()) {
                    MTJConsoleHyperLink link = new MTJConsoleHyperLink(stackEntry);
                    console.addLink((IHyperlink)link, region.getOffset(), region.getLength());
                }
            }
        }
        catch (BadLocationException e) {
            MTJLogger.log((int)4, (String)e.getMessage(), (Throwable)e);
        }
        catch (StackTraceParserException e) {
            MTJLogger.log((int)4, (String)e.getMessage(), (Throwable)e);
        }
    }

    public abstract String getPattern();

    public void connect(TextConsole console) {
    }

    public void disconnect() {
    }

    public int getCompilerFlags() {
        return 0;
    }

    public String getLineQualifier() {
        return null;
    }
}

