/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.preferences;

import java.io.File;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.mtj.internal.core.build.sign.PreferencesSignatureProperties;
import org.eclipse.mtj.internal.core.sign.DefaultKeyStoreManager;
import org.eclipse.mtj.internal.core.sign.IKeyStoreManager;
import org.eclipse.mtj.internal.core.sign.KeyStoreManagerException;
import org.eclipse.mtj.internal.core.util.log.MTJLogger;
import org.eclipse.mtj.internal.ui.IMTJUIConstants;
import org.eclipse.mtj.internal.ui.MTJUIMessages;
import org.eclipse.mtj.internal.ui.MTJUIPlugin;
import org.eclipse.mtj.internal.ui.dialog.SigningPasswordDialog;
import org.eclipse.mtj.internal.ui.forms.blocks.SigningBlock;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class SigningPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private PreferencesSignatureProperties sigProps;
    private SigningBlock signingBlock;
    private IKeyStoreManager keyStoreManager;
    private Text keystoreTxt;
    private Button externalBtn;
    private Button passwordBtn;
    private Button ksPasswordBtn1;
    private Text keystorePasswordTxt;
    private Button ksPasswordBtn2;

    public SigningPreferencePage() {
        try {
            this.sigProps = new PreferencesSignatureProperties();
        }
        catch (CoreException e) {
            this.setErrorMessage(e.getMessage());
        }
    }

    protected Control createContents(Composite parent) {
        parent.setLayout((Layout)new GridLayout(1, true));
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)MTJUIPlugin.buildGridData(16384, 0x1000000, true, true));
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        this.createKeyStoreSection(composite);
        this.signingBlock = new SigningBlock();
        this.signingBlock.createBlock(composite);
        this.loadSigningData();
        return composite;
    }

    private void loadSigningData() {
        this.keystoreTxt.setText(this.convertNullToEmpty(this.sigProps.getKeyStoreDisplayPath()));
        this.keystorePasswordTxt.setText(this.convertNullToEmpty(this.sigProps.getKeyStorePassword()));
        int passwdType = this.sigProps.getPasswordStorageMethod();
        switch (passwdType) {
            case 1: {
                this.ksPasswordBtn1.setSelection(false);
                this.ksPasswordBtn2.setSelection(true);
                this.keystorePasswordTxt.setEnabled(true);
                break;
            }
            case 0: {
                this.ksPasswordBtn2.setSelection(false);
                this.ksPasswordBtn1.setSelection(true);
                this.keystorePasswordTxt.setEnabled(false);
            }
        }
        this.signingBlock.setProvider(this.sigProps.getKeyStoreProvider());
        this.signingBlock.setKeystoreType(this.sigProps.getKeyStoreType());
        this.loadAliases();
    }

    private String convertNullToEmpty(String s) {
        if (s == null) {
            return "";
        }
        return s;
    }

    public boolean performOk() {
        if (this.sigProps.getPasswordStorageMethod() != 0) {
            this.sigProps.setKeyStorePassword(this.keystorePasswordTxt.getText());
        }
        this.sigProps.setKeyStoreProvider(this.signingBlock.getProvider());
        this.sigProps.setKeyStoreType(this.signingBlock.getKeystoreType());
        return this.sigProps.save();
    }

    protected void performDefaults() {
        super.performDefaults();
        this.signingBlock.setInput(null);
        this.passwordBtn.setEnabled(false);
        this.sigProps.clear();
        this.loadSigningData();
    }

    private void createKeyStoreSection(Composite parent) {
        Group ksGroup = new Group(parent, 0);
        ksGroup.setLayoutData((Object)MTJUIPlugin.buildGridData(4, 4, true, false));
        GridLayout layout = new GridLayout(4, false);
        layout.verticalSpacing = 0;
        ksGroup.setLayout((Layout)layout);
        ksGroup.setText(MTJUIMessages.SigningPreferencePage_keyStore);
        Label location = new Label((Composite)ksGroup, 0);
        location.setText(MTJUIMessages.SigningPreferencePage_location);
        GridData gridData = MTJUIPlugin.buildGridData(4, 0x1000000, true, false);
        gridData.horizontalSpan = 4;
        location.setLayoutData((Object)gridData);
        this.keystoreTxt = new Text((Composite)ksGroup, 2048);
        this.keystoreTxt.setLayoutData((Object)MTJUIPlugin.buildGridData(4, 0x1000000, true, false));
        this.externalBtn = new Button((Composite)ksGroup, 0);
        this.externalBtn.setText(MTJUIMessages.SigningPreferencePage_external);
        this.externalBtn.setLayoutData((Object)MTJUIPlugin.buildGridData(false, false));
        this.externalBtn.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseUp(MouseEvent e) {
                SigningPreferencePage.this.browseExternalForKeystore();
            }
        });
        this.passwordBtn = new Button((Composite)ksGroup, 0);
        this.passwordBtn.setText(MTJUIMessages.SigningPreferencePage_changePassword);
        this.passwordBtn.setLayoutData((Object)MTJUIPlugin.buildGridData(false, false));
        this.passwordBtn.setEnabled(false);
        this.passwordBtn.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
                if (SigningPreferencePage.this.keyStoreManager == null) {
                    return;
                }
                SigningPasswordDialog dialog = new SigningPasswordDialog(SigningPreferencePage.this.getShell(), false);
                dialog.setTitle("Change Keystore Password");
                dialog.setDescription("Enter the new keystore password");
                if (dialog.open() != 0) {
                    return;
                }
                String kstPassword = dialog.getPassword();
                try {
                    SigningPreferencePage.this.keyStoreManager.changeKeystorePassword(kstPassword);
                    SigningPreferencePage.this.sigProps.setKeyStorePassword(kstPassword);
                    SigningPreferencePage.this.sigProps.save();
                    if (SigningPreferencePage.this.sigProps.getPasswordStorageMethod() != 0) {
                        SigningPreferencePage.this.keystorePasswordTxt.setText(SigningPreferencePage.this.sigProps.getKeyStorePassword());
                    }
                }
                catch (KeyStoreManagerException exc) {
                    MessageDialog.openError((Shell)SigningPreferencePage.this.getShell(), (String)"Keystore Manager Error", (String)exc.getMessage());
                    MTJLogger.log((int)4, (String)exc.getMessage());
                }
            }

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
            }
        });
        Composite passwordGroup = new Composite((Composite)ksGroup, 0);
        gridData = MTJUIPlugin.buildGridData(4, 4, true, false);
        gridData.horizontalSpan = 4;
        passwordGroup.setLayoutData((Object)gridData);
        passwordGroup.setLayout((Layout)new GridLayout(3, true));
        this.ksPasswordBtn1 = new Button(passwordGroup, 16);
        this.ksPasswordBtn1.setText(MTJUIMessages.SigningPreferencePage_promptPassword);
        this.ksPasswordBtn1.setLayoutData((Object)MTJUIPlugin.buildGridData(false, false));
        this.ksPasswordBtn1.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                SigningPreferencePage.this.keystorePasswordTxt.setEnabled(!SigningPreferencePage.this.ksPasswordBtn1.getSelection());
                SigningPreferencePage.this.keystorePasswordTxt.setText("");
                SigningPreferencePage.this.sigProps.setPasswordStorageMethod(0);
                SigningPreferencePage.this.sigProps.setKeyStorePassword("");
            }
        });
        this.ksPasswordBtn2 = new Button(passwordGroup, 16);
        this.ksPasswordBtn2.setText(MTJUIMessages.SigningPreferencePage_savePasswordInWorkspace);
        this.ksPasswordBtn2.setLayoutData((Object)MTJUIPlugin.buildGridData(false, false));
        this.ksPasswordBtn2.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                SigningPreferencePage.this.keystorePasswordTxt.setEnabled(SigningPreferencePage.this.ksPasswordBtn2.getSelection());
                SigningPreferencePage.this.sigProps.setPasswordStorageMethod(1);
            }
        });
        Composite ksPasswordGroup = new Composite((Composite)ksGroup, 0);
        gridData = MTJUIPlugin.buildGridData(4, 4, true, false);
        gridData.horizontalSpan = 4;
        ksPasswordGroup.setLayoutData((Object)gridData);
        ksPasswordGroup.setLayout((Layout)new GridLayout(2, false));
        Label kstPasswordLabel = new Label(ksPasswordGroup, 0);
        kstPasswordLabel.setText(MTJUIMessages.SigningPreferencePage_keystorePassword);
        kstPasswordLabel.setLayoutData((Object)MTJUIPlugin.buildGridData(false, false));
        this.keystorePasswordTxt = new Text(ksPasswordGroup, 2048);
        this.keystorePasswordTxt.setLayoutData((Object)MTJUIPlugin.buildGridData(4, 0x1000000, true, false));
    }

    private void loadAliases() {
        String path = this.sigProps.getKeyStoreDisplayPath();
        if (path == null) {
            return;
        }
        File keyStoreFile = new File(path);
        if (!keyStoreFile.exists() || !keyStoreFile.isFile()) {
            return;
        }
        if (this.sigProps.getPasswordStorageMethod() != 0) {
            String kstPassword = this.keystorePasswordTxt.getText();
            this.keyStoreManager = new DefaultKeyStoreManager(keyStoreFile, kstPassword);
            this.keyStoreManager.setProvider(this.signingBlock.getProvider());
            this.keyStoreManager.setKeystoreType(this.signingBlock.getKeystoreType());
            this.signingBlock.setInput(this.keyStoreManager);
            this.passwordBtn.setEnabled(true);
            String alias = this.sigProps.getKeyAlias();
            if (alias != null) {
                this.signingBlock.setCurrentAlias(alias);
            }
        } else {
            this.openKeyStorePasswordDialog(keyStoreFile);
        }
    }

    private void openKeyStorePasswordDialog(final File keyStoreFile) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                SigningPasswordDialog dialog = new SigningPasswordDialog(SigningPreferencePage.this.getShell(), true);
                dialog.setTitle(MTJUIMessages.SigningPreferencePage_enterPassword);
                dialog.setDescription(MTJUIMessages.SigningPreferencePage_dialogTitle);
                if (dialog.open() != 0) {
                    return;
                }
                String kstPassword = dialog.getPassword();
                SigningPreferencePage.this.sigProps.setPasswordStorageMethod(0);
                if (dialog.isSavingInWorkspace()) {
                    SigningPreferencePage.this.sigProps.setPasswordStorageMethod(1);
                    SigningPreferencePage.this.keystorePasswordTxt.setText(kstPassword);
                    SigningPreferencePage.this.keystorePasswordTxt.setEnabled(true);
                    SigningPreferencePage.this.ksPasswordBtn2.setSelection(true);
                    SigningPreferencePage.this.ksPasswordBtn1.setSelection(false);
                }
                SigningPreferencePage.this.keyStoreManager = (IKeyStoreManager)new DefaultKeyStoreManager(keyStoreFile, kstPassword);
                SigningPreferencePage.this.keyStoreManager.setProvider(SigningPreferencePage.this.signingBlock.getProvider());
                SigningPreferencePage.this.keyStoreManager.setKeystoreType(SigningPreferencePage.this.signingBlock.getKeystoreType());
                SigningPreferencePage.this.signingBlock.setInput(SigningPreferencePage.this.keyStoreManager);
                SigningPreferencePage.this.passwordBtn.setEnabled(true);
            }
        });
    }

    private void browseExternalForKeystore() {
        FileDialog dlg = new FileDialog(this.getShell(), 4096);
        dlg.setText(MTJUIMessages.J2MESigningPropertiesPage_browse_dialog_title);
        dlg.setFilterNames(IMTJUIConstants.BROWSE_FILTER_NAMES);
        dlg.setFilterExtensions(IMTJUIConstants.BROWSE_FILTER_EXTENSIONS);
        String path = dlg.open();
        if (path == null) {
            return;
        }
        this.resetPasswords();
        this.sigProps.setKeyStoreDisplayPath(path);
        this.keystoreTxt.setText(path);
        this.loadAliases();
    }

    private void resetPasswords() {
        this.keystorePasswordTxt.setEnabled(false);
        this.keystorePasswordTxt.setText("");
        this.ksPasswordBtn1.setSelection(true);
        this.ksPasswordBtn2.setSelection(false);
        this.sigProps.setPasswordStorageMethod(0);
        this.sigProps.setKeyStorePassword("");
    }

    public void init(IWorkbench workbench) {
    }
}

