/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.templates.midlets;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.mtj.internal.ui.MTJUIMessages;
import org.eclipse.mtj.internal.ui.templates.midlets.MIDletTemplateBuilderException;
import org.eclipse.mtj.internal.ui.templates.midlets.MIDletTemplateObject;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MidletTemplateBuilder {
    private MIDletTemplateObject template;
    private Map<String, String> dictionary;

    public MidletTemplateBuilder(MIDletTemplateObject template, Map<String, String> dictionary) {
        this.template = template;
        this.dictionary = dictionary;
    }

    public IType build(IPackageFragmentRoot _source, String _package, String _name) throws MIDletTemplateBuilderException {
        try {
            Map<String, Object> templates = null;
            Object bundleObj = null;
            File file = FileLocator.getBundleFile((Bundle)this.template.getBundle());
            if (!file.isDirectory()) {
                bundleObj = new ZipFile(file);
                templates = this.getTemplates((ZipFile)bundleObj);
            } else {
                bundleObj = file;
                templates = this.getTemplates((File)bundleObj);
            }
            return this.build(_source, _package, _name, bundleObj, templates);
        }
        catch (Exception e) {
            throw new MIDletTemplateBuilderException(String.valueOf(MTJUIMessages.MidletTemplateBuilder_UnableToBuildTemplate) + e.getMessage());
        }
    }

    private IType build(IPackageFragmentRoot _source, String _package, String _name, Object _bundleObj, Map<String, Object> _templates) throws MIDletTemplateBuilderException {
        NullProgressMonitor monitor = new NullProgressMonitor();
        IType createdType = null;
        try {
            IPackageFragment pack = _source.createPackageFragment(_package, true, (IProgressMonitor)monitor);
            for (String name : _templates.keySet()) {
                Object template;
                boolean isMidlet = false;
                String code = null;
                String clazzName = NLS.bind((String)"{0}.java", (Object)name.replace(".template", ""));
                if (clazzName.equalsIgnoreCase("$class_name$.java")) {
                    clazzName = NLS.bind((String)"{0}.java", (Object)_name);
                    isMidlet = true;
                }
                if ((template = _templates.get(name)) instanceof ZipEntry) {
                    ZipFile zipFile = (ZipFile)_bundleObj;
                    code = this.processTemplate(zipFile.getInputStream((ZipEntry)template), _package, _name);
                } else {
                    code = this.processTemplate(new FileInputStream((File)template), _package, _name);
                }
                ICompilationUnit cu = pack.createCompilationUnit(clazzName, code, true, (IProgressMonitor)monitor);
                if (!isMidlet) continue;
                createdType = cu.getType(_name);
            }
            IProject project = _source.getJavaProject().getProject();
            File folder = new File(project.getLocation().toOSString());
            if (_bundleObj instanceof ZipFile) {
                this.copyResources((ZipFile)_bundleObj, folder);
            } else {
                this.copyResources((File)_bundleObj, folder);
            }
            project.refreshLocal(2, (IProgressMonitor)monitor);
            return createdType;
        }
        catch (Exception e) {
            throw new MIDletTemplateBuilderException(String.valueOf(MTJUIMessages.MidletTemplateBuilder_UnableToGenerateClasses) + e.getMessage());
        }
    }

    private void copyFile(File source, File target) throws IOException {
        File file = null;
        if (source.isDirectory()) {
            File[] children;
            file = new File(target, source.getName());
            if (!file.exists() && !file.mkdir()) {
                return;
            }
            File[] fileArray = children = source.listFiles();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                File child = fileArray[n2];
                this.copyFile(child, file);
                ++n2;
            }
        } else {
            file = new File(target, source.getName());
            FileOutputStream out = null;
            FileInputStream in = null;
            try {
                out = new FileOutputStream(file);
                in = new FileInputStream(source);
                this.copyStreams(in, out);
            }
            finally {
                out.close();
                in.close();
            }
        }
    }

    private void copyResources(File bundleFolder, File projectFolder) throws IOException {
        String path = NLS.bind((String)"templates/{0}/resources", (Object)this.template.getId());
        File resources = new File(bundleFolder, path);
        if (resources.exists() && resources.isDirectory()) {
            File[] children;
            File[] fileArray = children = resources.listFiles();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                File child = fileArray[n2];
                this.copyFile(child, projectFolder);
                ++n2;
            }
        }
    }

    private void copyResources(ZipFile zipFile, File projectFolder) throws IOException {
        String expression = NLS.bind((String)"templates/{0}/resources/.+", (Object)this.template.getId());
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        while (entries.hasMoreElements()) {
            ZipEntry zipEntry = entries.nextElement();
            if (!Pattern.matches(expression, zipEntry.getName())) continue;
            IPath path = new Path(zipEntry.getName()).removeFirstSegments(3);
            File file = new File(projectFolder, path.toString());
            if (!zipEntry.isDirectory()) {
                this.createFileFromZipFile(file, zipFile, zipEntry);
                continue;
            }
            this.createFolderFromZipFile(file);
        }
    }

    private void createFolderFromZipFile(File folder) {
        if (!folder.exists()) {
            folder.mkdir();
        }
    }

    private void copyStreams(InputStream in, OutputStream out) throws IOException {
        int _byte = -1;
        while ((_byte = in.read()) != -1) {
            out.write(_byte);
        }
    }

    private void createFileFromZipFile(File file, ZipFile zipFile, ZipEntry zipEntry) throws IOException {
        FileOutputStream out = new FileOutputStream(file);
        InputStream in = zipFile.getInputStream(zipEntry);
        this.copyStreams(in, out);
        ((OutputStream)out).close();
        in.close();
    }

    private Map<String, Object> getTemplates(File folder) {
        HashMap<String, Object> templates = new HashMap<String, Object>();
        String path = NLS.bind((String)"templates/{0}/java", (Object)this.template.getId());
        File javaFolder = new File(folder, path);
        if (javaFolder.exists() && javaFolder.isDirectory()) {
            File[] files;
            File[] fileArray = files = javaFolder.listFiles();
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.isFile() && Pattern.matches(".+[.template]", file.getName())) {
                    templates.put(file.getName(), file);
                }
                ++n2;
            }
        }
        return templates;
    }

    private Map<String, Object> getTemplates(ZipFile zipFile) {
        HashMap<String, Object> templates = new HashMap<String, Object>();
        String expression = NLS.bind((String)"templates/{0}/java/.+[.]template", (Object)this.template.getId());
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            if (!Pattern.matches(expression, entry.getName())) continue;
            Path path = new Path(entry.getName());
            templates.put(path.lastSegment(), entry);
        }
        return templates;
    }

    private String processTemplate(InputStream in, String _package, String _name) throws IOException, CoreException {
        BufferedReader reader = null;
        StringBuffer buffer = null;
        reader = new BufferedReader(new InputStreamReader(in));
        buffer = new StringBuffer();
        if (_package != null && _package.trim().length() > 0) {
            buffer.append(NLS.bind((String)"package {0};\n", (Object)_package));
        }
        String line = null;
        while ((line = reader.readLine()) != null) {
            buffer.append(line).append("\n");
        }
        reader.close();
        String content = buffer.toString();
        content = content.replace("$class_name$", _name);
        for (String key : this.dictionary.keySet()) {
            content = content.replace(key, this.dictionary.get(key));
        }
        return content;
    }
}

