/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.util;

import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.mtj.internal.core.util.log.MTJLogger;
import org.eclipse.mtj.internal.ui.MTJUIMessages;
import org.eclipse.mtj.internal.ui.MTJUIPlugin;
import org.eclipse.swt.widgets.Shell;

public class ExceptionHandler {
    private static ExceptionHandler instance = new ExceptionHandler();

    public static void handle(CoreException e, Shell parent, String title, String message) {
        instance.perform(e, parent, title, message);
    }

    public static void handle(CoreException e, String title, String message) {
        ExceptionHandler.handle(e, MTJUIPlugin.getActiveWorkbenchShell(), title, message);
    }

    public static void handle(InvocationTargetException e, Shell parent, String title, String message) {
        instance.perform(e, parent, title, message);
    }

    public static void handle(InvocationTargetException e, String title, String message) {
        ExceptionHandler.handle(e, MTJUIPlugin.getActiveWorkbenchShell(), title, message);
    }

    public static void log(Throwable t, String message) {
        MTJLogger.log((int)4, (String)message, (Throwable)t);
    }

    private void displayMessageDialog(String exceptionMessage, Shell shell, String title, String message) {
        StringWriter msg = new StringWriter();
        if (message != null) {
            msg.write(message);
            msg.write("\n\n");
        }
        if (exceptionMessage == null || exceptionMessage.length() == 0) {
            msg.write(MTJUIMessages.ExceptionHandler_displayMessageDialog_message);
        } else {
            msg.write(exceptionMessage);
        }
        MessageDialog.openError((Shell)shell, (String)title, (String)msg.toString());
    }

    protected void perform(CoreException e, Shell shell, String title, String message) {
        MTJLogger.log((int)4, (Throwable)e);
        IStatus status = e.getStatus();
        if (status != null) {
            ErrorDialog.openError((Shell)shell, (String)title, (String)message, (IStatus)status);
        } else {
            this.displayMessageDialog(e.getMessage(), shell, title, message);
        }
    }

    protected void perform(InvocationTargetException e, Shell shell, String title, String message) {
        Throwable target = e.getTargetException();
        if (target instanceof CoreException) {
            this.perform((CoreException)target, shell, title, message);
        } else {
            MTJLogger.log((int)4, (Throwable)e);
            if (e.getMessage() != null && e.getMessage().length() > 0) {
                this.displayMessageDialog(e.getMessage(), shell, title, message);
            } else {
                this.displayMessageDialog(target.getMessage(), shell, title, message);
            }
        }
    }
}

