/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.wizards.export.antenna;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.mtj.core.project.midp.IMidletSuiteProject;
import org.eclipse.mtj.internal.core.project.midp.MidletSuiteFactory;
import org.eclipse.mtj.internal.ui.MTJUIMessages;
import org.eclipse.mtj.internal.ui.MTJUIPlugin;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AntennaBuildFileExportPage
extends WizardPage {
    private List<IJavaProject> fSelectedJavaProjects = new ArrayList<IJavaProject>();
    private Table table;
    private TableViewer tableViewer;
    private Text txtMtjbuild;
    private Text txtMtjbuildxml;

    protected AntennaBuildFileExportPage() {
        super("AntennaBuildFileWizardPage");
        this.setPageComplete(false);
        this.setTitle(MTJUIMessages.AntennaBuildFileExportPage_title);
        this.setDescription(MTJUIMessages.AntennaBuildFileExportPage_description);
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite workArea = new Composite(parent, 0);
        this.setControl((Control)workArea);
        workArea.setLayout((Layout)new GridLayout(1, false));
        Link antennaPrefLink = new Link(workArea, 0);
        antennaPrefLink.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 1, 1));
        antennaPrefLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreferencesUtil.createPreferenceDialogOn((Shell)AntennaBuildFileExportPage.this.getShell(), (String)"org.eclipse.mtj.ui.preferences.J2MEPreferencePage", null, null).open();
                AntennaBuildFileExportPage.this.updatePageStatus();
            }
        });
        antennaPrefLink.setText(MTJUIMessages.AntennaBuildFileExportPage_preferencesLink);
        Label lblSelectTheProject = new Label(workArea, 0);
        lblSelectTheProject.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 1, 1));
        lblSelectTheProject.setText(MTJUIMessages.AntennaBuildFileExportPage_selectProject);
        this.tableViewer = new TableViewer(workArea, 67584);
        this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                AntennaBuildFileExportPage.this.updatePageStatus();
            }
        });
        this.table = this.tableViewer.getTable();
        this.table.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        Composite composite = new Composite(workArea, 0);
        composite.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        composite.setLayout((Layout)new GridLayout(2, false));
        Label lblBuildDirectory = new Label(composite, 0);
        lblBuildDirectory.setText(MTJUIMessages.AntennaBuildFileExportPage_buildDirectory);
        this.txtMtjbuild = new Text(composite, 2048);
        this.txtMtjbuild.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AntennaBuildFileExportPage.this.updatePageStatus();
            }
        });
        this.txtMtjbuild.setText("mtj-build");
        this.txtMtjbuild.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label lblNameForBuild = new Label(composite, 0);
        lblNameForBuild.setBounds(0, 0, 49, 13);
        lblNameForBuild.setText(MTJUIMessages.AntennaBuildFileExportPage_buildFileName);
        this.txtMtjbuildxml = new Text(composite, 2048);
        this.txtMtjbuildxml.setText("mtj-build.xml");
        this.txtMtjbuildxml.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.txtMtjbuildxml.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AntennaBuildFileExportPage.this.updatePageStatus();
            }
        });
        this.tableViewer.setContentProvider((IContentProvider)new WorkbenchContentProvider(){

            public Object[] getElements(Object element) {
                if (element instanceof IJavaProject[]) {
                    return (Object[])element;
                }
                return null;
            }
        });
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        this.initializeProjects();
        this.updatePageStatus();
        Dialog.applyDialogFont((Control)parent);
    }

    private void updatePageStatus() {
        if (!this.isAntennaConfigurationValid()) {
            this.setErrorMessage(MTJUIMessages.AntennaBuildFileExportPage_antennaPreferencesMessage);
            this.setPageComplete(false);
            return;
        }
        if (this.tableViewer.getSelection().isEmpty()) {
            this.setPageComplete(false);
            return;
        }
        if (this.txtMtjbuild.getText() == null || this.txtMtjbuild.getText().length() < 1) {
            this.setPageComplete(false);
            this.setErrorMessage(MTJUIMessages.AntennaBuildFileExportPage_buildDirectoryMissingMessage);
            return;
        }
        if (this.txtMtjbuildxml.getText() == null || this.txtMtjbuildxml.getText().length() < 1) {
            this.setPageComplete(false);
            this.setErrorMessage(MTJUIMessages.AntennaBuildFileExportPage_buildFileMissingMessage);
            return;
        }
        this.setErrorMessage(null);
        this.setPageComplete(true);
    }

    private void initializeProjects() {
        IJavaProject[] javaProjects;
        IWorkspaceRoot rootWorkspace = ResourcesPlugin.getWorkspace().getRoot();
        IJavaModel javaModel = JavaCore.create((IWorkspaceRoot)rootWorkspace);
        try {
            javaProjects = javaModel.getJavaProjects();
        }
        catch (JavaModelException javaModelException) {
            javaProjects = new IJavaProject[]{};
        }
        ArrayList<IJavaProject> midlets = new ArrayList<IJavaProject>(javaProjects.length);
        int i = 0;
        while (i < javaProjects.length) {
            if (MidletSuiteFactory.isMidletSuiteProject((IProject)javaProjects[i].getProject())) {
                midlets.add(javaProjects[i]);
            }
            ++i;
        }
        this.tableViewer.setInput((Object)midlets.toArray(new IJavaProject[midlets.size()]));
        if (this.fSelectedJavaProjects != null && !this.fSelectedJavaProjects.isEmpty()) {
            this.tableViewer.setSelection((ISelection)new StructuredSelection((Object)this.fSelectedJavaProjects.get(0)));
        }
    }

    void setSelectedProjects(List<IJavaProject> projects) {
        this.fSelectedJavaProjects.addAll(projects);
    }

    private boolean isAntennaConfigurationValid() {
        IPreferenceStore prefs = MTJUIPlugin.getDefault().getCorePreferenceStore();
        File antennaJar = new File(prefs.getString("antenna_jar"));
        File wtkRoot = new File(prefs.getString("wtk_root"));
        return antennaJar.exists() && antennaJar.isFile() && wtkRoot.exists() && wtkRoot.isDirectory();
    }

    public IMidletSuiteProject getMidletProject() {
        if (this.tableViewer.getSelection().isEmpty()) {
            return null;
        }
        IStructuredSelection selection = (IStructuredSelection)this.tableViewer.getSelection();
        IJavaProject project = (IJavaProject)selection.getFirstElement();
        return MidletSuiteFactory.getMidletSuiteProject((IJavaProject)project);
    }

    public String getBuildFileName() {
        return this.txtMtjbuildxml.getText();
    }

    public String getBuildDirectory() {
        return this.txtMtjbuild.getText();
    }
}

