/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.wizards.templates.midlets;

import java.util.Collection;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.ui.wizards.NewTypeWizardPage;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.mtj.internal.ui.MTJUIMessages;
import org.eclipse.mtj.internal.ui.MTJUIPluginImages;
import org.eclipse.mtj.internal.ui.templates.midlets.MIDletTemplateObject;
import org.eclipse.mtj.internal.ui.templates.midlets.MIDletTemplateRegistry;
import org.eclipse.mtj.internal.ui.wizards.templates.TemplateWizardPageDelegate;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.forms.HyperlinkSettings;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledFormText;

public class MidletTemplateListWizardPage
extends NewTypeWizardPage {
    public static final String MIDLET_TEMPLATE_WIZARD_PAGE_1 = "MidletTemplateListWizardPage";
    private ScrolledFormText descriptionText;
    private TableViewer viewer;
    protected MIDletTemplateObject template;
    private Button disable;

    public MidletTemplateListWizardPage() {
        super(true, MIDLET_TEMPLATE_WIZARD_PAGE_1);
        this.setTitle(MTJUIMessages.MidletTemplateWizardPage1_Page1Title);
        this.setDescription(MTJUIMessages.MidletTemplateWizardPage1_Page1Description);
    }

    public boolean canFlipToNextPage() {
        return !this.viewer.getSelection().isEmpty();
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createTemplatesList(composite);
        this.createDetails(composite);
        this.setControl((Control)composite);
    }

    private void createDetails(Composite composite) {
        Label label = new Label(composite, 0);
        label.setText(MTJUIMessages.MidletTemplateWizardPage1_DescriptionLabel);
        label.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        final FormToolkit toolkit = new FormToolkit(composite.getDisplay());
        int borderStyle = toolkit.getBorderStyle() == 2048 ? 0 : 2048;
        Composite container = new Composite(composite, borderStyle);
        FillLayout flayout = new FillLayout();
        flayout.marginWidth = 1;
        flayout.marginHeight = 1;
        container.setLayout((Layout)flayout);
        container.setLayoutData((Object)new GridData(4, 4, true, true));
        this.descriptionText = new ScrolledFormText(container, 768, false);
        if (borderStyle == 0) {
            this.descriptionText.setData("FormWidgetFactory.drawBorder", (Object)"treeBorder");
            toolkit.paintBordersFor(container);
        }
        FormText ftext = toolkit.createFormText((Composite)this.descriptionText, false);
        this.descriptionText.setFormText(ftext);
        this.descriptionText.setExpandHorizontal(true);
        this.descriptionText.setExpandVertical(true);
        this.descriptionText.setBackground(toolkit.getColors().getBackground());
        this.descriptionText.setForeground(toolkit.getColors().getForeground());
        ftext.marginWidth = 2;
        ftext.marginHeight = 2;
        ftext.setHyperlinkSettings((HyperlinkSettings)toolkit.getHyperlinkGroup());
        this.descriptionText.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                toolkit.dispose();
            }
        });
        this.descriptionText.setEnabled(false);
    }

    private void createTemplatesList(Composite composite) {
        GridData data = null;
        this.disable = new Button(composite, 32);
        this.disable.setText("Create MIDlet using a template.");
        this.disable.setSelection(false);
        this.disable.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                boolean enabled = MidletTemplateListWizardPage.this.disable.getSelection();
                MidletTemplateListWizardPage.this.viewer.getControl().setEnabled(enabled);
                MidletTemplateListWizardPage.this.viewer.setSelection(null);
                MidletTemplateListWizardPage.this.descriptionText.setText("");
                MidletTemplateListWizardPage.this.descriptionText.setEnabled(enabled);
                MidletTemplateListWizardPage.this.getWizard().getContainer().updateButtons();
            }
        });
        Label label = new Label(composite, 0);
        label.setText(MTJUIMessages.MidletTemplateWizardPage1_AvailableTemplates);
        data = new GridData(768);
        label.setLayoutData((Object)data);
        ScrolledComposite listScroll = new ScrolledComposite(composite, 2560);
        listScroll.setExpandHorizontal(true);
        listScroll.setExpandVertical(true);
        data = new GridData(768);
        data.heightHint = 100;
        listScroll.setLayoutData((Object)data);
        listScroll.setLayout((Layout)new GridLayout(1, false));
        Table table = new Table((Composite)listScroll, 4);
        data = new GridData(768);
        table.setLayoutData((Object)data);
        listScroll.setContent((Control)table);
        this.viewer = new TableViewer(table);
        this.viewer.setLabelProvider((IBaseLabelProvider)new ITableLabelProvider(){

            public void addListener(ILabelProviderListener listener) {
            }

            public void dispose() {
            }

            public Image getColumnImage(Object element, int columnIndex) {
                return MTJUIPluginImages.DESC_TEMPLATE_OBJ.createImage();
            }

            public String getColumnText(Object element, int columnIndex) {
                if (element instanceof MIDletTemplateObject) {
                    return ((MIDletTemplateObject)element).getName();
                }
                return null;
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void removeListener(ILabelProviderListener listener) {
            }
        });
        this.viewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                Collection<MIDletTemplateObject> templates = null;
                MIDletTemplateRegistry registry = null;
                if (!(inputElement instanceof MIDletTemplateRegistry)) {
                    return new Object[0];
                }
                registry = (MIDletTemplateRegistry)inputElement;
                templates = registry.getTemplates();
                return templates.toArray(new MIDletTemplateObject[templates.size()]);
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.viewer.setInput((Object)MIDletTemplateRegistry.getInstance());
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                MidletTemplateListWizardPage.this.template = MidletTemplateListWizardPage.this.getCurrentTemplate(MidletTemplateListWizardPage.this.viewer);
                if (MidletTemplateListWizardPage.this.template == null) {
                    return;
                }
                MidletTemplateListWizardPage.this.updateDetails(MidletTemplateListWizardPage.this.template);
                final IWizardPage page = MidletTemplateListWizardPage.this.getWizard().getPage("TemplateCustomPage");
                Display.getCurrent().asyncExec(new Runnable(){

                    public void run() {
                        try {
                            TemplateWizardPageDelegate page2 = (TemplateWizardPageDelegate)page;
                            page2.setTitle((this).MidletTemplateListWizardPage.this.template.getName());
                            page2.setDescription((this).MidletTemplateListWizardPage.this.template.getOverview());
                            page2.setPage((this).MidletTemplateListWizardPage.this.template.getPage());
                            page2.getWizard().getContainer().updateButtons();
                        }
                        catch (CoreException e) {
                            MessageDialog.openError((Shell)MidletTemplateListWizardPage.this.getShell(), (String)MTJUIMessages.MidletTemplateWizardPage1_UnableToBuildUi, (String)e.getMessage());
                        }
                    }
                });
            }
        });
        this.viewer.getControl().setEnabled(false);
    }

    public MIDletTemplateObject getSelectedTemplate() {
        return this.getCurrentTemplate(this.viewer);
    }

    private MIDletTemplateObject getCurrentTemplate(TableViewer viewer) {
        IStructuredSelection structuredSelection = null;
        ISelection selection = viewer.getSelection();
        if (selection.isEmpty() || !(selection instanceof IStructuredSelection)) {
            return null;
        }
        structuredSelection = (IStructuredSelection)selection;
        return (MIDletTemplateObject)structuredSelection.getFirstElement();
    }

    private void updateDetails(MIDletTemplateObject template) {
        if (template == null) {
            return;
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append("<p>");
        buffer.append(template.getDescription());
        buffer.append("</p>");
        String[] permisions = template.getPermissions();
        buffer.append("<p indent='10'><b>");
        buffer.append(MTJUIMessages.MidletTemplateWizardPage1_PermissionsLabel);
        buffer.append("</b></p>");
        if (permisions == null || permisions.length < 1) {
            buffer.append("<li bindent='10'>");
            buffer.append(MTJUIMessages.MidletTemplateWizardPage1_PermissionsNone);
            buffer.append("</li>");
        } else {
            String[] stringArray = permisions;
            int n = permisions.length;
            int n2 = 0;
            while (n2 < n) {
                String permission = stringArray[n2];
                buffer.append("<li bindent='10'>");
                buffer.append(permission);
                buffer.append("</li>");
                ++n2;
            }
        }
        this.descriptionText.setText(buffer.toString());
    }

    public boolean isPageComplete() {
        boolean result = false;
        result = this.disable.getSelection() ? !this.viewer.getSelection().isEmpty() : true;
        return result;
    }
}

