/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.toolkit.sdkprovidertestclamp;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Properties;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.mtj.core.MTJCore;
import org.eclipse.mtj.core.launching.LaunchEnvironment;
import org.eclipse.mtj.core.persistence.IPersistenceProvider;
import org.eclipse.mtj.core.persistence.PersistenceException;
import org.eclipse.mtj.core.sdk.ISDK;
import org.eclipse.mtj.core.sdk.device.IDevice;
import org.eclipse.mtj.core.sdk.device.IDeviceClasspath;
import org.eclipse.mtj.core.sdk.device.ILibrary;
import org.eclipse.mtj.core.sdk.device.IManagedDevice;
import org.eclipse.mtj.core.sdk.device.midp.IMIDPLibrary;
import org.eclipse.mtj.core.sdk.device.midp.MIDPAPIType;
import org.eclipse.mtj.core.symbol.ISymbolSet;
import org.eclipse.mtj.internal.core.sdk.device.AbstractMIDPDevice;
import org.eclipse.mtj.internal.core.sdk.device.DeviceClasspath;
import org.eclipse.mtj.internal.core.sdk.device.midp.MIDPAPI;
import org.eclipse.mtj.internal.core.sdk.device.midp.MIDPLibrary;
import org.eclipse.mtj.toolkit.sdkprovidertestclamp.Plugin;
import org.eclipse.mtj.toolkit.sdkprovidertestclamp.Sdk;
import org.osgi.framework.Version;

public class Device
extends AbstractMIDPDevice
implements IManagedDevice,
Cloneable {
    private String identifier;
    private boolean isDuplicate;

    public Device() {
    }

    public Device(Sdk sdk, String deviceKey) {
        Properties p = Plugin.getDefault().getProperties();
        this.identifier = p.getProperty(String.valueOf(deviceKey) + ".id");
        this.setName(p.getProperty(String.valueOf(deviceKey) + ".name"));
        this.setDescription(p.getProperty(String.valueOf(deviceKey) + ".description"));
        this.setGroupName(sdk.getName());
        this.setClasspath(this.buildClasspath());
        this.setExecutable(new File("c:\\windows\\notepad.exe"));
        this.setBundle(Plugin.getDefault().getBundle().getSymbolicName());
        this.setPreverifier(null);
        this.setDeviceProperties(this.buildDeviceSymbols());
        this.setProtectionDomains(new String[0]);
        this.setDebugServer(false);
        ISymbolSet dss = MTJCore.getSymbolSetFactory().createSymbolSetFromDevice((IDevice)this);
        ISymbolSet pss = MTJCore.getSymbolSetFactory().createSymbolSetFromProperties(this.buildDeviceSymbols());
        dss.add(pss.getSymbols());
        dss.setName(this.getName());
        this.setSymbolSet(dss);
        this.setSDK((ISDK)sdk);
        this.setLaunchCommandTemplate("Fake launch command template");
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public File getWorkingDirectory() {
        return null;
    }

    private IDeviceClasspath buildClasspath() {
        ArrayList<MIDPLibrary> libraries = new ArrayList<MIDPLibrary>();
        libraries.add(this.buildLibrary1());
        libraries.add(this.buildLibrary2());
        DeviceClasspath classpath = new DeviceClasspath();
        for (IMIDPLibrary iMIDPLibrary : libraries) {
            classpath.addEntry((ILibrary)iMIDPLibrary);
        }
        return classpath;
    }

    private MIDPLibrary buildLibrary1() {
        Properties p = Plugin.getDefault().getProperties();
        String cldc11Loc = p.getProperty("library.cldc11");
        File javadocsDirectory = new File("c:\\");
        File libFile = new File(cldc11Loc);
        ArrayList<MIDPAPI> apis = new ArrayList<MIDPAPI>();
        MIDPAPI api = new MIDPAPI();
        api.setIdentifier("CLDC");
        api.setName("Connected Limited Device Configuration");
        api.setType(MIDPAPIType.CONFIGURATION);
        api.setVersion(new Version("1.1"));
        apis.add(api);
        URL javadocUrl = null;
        try {
            javadocUrl = javadocsDirectory.toURL();
        }
        catch (MalformedURLException malformedURLException) {}
        return new MIDPLibrary(apis, javadocUrl, libFile, null, null, new ArrayList(0));
    }

    private MIDPLibrary buildLibrary2() {
        Properties p = Plugin.getDefault().getProperties();
        String midp20Loc = p.getProperty("library.midp20");
        File javadocsDirectory = new File("c:\\");
        File libFile = new File(midp20Loc);
        ArrayList<MIDPAPI> apis = new ArrayList<MIDPAPI>();
        MIDPAPI api = new MIDPAPI();
        api.setIdentifier("MIDP");
        api.setName("Mobile Information Device Profile");
        api.setType(MIDPAPIType.PROFILE);
        api.setVersion(new Version("2.0"));
        apis.add(api);
        URL javadocUrl = null;
        try {
            javadocUrl = javadocsDirectory.toURL();
        }
        catch (MalformedURLException malformedURLException) {}
        return new MIDPLibrary(apis, javadocUrl, libFile, null, null, new ArrayList(0));
    }

    private Properties buildDeviceSymbols() {
        Properties symbols = new Properties();
        symbols.put("aFakeSymbolSet", "true");
        symbols.put("aFakeVendor", "MTJ Corporation");
        symbols.put("screen.isColor", "true");
        symbols.put("hasTouchScreen", "false");
        return symbols;
    }

    public String getLaunchCommand(LaunchEnvironment launchEnvironment, IProgressMonitor monitor) throws CoreException {
        return "";
    }

    public boolean isDuplicate() {
        return this.isDuplicate;
    }

    public void setAsDuplicate() {
        this.isDuplicate = true;
    }

    protected Object clone() throws CloneNotSupportedException {
        Device clone = (Device)super.clone();
        clone.identifier = this.identifier;
        clone.isDuplicate = true;
        return clone;
    }

    public void loadUsing(IPersistenceProvider persistenceProvider) throws PersistenceException {
        super.loadUsing(persistenceProvider);
        this.identifier = persistenceProvider.loadString("identifier");
        this.isDuplicate = persistenceProvider.loadBoolean("isDuplicate");
    }

    public void storeUsing(IPersistenceProvider persistenceProvider) throws PersistenceException {
        super.storeUsing(persistenceProvider);
        persistenceProvider.storeString("identifier", this.identifier);
        persistenceProvider.storeBoolean("isDuplicate", this.isDuplicate);
    }
}

