/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.toolkit.sdkprovidertestclamp;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.mtj.core.sdk.ISDKProvider;
import org.eclipse.mtj.core.sdk.ManagedSDK;
import org.eclipse.mtj.core.sdk.device.IDevice;
import org.eclipse.mtj.core.sdk.device.IManagedDevice;
import org.eclipse.mtj.toolkit.sdkprovidertestclamp.Device;
import org.eclipse.mtj.toolkit.sdkprovidertestclamp.Plugin;
import org.osgi.framework.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Sdk
extends ManagedSDK {
    private ISDKProvider provider;
    private String name;
    private String description;
    private String identifier;
    private Version version;
    private ArrayList<IManagedDevice> myDevices;

    public Sdk(ISDKProvider sdkProvider, String propertyKey) {
        Properties p = Plugin.getDefault().getProperties();
        this.provider = sdkProvider;
        this.name = p.getProperty(String.valueOf(propertyKey) + ".name");
        this.description = p.getProperty(String.valueOf(propertyKey) + ".description");
        this.identifier = p.getProperty(String.valueOf(propertyKey) + ".id");
        this.version = new Version(p.getProperty(String.valueOf(propertyKey) + ".version"));
        String[] deviceKeys = p.getProperty(String.valueOf(propertyKey) + ".devices").split(",");
        this.myDevices = new ArrayList(deviceKeys.length);
        String[] stringArray = deviceKeys;
        int n = deviceKeys.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            Device device = new Device(this, "device." + key);
            this.myDevices.add(device);
            ++n2;
        }
    }

    protected List<IManagedDevice> getProvidedDeviceList() throws CoreException {
        return this.myDevices;
    }

    public ISDKProvider getSDKProvider() {
        return this.provider;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public Version getVersion() {
        return this.version;
    }

    public void deleteDuplicateDevice(IManagedDevice device) {
        if (device.isDuplicate()) {
            this.myDevices.remove(device);
        }
    }

    public IDevice duplicateDevice(IManagedDevice device, String newName) {
        Device duplicate = null;
        if (device instanceof Device) {
            try {
                duplicate = (Device)((Device)device).clone();
            }
            catch (CloneNotSupportedException e) {
                e.printStackTrace();
                return null;
            }
        }
        duplicate.setAsDuplicate();
        duplicate.setName(newName);
        this.myDevices.add(duplicate);
        return duplicate;
    }
}

