/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.examples.toolkits.me4se;

import java.io.File;
import java.io.FilenameFilter;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.mtj.core.MTJCore;
import org.eclipse.mtj.core.sdk.device.IDevice;
import org.eclipse.mtj.core.sdk.device.IDeviceClasspath;
import org.eclipse.mtj.core.sdk.device.IDeviceImporter;
import org.eclipse.mtj.core.sdk.device.ILibrary;
import org.eclipse.mtj.core.sdk.device.ILibraryImporter;
import org.eclipse.mtj.core.sdk.device.midp.IMIDPAPI;
import org.eclipse.mtj.core.sdk.device.midp.IMIDPDevice;
import org.eclipse.mtj.core.sdk.device.midp.IMIDPLibrary;
import org.eclipse.mtj.core.sdk.device.midp.MIDPAPIType;
import org.eclipse.mtj.core.symbol.ISymbolSet;
import org.eclipse.mtj.examples.toolkits.Activator;
import org.eclipse.mtj.examples.toolkits.me4se.ME4SEDevice;
import org.eclipse.mtj.examples.toolkits.me4se.Messages;
import org.eclipse.mtj.internal.core.sdk.device.JavaEmulatorDeviceImporter;
import org.eclipse.mtj.internal.core.sdk.device.JavaEmulatorDeviceProperties;
import org.eclipse.mtj.internal.core.util.ReplaceableParametersProcessor;
import org.eclipse.mtj.internal.core.util.log.MTJLogger;
import org.osgi.framework.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ME4SEDeviceImporter
extends JavaEmulatorDeviceImporter {
    private static final String EMULATOR_JAR_PREFIX = "me4se";
    private static final String EMULATOR_JAR_SUFFIX = ".jar";
    private static final String PROPS_FILE = "me4se.properties";

    public List<IDevice> importDevices(File directory, Map<Class<? extends IDeviceImporter>, Map<File, Object>> importersCollectedData, IProgressMonitor monitor) {
        ArrayList<IMIDPDevice> devices = null;
        try {
            IMIDPDevice device;
            File[] files = directory.listFiles(new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    return name.startsWith(ME4SEDeviceImporter.EMULATOR_JAR_PREFIX) && name.endsWith(ME4SEDeviceImporter.EMULATOR_JAR_SUFFIX);
                }
            });
            if (files != null && files.length > 0 && (device = this.createDevice(files[0])) != null) {
                devices = new ArrayList<IMIDPDevice>(1);
                devices.add(device);
            }
        }
        catch (Exception e) {
            MTJLogger.log((int)2, (String)Messages.ME4SEDeviceImporter_importing_error, (Throwable)e);
        }
        return devices;
    }

    private void addDeviceLibraries(File jarFile, IDeviceClasspath classpath, ILibraryImporter importer) {
        String[] entries;
        String classpathString = this.getDeviceProperties().getProperty(JavaEmulatorDeviceProperties.CLASSPATH.toString(), "");
        HashMap<String, String> replaceableParameters = new HashMap<String, String>();
        replaceableParameters.put("me4sejar", jarFile.toString());
        classpathString = ReplaceableParametersProcessor.processReplaceableValues((String)classpathString, replaceableParameters);
        String[] stringArray = entries = classpathString.split(";");
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            String entrie = stringArray[n2];
            IMIDPLibrary library = (IMIDPLibrary)importer.createLibraryFor(new File(entrie));
            IMIDPAPI api = library.getAPI(MIDPAPIType.CONFIGURATION);
            if (api != null) {
                api.setVersion(new Version("1.1"));
            }
            if ((api = library.getAPI(MIDPAPIType.PROFILE)) != null) {
                api.setVersion(new Version("2.0"));
            }
            classpath.addEntry((ILibrary)library);
            ++n2;
        }
    }

    private IMIDPDevice createDevice(File jarFile) {
        ME4SEDevice device = new ME4SEDevice();
        device.setBundle(Activator.getDefault().getBundle().getSymbolicName());
        device.setClasspath(this.getDeviceClasspath(jarFile));
        device.setDebugServer(this.isDebugServer());
        device.setDescription("ME4SE Device");
        device.setDeviceProperties(new Properties());
        device.setGroupName("ME4SE");
        device.setName("ME4SE");
        device.setPreverifier(this.getPreverifier(jarFile));
        device.setProtectionDomains(new String[0]);
        device.setLaunchCommandTemplate(this.getLaunchCommand());
        device.setJarFile(jarFile);
        ISymbolSet dss = MTJCore.getSymbolSetFactory().createSymbolSetFromDevice((IDevice)device);
        ISymbolSet pss = MTJCore.getSymbolSetFactory().createSymbolSetFromProperties(this.deviceProperties);
        dss.add(pss.getSymbols());
        dss.setName(device.getName());
        device.setSymbolSet(dss);
        return device;
    }

    private IDeviceClasspath getDeviceClasspath(File jarFile) {
        IDeviceClasspath classpath = MTJCore.createNewDeviceClasspath();
        this.addDeviceLibraries(jarFile, classpath, MTJCore.getLibraryImporter((String)"org.eclipse.mtj.libraryimporter.uei"));
        return classpath;
    }

    protected URL getDevicePropertiesURL() {
        return Activator.getDefault().getBundle().getEntry(PROPS_FILE);
    }
}

