/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.examples.toolkits.motorola;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.mtj.core.MTJCore;
import org.eclipse.mtj.core.build.preverifier.IPreverifier;
import org.eclipse.mtj.core.sdk.device.IDevice;
import org.eclipse.mtj.core.sdk.device.IDeviceClasspath;
import org.eclipse.mtj.core.sdk.device.IDeviceImporter;
import org.eclipse.mtj.core.sdk.device.ILibrary;
import org.eclipse.mtj.core.sdk.device.ILibraryImporter;
import org.eclipse.mtj.core.sdk.device.midp.IMIDPLibrary;
import org.eclipse.mtj.core.symbol.ISymbolSet;
import org.eclipse.mtj.examples.toolkits.Activator;
import org.eclipse.mtj.examples.toolkits.motorola.MotorolaDevice;
import org.eclipse.mtj.internal.core.util.log.MTJLogger;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MotorolaDeviceImporter
implements IDeviceImporter {
    private static final String DEBUG_SERVER_SUFFIX = "_debug.server";
    private static final String DEVICES_SUFFIX = "_devices";
    private static final String EXECUTABLE_SUFFIX = "_executable";
    private static final String LAUNCH_COMMAND_SUFFIX = "_launch.command";
    private static final String PROPS_EMULATORS_LIST = "emulators.list";
    private static final String PROPS_FILE = "moto_emulators.properties";
    private Map<String, EmulatorData> emulatorDataMap;

    public List<IDevice> importDevices(File directory, IProgressMonitor monitor) throws CoreException, InterruptedException {
        return this.importDevices(directory, null, monitor);
    }

    public List<IDevice> importDevices(File directory, Map<Class<? extends IDeviceImporter>, Map<File, Object>> importersCollectedData, IProgressMonitor monitor) {
        List<IDevice> devices = null;
        File resourcesDirectory = new File(directory, "resources");
        if (resourcesDirectory.exists()) {
            devices = this.getResourcesDevices(resourcesDirectory, monitor);
        }
        return devices;
    }

    private IDevice createDevice(File propsFile, Properties deviceProperties, String devicename) {
        IDevice device = null;
        EmulatorData emulatorData = this.getEmulatorData(devicename);
        if (emulatorData != null) {
            device = this.createDevice(propsFile, deviceProperties, devicename, emulatorData);
        }
        return device;
    }

    private IDevice createDevice(File propsFile, Properties deviceProperties, String devicename, EmulatorData emulatorData) {
        File emulatorBinDirectory = propsFile.getParentFile().getParentFile();
        File emulatorDirectory = emulatorBinDirectory.getParentFile();
        File sdkDirectory = emulatorDirectory.getParentFile();
        MotorolaDevice device = new MotorolaDevice();
        try {
            device.setBundle(Activator.getDefault().getBundle().getSymbolicName());
            device.setClasspath(this.getClasspath(emulatorDirectory));
            device.setDebugServer(emulatorData.debugServer);
            device.setDescription(devicename);
            device.setDeviceProperties(deviceProperties);
            device.setExecutable(new File(emulatorBinDirectory, emulatorData.executable));
            device.setGroupName(sdkDirectory.getName());
            device.setName(devicename);
            device.setPreverifier(this.getPreverifier(emulatorBinDirectory, sdkDirectory));
            device.setPropertiesFile(propsFile);
            device.setProtectionDomains(new String[0]);
            device.setLaunchCommandTemplate(emulatorData.launchCommandTemplate);
            ISymbolSet dss = MTJCore.getSymbolSetFactory().createSymbolSetFromDevice((IDevice)device);
            ISymbolSet pss = MTJCore.getSymbolSetFactory().createSymbolSetFromProperties(deviceProperties);
            dss.add(pss.getSymbols());
            dss.setName(device.getName());
            device.setSymbolSet(dss);
        }
        catch (CoreException e) {
            MTJLogger.log((int)2, (String)("Error importing device " + devicename), (Throwable)e);
            device = null;
        }
        return device;
    }

    private File findPreverifyExecutable(File directory) {
        File[] files = directory.listFiles(new FileFilter(){

            public boolean accept(File pathname) {
                String name = pathname.getName();
                return pathname.isDirectory() || name.equals("preverify.exe") || name.equals("preverify");
            }
        });
        File executable = null;
        int i = 0;
        while (i < files.length) {
            if (!files[i].isDirectory()) {
                executable = files[i];
                break;
            }
            executable = this.findPreverifyExecutable(files[i]);
            ++i;
        }
        return executable;
    }

    private IDeviceClasspath getClasspath(File emulatorDirectory) {
        IDeviceClasspath classpath = MTJCore.createNewDeviceClasspath();
        File libDirectory = new File(emulatorDirectory, "lib");
        File[] libraries = libDirectory.listFiles(new FileFilter(){

            public boolean accept(File pathname) {
                String name = pathname.getName();
                return pathname.isFile() && (name.endsWith(".zip") || name.endsWith(".jar"));
            }
        });
        ILibraryImporter libImporter = MTJCore.getLibraryImporter((String)"org.eclipse.mtj.libraryimporter.uei");
        int i = 0;
        while (i < libraries.length) {
            IMIDPLibrary library = (IMIDPLibrary)libImporter.createLibraryFor(libraries[i]);
            classpath.addEntry((ILibrary)library);
            ++i;
        }
        return classpath;
    }

    private EmulatorData getEmulatorData(String deviceName) {
        return this.getEmulatorDataMap().get(deviceName);
    }

    private Map<String, EmulatorData> getEmulatorDataMap() {
        if (this.emulatorDataMap == null) {
            this.emulatorDataMap = this.readEmulatorDataMap();
        }
        return this.emulatorDataMap;
    }

    private IPreverifier getPreverifier(File emulatorBinDirectory, File sdkDirectory) throws CoreException {
        File preverifyExecutable = this.findPreverifyExecutable(emulatorBinDirectory);
        if (preverifyExecutable == null) {
            preverifyExecutable = this.findPreverifyExecutable(sdkDirectory);
        }
        return MTJCore.createPreverifier((String)"org.eclipse.mtj.preverifier.standard", (Object)preverifyExecutable);
    }

    private Properties getProperties(File propsFile) {
        Properties properties;
        block14: {
            properties = new Properties();
            FileInputStream is = null;
            try {
                try {
                    is = new FileInputStream(propsFile);
                    properties.load(is);
                }
                catch (IOException e) {
                    MTJLogger.log((int)2, (String)("Error reading properties file " + propsFile), (Throwable)e);
                    if (is != null) {
                        try {
                            ((InputStream)is).close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block14;
                }
            }
            catch (Throwable throwable) {
                if (is != null) {
                    try {
                        ((InputStream)is).close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (is != null) {
                try {
                    ((InputStream)is).close();
                }
                catch (IOException iOException) {}
            }
        }
        return properties;
    }

    private List<IDevice> getResourcesDevices(File resourcesDirectory, IProgressMonitor monitor) {
        File[] propsFiles = resourcesDirectory.listFiles(new FileFilter(){

            public boolean accept(File pathname) {
                return pathname.isFile() && pathname.getName().endsWith(".props");
            }
        });
        ArrayList<IDevice> devices = new ArrayList<IDevice>();
        int i = 0;
        while (i < propsFiles.length) {
            IDevice device;
            File propsFile = propsFiles[i];
            Properties deviceProperties = this.getProperties(propsFile);
            String devicename = deviceProperties.getProperty("devicename");
            if (devicename != null && (device = this.createDevice(propsFile, deviceProperties, devicename)) != null) {
                devices.add(device);
            }
            ++i;
        }
        return devices;
    }

    private void parseEmulatorDataProperties(Map<String, EmulatorData> emulatorMap, Properties emulatorsProperties, String emulator) {
        String devicesString = emulatorsProperties.getProperty(String.valueOf(emulator) + DEVICES_SUFFIX, "");
        String debugServerString = emulatorsProperties.getProperty(String.valueOf(emulator) + DEBUG_SERVER_SUFFIX, "");
        EmulatorData data = new EmulatorData();
        data.executable = emulatorsProperties.getProperty(String.valueOf(emulator) + EXECUTABLE_SUFFIX, "");
        data.launchCommandTemplate = emulatorsProperties.getProperty(String.valueOf(emulator) + LAUNCH_COMMAND_SUFFIX, "");
        data.devices = devicesString.length() > 0 ? devicesString.split(",") : new String[0];
        data.debugServer = debugServerString.equalsIgnoreCase("true");
        int i = 0;
        while (i < data.devices.length) {
            String device = data.devices[i];
            emulatorMap.put(device, data);
            ++i;
        }
    }

    private Map<String, EmulatorData> parseEmulatorDataProperties(Properties emulatorsProperties) {
        HashMap<String, EmulatorData> emulatorDataMap = new HashMap<String, EmulatorData>();
        String emulatorsList = emulatorsProperties.getProperty(PROPS_EMULATORS_LIST, "");
        String[] emulators = emulatorsList.split(",");
        int i = 0;
        while (i < emulators.length) {
            this.parseEmulatorDataProperties(emulatorDataMap, emulatorsProperties, emulators[i]);
            ++i;
        }
        return emulatorDataMap;
    }

    private Map<String, EmulatorData> readEmulatorDataMap() {
        Properties emulatorsProperties;
        block15: {
            emulatorsProperties = new Properties();
            InputStream emulatorsStream = null;
            try {
                try {
                    Bundle bundle = Activator.getDefault().getBundle();
                    URL propsFileURL = bundle.getEntry(PROPS_FILE);
                    emulatorsStream = propsFileURL.openStream();
                    if (emulatorsStream != null) {
                        emulatorsProperties.load(emulatorsStream);
                    }
                }
                catch (IOException e) {
                    MTJLogger.log((int)4, (String)"Error loading Motorola emulator properties", (Throwable)e);
                    if (emulatorsStream != null) {
                        try {
                            emulatorsStream.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block15;
                }
            }
            catch (Throwable throwable) {
                if (emulatorsStream != null) {
                    try {
                        emulatorsStream.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (emulatorsStream != null) {
                try {
                    emulatorsStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return this.parseEmulatorDataProperties(emulatorsProperties);
    }

    private class EmulatorData {
        public boolean debugServer;
        public String[] devices;
        public String executable;
        public String launchCommandTemplate;

        private EmulatorData() {
        }
    }
}

