/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.build;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.mtj.core.MTJCore;
import org.eclipse.mtj.core.build.CodeValidator;
import org.eclipse.mtj.core.project.midp.IMidletSuiteProject;
import org.eclipse.mtj.internal.core.project.midp.MidletSuiteFactory;
import org.eclipse.mtj.internal.core.util.log.MTJLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CodeValidationBuilder
extends IncrementalProjectBuilder {
    private static final String EXT_ID = String.valueOf(MTJCore.getMTJCore().getBundle().getSymbolicName()) + ".codevalidator";
    private static final String EXT_CLASS_ATTRIBUTE = "class";
    private static Map<IProject, List<IClasspathEntry>> lastSourceClassPath = new HashMap<IProject, List<IClasspathEntry>>();

    public static List<CodeValidator> getCodeValidators(IJavaProject javaProject) {
        ArrayList<CodeValidator> result = new ArrayList<CodeValidator>();
        IConfigurationElement[] configurationElements = Platform.getExtensionRegistry().getConfigurationElementsFor(EXT_ID);
        if (configurationElements != null) {
            IMidletSuiteProject midletSuiteProject = javaProject == null ? null : MidletSuiteFactory.getMidletSuiteProject(javaProject);
            IConfigurationElement[] iConfigurationElementArray = configurationElements;
            int n = configurationElements.length;
            int n2 = 0;
            while (n2 < n) {
                CodeValidator codeValidator;
                IConfigurationElement element = iConfigurationElementArray[n2];
                try {
                    codeValidator = (CodeValidator)((Object)element.createExecutableExtension(EXT_CLASS_ATTRIBUTE));
                }
                catch (Throwable t) {
                    MTJLogger.log(4, t);
                    codeValidator = null;
                }
                if (codeValidator != null && (midletSuiteProject == null || codeValidator.supportsValidationFor(midletSuiteProject))) {
                    result.add(codeValidator);
                }
                ++n2;
            }
        }
        return result;
    }

    protected IProject[] build(int kind, Map<String, String> args, IProgressMonitor monitor) throws CoreException {
        IProject project = this.getProject();
        List<IClasspathEntry> oldSourceCP = lastSourceClassPath.get(project);
        ArrayList<IClasspathEntry> newSourceCP = new ArrayList<IClasspathEntry>();
        IJavaProject javaProject = JavaCore.create((IProject)project);
        IClasspathEntry[] projectCP = javaProject.getResolvedClasspath(true);
        List<CodeValidator> codeValidators = CodeValidationBuilder.getCodeValidators(javaProject);
        if (projectCP != null) {
            IClasspathEntry[] iClasspathEntryArray = projectCP;
            int n = projectCP.length;
            int n2 = 0;
            while (n2 < n) {
                IClasspathEntry cpEntry = iClasspathEntryArray[n2];
                if (cpEntry.getEntryKind() == 3) {
                    newSourceCP.add(cpEntry);
                }
                ++n2;
            }
        }
        lastSourceClassPath.put(project, newSourceCP);
        if (kind == 6) {
            this.fullBuild(codeValidators);
        } else {
            IResourceDelta delta = this.getDelta(project);
            if (delta == null) {
                this.fullBuild(codeValidators);
            } else if (!this.compareClasspath(oldSourceCP, newSourceCP)) {
                this.fullBuild(codeValidators);
            } else {
                this.incrementalBuild(delta, codeValidators);
            }
        }
        return null;
    }

    protected void clean(IProgressMonitor monitor) throws CoreException {
        this.cleanValidationMarkers((IResource)this.getProject());
    }

    private boolean compareClasspath(List<IClasspathEntry> cp1, List<IClasspathEntry> cp2) {
        if (cp1 == null) {
            cp1 = new ArrayList<IClasspathEntry>();
        }
        if (cp2 == null) {
            cp2 = new ArrayList<IClasspathEntry>();
        }
        if (cp1.size() != cp2.size()) {
            return false;
        }
        int i = 0;
        while (i < cp1.size()) {
            if (!cp1.get(i).equals(cp2.get(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private void cleanValidationMarkers(IResource resource) throws CoreException {
        if (resource.exists()) {
            resource.deleteMarkers("org.eclipse.mtj.core.problem.validation", false, 2);
        }
    }

    private void fullBuild(List<CodeValidator> codeValidators) throws CoreException {
        IProject project = this.getProject();
        this.cleanValidationMarkers((IResource)project);
        project.accept((IResourceVisitor)new ResourceVisitor(codeValidators));
    }

    private void incrementalBuild(IResourceDelta delta, List<CodeValidator> codeValidators) throws CoreException {
        delta.accept((IResourceDeltaVisitor)new ResourceDeltaVisitor(codeValidators));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ResourceDeltaVisitor
    extends ResourceVisitor
    implements IResourceDeltaVisitor {
        public ResourceDeltaVisitor(List<CodeValidator> codeValidators) {
            super(codeValidators);
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            IResource resource = delta.getResource();
            boolean result = false;
            switch (delta.getKind()) {
                case 1: 
                case 4: {
                    result = this.visit(resource);
                }
            }
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ResourceVisitor
    implements IResourceVisitor {
        private List<CodeValidator> codeValidators;

        public ResourceVisitor(List<CodeValidator> codeValidators) {
            this.codeValidators = codeValidators;
        }

        public boolean visit(IResource resource) throws CoreException {
            final ICompilationUnit unit = this.toCompilationUnit(resource);
            if (unit != null) {
                CodeValidationBuilder.this.cleanValidationMarkers(resource);
                for (final CodeValidator codeValidator : this.codeValidators) {
                    SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                        public void run() throws Exception {
                            codeValidator.validate(unit);
                        }

                        public void handleException(Throwable t) {
                            MTJLogger.log(4, t);
                        }
                    });
                }
            }
            return true;
        }

        private ICompilationUnit toCompilationUnit(IResource resource) {
            IPackageFragmentRoot root;
            if (resource == null || resource.getType() != 1) {
                return null;
            }
            IJavaElement javaElement = JavaCore.create((IFile)((IFile)resource));
            if (javaElement != null && javaElement.getElementType() == 5 && (root = (IPackageFragmentRoot)javaElement.getAncestor(3)) != null && root.exists()) {
                return (ICompilationUnit)javaElement;
            }
            return null;
        }
    }
}

