/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.build.packaging;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.mtj.core.MTJCore;
import org.eclipse.mtj.internal.core.build.preverifier.builder.BuilderMessages;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JADErrorReporter {
    private IFile descriptorFile;
    protected IDocument textDocument;

    public JADErrorReporter(IFile file) {
        this.descriptorFile = file;
        this.textDocument = this.createDocument(file);
    }

    public void validate(IProgressMonitor monitor) {
        try {
            this.descriptorFile.deleteMarkers("org.eclipse.mtj.core.jad.problem", true, 0);
        }
        catch (CoreException e) {
            MTJCore.getMTJCore().getLog().log((IStatus)new Status(2, MTJCore.getPluginId(), "Error validating JAD", (Throwable)e));
        }
        this.parseJAD(this.textDocument, monitor);
    }

    private void parseJAD(IDocument document, IProgressMonitor monitor) {
        try {
            String header = null;
            HashMap<String, String> headers = new HashMap<String, String>();
            int l = 0;
            while (l < document.getNumberOfLines()) {
                int colon;
                ByteBuffer byteBuf;
                IRegion lineInfo = document.getLineInformation(l);
                String line = document.get(lineInfo.getOffset(), lineInfo.getLength());
                Charset charset = Charset.forName("UTF-8");
                String lineDelimiter = document.getLineDelimiter(l);
                if (lineDelimiter == null) {
                    lineDelimiter = "";
                }
                if ((byteBuf = charset.encode(line)).limit() + lineDelimiter.length() > 512) {
                    this.addMarker(BuilderMessages.JADError_too_long, l + 1, 2);
                }
                if (line.length() == 0) {
                    if (l == 0) {
                        this.addMarker(BuilderMessages.JADError_empty_line, 1, 2);
                        return;
                    }
                    if (header == null) break;
                    headers.put(header.toLowerCase(), header);
                    header = null;
                    break;
                }
                if (header != null) {
                    headers.put(header.toLowerCase(), header);
                    header = null;
                }
                if ((colon = line.indexOf(58)) == -1) {
                    this.addMarker(BuilderMessages.JADError_no_colon, l + 1, 2);
                    return;
                }
                String headerName = this.getHeaderName(line);
                if (headerName == null) {
                    this.addMarker(BuilderMessages.JADError_invalid_attrib, l + 1, 2);
                    return;
                }
                header = headerName;
                if (headers.containsKey(header.toLowerCase())) {
                    this.addMarker(BuilderMessages.JADError_duplicate_attib, l + 1, 1);
                }
                ++l;
            }
            if (!this.attributeExists(headers, "MIDlet-Name") && !this.attributeExists(headers, "LIBlet-Name")) {
                this.addMarker(NLS.bind((String)BuilderMessages.JADError_missing_mandatory, (Object)"MIDlet-Name"), 1, 2);
                return;
            }
            if (this.attributeExists(headers, "MIDlet-Name") && this.attributeExists(headers, "LIBlet-Name")) {
                this.addMarker(NLS.bind((String)BuilderMessages.JADError_not_conform_to_packaging_model, (Object)"LIBlet-Name"), 1, 2);
                return;
            }
            if (!this.attributeExists(headers, "MIDlet-Name") && this.attributeExists(headers, "LIBlet-Name")) {
                if (!this.attributeExists(headers, "LIBlet-Vendor")) {
                    this.addMarker(NLS.bind((String)BuilderMessages.JADError_missing_mandatory, (Object)"LIBlet-Vendor"), 1, 2);
                    return;
                }
                if (!this.attributeExists(headers, "LIBlet-Version")) {
                    this.addMarker(NLS.bind((String)BuilderMessages.JADError_missing_mandatory, (Object)"LIBlet-Version"), 1, 2);
                    return;
                }
                if (!this.attributeExists(headers, "LIBlet-Jar-URL")) {
                    this.addMarker(NLS.bind((String)BuilderMessages.JADError_missing_mandatory, (Object)"LIBlet-Jar-URL"), 1, 2);
                    return;
                }
                if (this.attributeExists(headers, "MIDlet-Vendor")) {
                    this.addMarker(NLS.bind((String)BuilderMessages.JADError_not_conform_to_packaging_model, (Object)"MIDlet-Vendor"), 1, 2);
                    return;
                }
                if (this.attributeExists(headers, "MIDlet-Version")) {
                    this.addMarker(NLS.bind((String)BuilderMessages.JADError_not_conform_to_packaging_model, (Object)"MIDlet-Version"), 1, 2);
                    return;
                }
                if (this.attributeExists(headers, "MIDlet-Jar-URL")) {
                    this.addMarker(NLS.bind((String)BuilderMessages.JADError_not_conform_to_packaging_model, (Object)"MIDlet-Jar-URL"), 1, 2);
                    return;
                }
            } else {
                if (!this.attributeExists(headers, "MIDlet-Vendor")) {
                    this.addMarker(NLS.bind((String)BuilderMessages.JADError_missing_mandatory, (Object)"MIDlet-Vendor"), 1, 2);
                    return;
                }
                if (!this.attributeExists(headers, "MIDlet-Version")) {
                    this.addMarker(NLS.bind((String)BuilderMessages.JADError_missing_mandatory, (Object)"MIDlet-Version"), 1, 2);
                    return;
                }
                if (!this.attributeExists(headers, "MIDlet-Jar-URL")) {
                    this.addMarker(NLS.bind((String)BuilderMessages.JADError_missing_mandatory, (Object)"MIDlet-Jar-URL"), 1, 2);
                    return;
                }
                if (this.attributeExists(headers, "LIBlet-Vendor")) {
                    this.addMarker(NLS.bind((String)BuilderMessages.JADError_not_conform_to_packaging_model, (Object)"LIBlet-Vendor"), 1, 2);
                    return;
                }
                if (this.attributeExists(headers, "LIBlet-Version")) {
                    this.addMarker(NLS.bind((String)BuilderMessages.JADError_not_conform_to_packaging_model, (Object)"LIBlet-Version"), 1, 2);
                    return;
                }
                if (this.attributeExists(headers, "LIBlet-Jar-URL")) {
                    this.addMarker(NLS.bind((String)BuilderMessages.JADError_not_conform_to_packaging_model, (Object)"LIBlet-Jar-URL"), 1, 2);
                    return;
                }
            }
            if (!this.attributeExists(headers, "MicroEdition-Configuration")) {
                this.addMarker(NLS.bind((String)BuilderMessages.JADError_missing_mandatory, (Object)"MicroEdition-Configuration"), 1, 2);
                return;
            }
            if (!this.attributeExists(headers, "MicroEdition-Profile")) {
                this.addMarker(NLS.bind((String)BuilderMessages.JADError_missing_mandatory, (Object)"MicroEdition-Profile"), 1, 2);
                return;
            }
        }
        catch (BadLocationException e) {
            MTJCore.getMTJCore().getLog().log((IStatus)new Status(2, MTJCore.getPluginId(), "Error parsing JAD file", (Throwable)e));
        }
    }

    private boolean attributeExists(Map<String, String> headers, String attribute) {
        return headers.containsKey(attribute.toLowerCase());
    }

    private String getHeaderName(String line) {
        int i = 0;
        while (i < line.length()) {
            char c = line.charAt(i);
            if (c == ':') {
                return line.substring(0, i);
            }
            if (!(c >= 'A' && 'Z' >= c || c >= 'a' && 'z' >= c || c >= '0' && '9' >= c)) {
                if (i == 0) {
                    return null;
                }
                if (c != '-' && c != '_') {
                    return null;
                }
            }
            ++i;
        }
        return null;
    }

    private void addMarker(String message, int lineNumber, int severity) {
        try {
            IMarker marker = this.descriptorFile.createMarker("org.eclipse.mtj.core.jad.problem");
            marker.setAttribute("message", (Object)message);
            marker.setAttribute("severity", severity);
            if (lineNumber == -1) {
                lineNumber = 1;
            }
            marker.setAttribute("lineNumber", lineNumber);
        }
        catch (CoreException e) {
            MTJCore.getMTJCore().getLog().log((IStatus)new Status(2, MTJCore.getPluginId(), "Error creating marker for JAD file", (Throwable)e));
        }
    }

    private IDocument createDocument(IFile file) {
        if (!file.exists()) {
            return null;
        }
        ITextFileBufferManager manager = FileBuffers.getTextFileBufferManager();
        if (manager == null) {
            return null;
        }
        try {
            manager.connect(file.getFullPath(), LocationKind.NORMALIZE, null);
            ITextFileBuffer textBuf = manager.getTextFileBuffer(file.getFullPath(), LocationKind.NORMALIZE);
            IDocument document = textBuf.getDocument();
            manager.disconnect(file.getFullPath(), LocationKind.NORMALIZE, null);
            return document;
        }
        catch (CoreException e) {
            MTJCore.getMTJCore().getLog().log((IStatus)new Status(2, MTJCore.getPluginId(), "Error creating document for JAD file", (Throwable)e));
            return null;
        }
    }
}

