/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.build.packaging;

import de.schlichtherle.io.ArchiveException;
import de.schlichtherle.io.FileOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.IStreamListener;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStreamMonitor;
import org.eclipse.debug.core.model.IStreamsProxy;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.mtj.core.MTJCore;
import org.eclipse.mtj.core.build.MTJBuildState;
import org.eclipse.mtj.core.build.preverifier.IPreverificationError;
import org.eclipse.mtj.core.build.preverifier.PreverifierNotFoundException;
import org.eclipse.mtj.core.project.IMTJProject;
import org.eclipse.mtj.core.project.midp.IApplicationDescriptor;
import org.eclipse.mtj.core.project.midp.IMidletDefinition;
import org.eclipse.mtj.core.project.midp.IMidletSuiteProject;
import org.eclipse.mtj.core.project.runtime.MTJRuntime;
import org.eclipse.mtj.core.project.runtime.MTJRuntimeList;
import org.eclipse.mtj.internal.core.PreferenceAccessor;
import org.eclipse.mtj.internal.core.build.BuildStateMachine;
import org.eclipse.mtj.internal.core.build.MTJIncrementalProjectBuilder;
import org.eclipse.mtj.internal.core.build.packaging.JADErrorReporter;
import org.eclipse.mtj.internal.core.build.packaging.PackageBuilderVisitor;
import org.eclipse.mtj.internal.core.build.packaging.ResourcesCollector;
import org.eclipse.mtj.internal.core.build.preverifier.PreverificationUtils;
import org.eclipse.mtj.internal.core.build.preverifier.builder.BuilderMessages;
import org.eclipse.mtj.internal.core.launching.midp.LaunchingUtils;
import org.eclipse.mtj.internal.core.packaging.midp.DeployedJADWriter;
import org.eclipse.mtj.internal.core.packaging.midp.ObfuscatorTool;
import org.eclipse.mtj.internal.core.project.midp.ApplicationDescriptor;
import org.eclipse.mtj.internal.core.project.midp.LibletProperties;
import org.eclipse.mtj.internal.core.project.midp.MidletSuiteFactory;
import org.eclipse.mtj.internal.core.sdk.device.midp.PackagingModel;
import org.eclipse.mtj.internal.core.util.ColonDelimitedProperties;
import org.eclipse.mtj.internal.core.util.MTJStatusHandler;
import org.eclipse.mtj.internal.core.util.RequiredProjectsCPEntryVisitor;
import org.eclipse.mtj.internal.core.util.Utils;
import org.eclipse.mtj.internal.core.util.log.MTJLogger;
import org.osgi.framework.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PackageBuilder
extends MTJIncrementalProjectBuilder {
    public static final String ARG_DO_OBFUSCATION = "_do_obfuscation";
    public static final String ARG_DO_PACKAGE = "_do_package";
    public static final String ARG_UPDATE_VERSION = "_update_version";
    public static final String ARG_DESTINATION_DIRECTORY = "_destination_dir";

    @Override
    protected IProject[] doBuild(int kind, Map<?, ?> args, IProgressMonitor monitor) throws CoreException {
        IMTJProject mtjProject = this.getMTJProject();
        if (mtjProject instanceof IMidletSuiteProject) {
            IMidletSuiteProject suiteProject = (IMidletSuiteProject)mtjProject;
            this.updatePackage(suiteProject, kind, args, monitor);
        }
        return null;
    }

    @Override
    protected void doClean(int kind, IProgressMonitor monitor) throws CoreException {
        monitor.subTask(BuilderMessages.PackageBuilder_cleaningRuntimeFolder);
        IProject project = this.getProject();
        IFolder folder = this.getRuntimeFolder(project);
        if (folder.exists()) {
            IResource[] children;
            IResource[] iResourceArray = children = folder.members();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                IResource resource = iResourceArray[n2];
                resource.delete(true, monitor);
                ++n2;
            }
            folder.refreshLocal(0, monitor);
        }
    }

    private void removeJADsAndJARs(IFolder folder, IProgressMonitor monitor) throws CoreException {
        IResource[] children;
        IResource[] iResourceArray = children = folder.members();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            String extension;
            IResource resource = iResourceArray[n2];
            if (resource.getType() == 2) {
                this.removeJADsAndJARs((IFolder)resource, monitor);
            } else if (resource.getType() == 1 && (extension = ((IFile)resource).getFileExtension()) != null && (extension.equalsIgnoreCase("jad") || extension.equalsIgnoreCase("jar"))) {
                resource.delete(true, monitor);
            }
            ++n2;
        }
    }

    private void updatePackage(IMidletSuiteProject suiteProject, int kind, Map<?, ?> args, IProgressMonitor monitor) throws CoreException {
        IProject project = suiteProject.getProject();
        IFolder runtime = this.getRuntimeFolder(project);
        if (!runtime.exists()) {
            runtime.create(true, true, monitor);
        }
        try {
            boolean updateVersionForProject;
            boolean bl = updateVersionForProject = PreferenceAccessor.instance.getAutoversionPackage(suiteProject.getProject()) && this.isBuildArgumentTrue(args, ARG_UPDATE_VERSION);
            if (updateVersionForProject) {
                monitor.subTask(BuilderMessages.PackageBuilder_updatingJadVersion);
                IFile jad = suiteProject.getApplicationDescriptorFile();
                this.updateJADVersion(jad, monitor);
            }
        }
        catch (IOException e) {
            MTJStatusHandler.throwCoreException(4, 999, e);
        }
        JADErrorReporter jadErrorReporter = new JADErrorReporter(suiteProject.getApplicationDescriptorFile());
        jadErrorReporter.validate(monitor);
        IFile jarFie = runtime.getFile(suiteProject.getJarFilename());
        de.schlichtherle.io.File zipFile = new de.schlichtherle.io.File(jarFie.getLocation().toOSString());
        monitor.subTask(BuilderMessages.PackageBuilder_collectingSources);
        this.createEmptyManifestFile(zipFile);
        PackageBuilderVisitor visitor = new PackageBuilderVisitor(suiteProject, zipFile);
        IResourceDelta delta = this.getDelta(this.getProject());
        if (delta == null) {
            List<IPath> outputLocations = Utils.getOutputLocations(suiteProject, false);
            IWorkspaceRoot root = MTJCore.getWorkspace().getRoot();
            for (IPath outputLocation : outputLocations) {
                IFolder outputFolder = root.getFolder(outputLocation);
                if (!outputFolder.exists()) continue;
                outputFolder.accept((IResourceVisitor)visitor);
            }
        } else {
            delta.accept((IResourceDeltaVisitor)visitor);
        }
        IFolder emulationFolder = LaunchingUtils.getEmulationFolder(suiteProject);
        IFolder libFolder = emulationFolder.getFolder("lib");
        RequiredProjectsCPEntryVisitor requiredProjectsCPEntryVisitor = new RequiredProjectsCPEntryVisitor();
        requiredProjectsCPEntryVisitor.getRunner().run(suiteProject.getJavaProject(), requiredProjectsCPEntryVisitor, monitor);
        ArrayList<IJavaProject> requiredProjects = requiredProjectsCPEntryVisitor.getRequiredProjects();
        for (IJavaProject requiredProject : requiredProjects) {
            IMidletSuiteProject midletSuite = MidletSuiteFactory.getMidletSuiteProject(requiredProject);
            if (midletSuite.getProjectPackagingModel() != PackagingModel.LIBLET) continue;
            IResource[] iResourceArray = LaunchingUtils.getEmulationFolder(midletSuite).members();
            int n = iResourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResource resource = iResourceArray[n2];
                File file = resource.getRawLocation().makeAbsolute().toFile();
                if (!libFolder.exists()) {
                    libFolder.create(true, true, null);
                }
                if (file.exists() && file.isFile()) {
                    IFile newFile = libFolder.getFile((IPath)new Path(file.getName()));
                    if (newFile.exists()) {
                        newFile.delete(true, null);
                    }
                    try {
                        newFile.create((InputStream)new FileInputStream(file), true, null);
                    }
                    catch (FileNotFoundException fileNotFoundException) {}
                }
                ++n2;
            }
        }
        monitor.subTask(BuilderMessages.PackageBuilder_packagingResources);
        for (IFile resource : visitor.getResourcesToPackage()) {
            this.addFileToJAR(zipFile, resource, PackageBuilder.getResourceZipPath(suiteProject, resource));
        }
        monitor.subTask(BuilderMessages.PackageBuilder_packagingClasses);
        for (IFile clazz : visitor.getClassesToPackage()) {
            this.addFileToJAR(zipFile, clazz, PackageBuilder.getClassZipPath(suiteProject, clazz));
        }
        monitor.subTask(BuilderMessages.PackageBuilder_packagingLibraries);
        this.addPreverifiedLibraries(suiteProject, zipFile, monitor);
        monitor.subTask(BuilderMessages.PackageBuilder_packagingDependencies);
        this.addRequiredProjectsClasses(suiteProject, zipFile, monitor);
        this.addRequiredProjectsLibs(suiteProject, zipFile, monitor);
        this.addRequiredProjectsResources(suiteProject, zipFile, monitor);
        this.createManifestFile(suiteProject, zipFile, monitor);
        try {
            try {
                de.schlichtherle.io.File.umount();
                File jar = new File(zipFile.getAbsolutePath());
                if (this.isBuildArgumentTrue(args, ARG_DO_OBFUSCATION)) {
                    monitor.subTask(BuilderMessages.PackageBuilder_obfuscating);
                    this.doObfuscation(suiteProject, jar, monitor);
                }
                DeployedJADWriter writer = new DeployedJADWriter(suiteProject, runtime.getLocation().toFile(), jar);
                writer.writeDeployedJAD(true, monitor);
                if (this.isBuildArgumentTrue(args, ARG_DO_PACKAGE)) {
                    monitor.subTask(BuilderMessages.PackageBuilder_generatingDeploymentPackage);
                    this.createDeployedPackage(suiteProject, zipFile, args, monitor);
                }
            }
            catch (ArchiveException e) {
                MTJStatusHandler.throwCoreException(4, 999, e);
                runtime.refreshLocal(1, monitor);
            }
            catch (IOException e) {
                MTJStatusHandler.throwCoreException(4, 999, e);
                runtime.refreshLocal(1, monitor);
            }
        }
        finally {
            runtime.refreshLocal(1, monitor);
        }
    }

    private void addRequiredProjectsResources(IMidletSuiteProject suiteProject, de.schlichtherle.io.File zipFile, IProgressMonitor monitor) throws CoreException {
        ArrayList<IFile> resources = new ArrayList<IFile>();
        RequiredProjectsCPEntryVisitor visitor = new RequiredProjectsCPEntryVisitor();
        visitor.getRunner().run(suiteProject.getJavaProject(), visitor, monitor);
        ArrayList<IJavaProject> required = visitor.getRequiredProjects();
        for (IJavaProject javaProject : required) {
            IPath binaryPath;
            IProject project = javaProject.getProject();
            IFolder folder = project.getFolder(binaryPath = javaProject.getOutputLocation().removeFirstSegments(project.getFullPath().segmentCount()));
            if (!folder.exists()) continue;
            ResourcesCollector collector = new ResourcesCollector(javaProject);
            folder.accept((IResourceVisitor)collector);
            resources.addAll(collector.getResources());
        }
        for (IFile resource : resources) {
            this.addRequiredResource(resource, zipFile);
        }
    }

    private void addRequiredResource(IFile resource, de.schlichtherle.io.File zipFile) throws CoreException {
        IPath zipPath;
        IJavaProject javaProject = JavaCore.create((IProject)resource.getProject());
        IPath binaryPath = javaProject.getOutputLocation();
        if (binaryPath.isPrefixOf(resource.getFullPath()) && !(zipPath = resource.getFullPath().removeFirstSegments(binaryPath.segmentCount())).isEmpty()) {
            this.addResourceToJAR(zipFile, (IResource)resource, zipPath);
        }
    }

    private void addRequiredProjectsClasses(IMidletSuiteProject suiteProject, de.schlichtherle.io.File zipFile, IProgressMonitor monitor) throws CoreException {
        IFolder requiredClassesFolder = suiteProject.getVerifiedOutputFolder(monitor).getFolder("required-classes");
        if (requiredClassesFolder.exists()) {
            IResource[] iResourceArray = requiredClassesFolder.members();
            int n = iResourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResource resource = iResourceArray[n2];
                this.addResourceToJAR(zipFile, resource, PackageBuilder.getRequiredClassesZipPath(suiteProject, resource));
                ++n2;
            }
        }
    }

    private void addRequiredProjectsLibs(IMidletSuiteProject suiteProject, de.schlichtherle.io.File zipFile, IProgressMonitor monitor) throws CoreException {
        IFolder requiredLibsFolder = suiteProject.getVerifiedOutputFolder(monitor).getFolder("required-libs");
        if (requiredLibsFolder.exists()) {
            IResource[] iResourceArray = requiredLibsFolder.members();
            int n = iResourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResource resource = iResourceArray[n2];
                if (resource.getName().endsWith(".jar")) {
                    zipFile.archiveCopyAllFrom((File)new de.schlichtherle.io.File(resource.getLocation().toOSString()));
                }
                ++n2;
            }
        }
    }

    private void createDeployedPackage(IMidletSuiteProject suiteProject, de.schlichtherle.io.File jar, Map<?, ?> args, IProgressMonitor monitor) throws CoreException {
        MTJRuntimeList runtime = suiteProject.getRuntimeList();
        MTJRuntime active = runtime.getActiveMTJRuntime();
        if (active == null) {
            return;
        }
        String destinationDirectory = (String)args.get(ARG_DESTINATION_DIRECTORY);
        File rootFolder = null;
        if (destinationDirectory != null) {
            rootFolder = new File(destinationDirectory);
            if ((rootFolder = new de.schlichtherle.io.File(rootFolder, active.getName())).exists() && !rootFolder.isDirectory()) {
                rootFolder.delete();
            }
            if (!rootFolder.exists()) {
                rootFolder.mkdirs();
            }
        } else {
            IFolder target;
            IFolder deployed = this.getProject().getFolder(MTJCore.getDeploymentDirectoryName());
            if (!deployed.exists()) {
                deployed.create(true, true, monitor);
            }
            if (!(target = deployed.getFolder(active.getName())).exists()) {
                target.create(true, true, monitor);
            }
            this.removeJADsAndJARs(target, monitor);
            rootFolder = target.getLocation().toFile();
        }
        try {
            try {
                de.schlichtherle.io.File deployedJar = new de.schlichtherle.io.File(rootFolder, jar.getName());
                jar.archiveCopyAllTo((File)deployedJar);
                de.schlichtherle.io.File.umount();
                DeployedJADWriter writer = new DeployedJADWriter(suiteProject, rootFolder, new File(deployedJar.getAbsolutePath()));
                writer.writeDeployedJAD(false, monitor);
            }
            catch (IOException e) {
                MTJStatusHandler.throwCoreException(4, 999, e);
                if (destinationDirectory == null) {
                    this.getProject().getFolder(MTJCore.getDeploymentDirectoryName()).refreshLocal(2, monitor);
                }
            }
        }
        finally {
            if (destinationDirectory == null) {
                this.getProject().getFolder(MTJCore.getDeploymentDirectoryName()).refreshLocal(2, monitor);
            }
        }
    }

    private boolean isBuildArgumentTrue(Map<?, ?> args, String argument) {
        String value = (String)args.get(argument);
        return value != null && Boolean.valueOf(value) != false;
    }

    private void updateJADVersion(IFile jad, IProgressMonitor monitor) throws CoreException, IOException {
        ApplicationDescriptor appDescriptor = new ApplicationDescriptor(jad.getLocation().toFile());
        ColonDelimitedProperties jadProperties = (ColonDelimitedProperties)appDescriptor.getManifestProperties();
        String versionString = jadProperties.getProperty("MIDlet-Version", "0.0.0");
        Version version = new Version(versionString);
        int major = version.getMajor();
        int minor = version.getMinor();
        int secondary = version.getMicro();
        if (secondary >= 99) {
            secondary = 0;
            ++minor;
        } else {
            ++secondary;
        }
        StringBuffer newVersion = new StringBuffer();
        newVersion.append(major).append(".").append(minor).append(".").append(secondary);
        jadProperties.setProperty("MIDlet-Version", newVersion.toString());
        try {
            try {
                appDescriptor.store();
            }
            catch (IOException e) {
                MTJStatusHandler.throwCoreException(4, 999, e);
                jad.refreshLocal(0, monitor);
            }
        }
        finally {
            jad.refreshLocal(0, monitor);
        }
    }

    private void addPreverifiedLibraries(IMidletSuiteProject suiteProject, de.schlichtherle.io.File zipFile, IProgressMonitor monitor) throws CoreException {
        IResource[] libraries;
        IFolder folder = suiteProject.getVerifiedLibrariesOutputFolder(monitor);
        if (!folder.exists()) {
            return;
        }
        IResource[] iResourceArray = libraries = folder.members();
        int n = libraries.length;
        int n2 = 0;
        while (n2 < n) {
            IResource library = iResourceArray[n2];
            if (library.getName().endsWith(".jar")) {
                zipFile.archiveCopyAllFrom((File)new de.schlichtherle.io.File(library.getLocation().toOSString()));
            }
            ++n2;
        }
    }

    private void createEmptyManifestFile(de.schlichtherle.io.File jar) throws CoreException {
        de.schlichtherle.io.File manifestFile;
        de.schlichtherle.io.File manifestFolder = new de.schlichtherle.io.File((File)jar, "META-INF");
        if (!manifestFolder.exists()) {
            manifestFolder.mkdir();
        }
        if (!(manifestFile = new de.schlichtherle.io.File((File)manifestFolder, "MANIFEST.MF")).exists()) {
            try {
                manifestFile.createNewFile();
            }
            catch (IOException ex) {
                MTJStatusHandler.throwCoreException(4, -999, ex);
            }
        }
    }

    private void createManifestFile(IMidletSuiteProject midletSuite, de.schlichtherle.io.File jar, IProgressMonitor monitor) throws CoreException {
        block24: {
            String[] excluded;
            IProject project = midletSuite.getProject();
            if (!midletSuite.getApplicationDescriptorFile().exists()) {
                return;
            }
            IApplicationDescriptor applicationDescriptor = midletSuite.getApplicationDescriptor();
            Properties manifestProperties = applicationDescriptor.getManifestProperties();
            String[] stringArray = excluded = PreferenceAccessor.instance.getExcludedManifestProperties(project);
            int n = excluded.length;
            int n2 = 0;
            while (n2 < n) {
                String excludedName = stringArray[n2];
                if (manifestProperties.containsKey(excludedName)) {
                    manifestProperties.remove(excludedName);
                }
                ++n2;
            }
            String jarDependencyName = midletSuite.getProjectPackagingModel() == PackagingModel.LIBLET ? "LIBlet-Dependency-" : "MIDlet-Dependency-";
            LibletProperties[] libletProperties = midletSuite.getLibletProperties();
            if (libletProperties != null) {
                int i = 0;
                while (i < libletProperties.length) {
                    manifestProperties.setProperty(String.valueOf(jarDependencyName) + (i + 1), libletProperties[i].getJadPropertyString());
                    ++i;
                }
            }
            Manifest jarManifest = new Manifest();
            Attributes mainAttributes = jarManifest.getMainAttributes();
            mainAttributes.putValue(Attributes.Name.MANIFEST_VERSION.toString(), BuilderMessages.PreverificationBuilder_13);
            for (Map.Entry<Object, Object> entry : manifestProperties.entrySet()) {
                String attributeName = (String)entry.getKey();
                try {
                    mainAttributes.putValue(attributeName, (String)entry.getValue());
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
            for (IMidletDefinition def : applicationDescriptor.getMidletDefinitions()) {
                String key = "MIDlet-" + def.getNumber();
                String value = def.toString();
                mainAttributes.putValue(key, value);
            }
            FileOutputStream fos = null;
            de.schlichtherle.io.File manifestFolder = new de.schlichtherle.io.File((File)jar, "META-INF");
            if (!manifestFolder.exists()) {
                manifestFolder.mkdir();
            }
            try {
                try {
                    fos = new FileOutputStream((File)new de.schlichtherle.io.File((File)manifestFolder, "MANIFEST.MF"));
                    jarManifest.write((OutputStream)fos);
                }
                catch (IOException e) {
                    MTJStatusHandler.throwCoreException(4, -999, e);
                    if (fos != null) {
                        try {
                            fos.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block24;
                }
            }
            catch (Throwable throwable) {
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Override
    protected MTJBuildState getEnterState() {
        return MTJBuildState.PRE_PACKAGING;
    }

    @Override
    protected MTJBuildState getExitState() {
        return MTJBuildState.POST_PACKAGING;
    }

    @Override
    protected String getBuilderId() {
        return "org.eclipse.mtj.core.packageBuilder";
    }

    private void doObfuscation(IMidletSuiteProject suiteProject, File jar, IProgressMonitor monitor) throws CoreException {
        final StringBuffer errorText = new StringBuffer();
        BuildStateMachine stateMachine = BuildStateMachine.getInstance(this.getMTJProject());
        stateMachine.changeState(MTJBuildState.PRE_OBFUSCATION, monitor);
        Path jarPath = new Path(jar.getAbsolutePath());
        String basename = jarPath.lastSegment();
        basename = basename.substring(0, basename.length() - 4);
        IFolder runtimeFolder = this.getRuntimeFolder(suiteProject.getProject());
        IFile obfuscatedJarFile = runtimeFolder.getFile(String.valueOf(basename) + "_obf.jar");
        IFile runtimeJarFile = runtimeFolder.getFile(jarPath.lastSegment());
        ObfuscatorTool obfuscator = new ObfuscatorTool(suiteProject, jar, obfuscatedJarFile.getLocation().toFile());
        ILaunch launch = obfuscator.launch(monitor);
        StringBuffer stdoutBuffer = new StringBuffer();
        IProcess[] processes = launch.getProcesses();
        if (processes != null && processes.length > 0) {
            IProcess process = processes[0];
            IStreamsProxy proxy = process.getStreamsProxy();
            proxy.getErrorStreamMonitor().addListener(new IStreamListener(){

                public void streamAppended(String text, IStreamMonitor monitor) {
                    errorText.append(text);
                }
            });
            while (!monitor.isCanceled() && !process.isTerminated()) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
            if (stdoutBuffer.length() > 0) {
                MTJLogger.log(1, stdoutBuffer.toString());
            }
            boolean doFinalPreverify = true;
            if (errorText.length() > 0) {
                String text = errorText.toString();
                Status status = new Status(4, "org.eclipse.mtj.core", 101, text, null);
                Boolean response = (Boolean)MTJStatusHandler.statusPrompt((IStatus)status, (Object)this);
                boolean bl = doFinalPreverify = response != null ? response : false;
            }
            if (doFinalPreverify) {
                try {
                    this.doPostObfuscationPreverification(suiteProject, obfuscatedJarFile, runtimeJarFile, monitor);
                }
                catch (PreverifierNotFoundException e) {
                    MTJStatusHandler.throwCoreException(4, 999, e);
                }
            }
        }
        stateMachine.changeState(MTJBuildState.POST_OBFUSCATION, monitor);
    }

    private IFolder getRuntimeFolder(IProject project) {
        return project.getFolder(".mtj.tmp").getFolder("emulation");
    }

    private void doPostObfuscationPreverification(IMidletSuiteProject suiteProject, IFile obfuscatedJar, IFile deployedJarFile, IProgressMonitor monitor) throws CoreException, PreverifierNotFoundException {
        try {
            IFolder deployFolder = (IFolder)obfuscatedJar.getParent();
            IFolder tempFolder = deployFolder.getFolder("temp");
            if (!tempFolder.exists()) {
                tempFolder.create(true, true, monitor);
            }
            de.schlichtherle.io.File jarFile = new de.schlichtherle.io.File(obfuscatedJar.getLocation().toFile());
            IPreverificationError[] errors = suiteProject.preverifyJarFile((File)jarFile, tempFolder, monitor);
            tempFolder.refreshLocal(1, monitor);
            if (errors.length > 0) {
                this.handlePreverificationErrors(errors);
            }
            IFile preverified = tempFolder.getFile(obfuscatedJar.getName());
            FileInputStream stream = new FileInputStream(preverified.getLocation().toFile());
            deployedJarFile.create((InputStream)stream, true, monitor);
            preverified.delete(true, monitor);
            tempFolder.delete(true, monitor);
        }
        catch (IOException e) {
            MTJStatusHandler.throwCoreException(4, 999, e);
        }
    }

    private void handlePreverificationErrors(IPreverificationError[] errors) throws CoreException {
        StringBuffer sb = new StringBuffer(BuilderMessages.PreverificationBuilder_45);
        int i = 0;
        while (i < errors.length) {
            if (i != 0) {
                sb.append("\n");
            }
            sb.append(PreverificationUtils.getErrorText(errors[i]));
            ++i;
        }
        MTJStatusHandler.throwCoreException(4, -999, sb.toString());
    }

    private void addResourceToJAR(de.schlichtherle.io.File jar, IResource resource, IPath zipPath) {
        IPath location = resource.getLocation();
        de.schlichtherle.io.File zipFile = new de.schlichtherle.io.File((File)jar, zipPath.toString());
        zipFile.copyAllFrom(location.toFile());
    }

    private void addFileToJAR(de.schlichtherle.io.File jar, IFile file, IPath zipPath) {
        IPath location = file.getLocation();
        de.schlichtherle.io.File zipFile = new de.schlichtherle.io.File((File)jar, zipPath.toString());
        zipFile.copyFrom(location.toFile());
    }

    public static de.schlichtherle.io.File getRuntimeJar(IProject project, IProgressMonitor monitor) throws CoreException {
        IFolder tempFolder = project.getFolder(".mtj.tmp");
        IFolder runtimeFolder = tempFolder.getFolder("emulation");
        PackageBuilder.createFolders(runtimeFolder, monitor);
        IJavaProject javaProject = JavaCore.create((IProject)project);
        IMidletSuiteProject midletSuite = MidletSuiteFactory.getMidletSuiteProject(javaProject);
        de.schlichtherle.io.File runtimeJar = new de.schlichtherle.io.File(runtimeFolder.getLocation().toFile(), midletSuite.getJarFilename());
        runtimeJar.mkdir();
        runtimeFolder.refreshLocal(1, monitor);
        return runtimeJar;
    }

    public static void createFolders(IFolder folder, IProgressMonitor monitor) throws CoreException {
        while (!folder.exists()) {
            if (folder.getParent().getType() == 2) {
                PackageBuilder.createFolders((IFolder)folder.getParent(), monitor);
            }
            folder.create(true, true, monitor);
            folder.setDerived(true, monitor);
        }
    }

    static IPath getResourceZipPath(IMidletSuiteProject suiteProject, IFile file) throws CoreException {
        List<IPath> outputLocations = Utils.getOutputLocations(suiteProject, false);
        return Utils.makePathRelativeToOutputLocation(file.getFullPath(), outputLocations, file.getFullPath().removeFirstSegments(1));
    }

    static IPath getClassZipPath(IMidletSuiteProject suiteProject, IFile file) throws CoreException {
        IFolder verifiedFolder = suiteProject.getVerifiedClassesOutputFolder((IProgressMonitor)new NullProgressMonitor());
        return file.getFullPath().removeFirstSegments(verifiedFolder.getFullPath().segmentCount());
    }

    static IPath getRequiredClassesZipPath(IMidletSuiteProject suiteProject, IResource resource) throws CoreException {
        IFolder verifiedFolder = suiteProject.getVerifiedOutputFolder((IProgressMonitor)new NullProgressMonitor()).getFolder("required-classes");
        return resource.getFullPath().removeFirstSegments(verifiedFolder.getFullPath().segmentCount());
    }
}

