/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.build.preverifier;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.mtj.core.build.preverifier.IPreverificationError;
import org.eclipse.mtj.core.build.preverifier.IPreverifier;
import org.eclipse.mtj.core.persistence.IPersistenceProvider;
import org.eclipse.mtj.core.persistence.PersistenceException;
import org.eclipse.mtj.core.project.IMTJProject;
import org.eclipse.mtj.internal.core.Messages;
import org.eclipse.mtj.internal.core.build.preverifier.IClassErrorInformation;
import org.eclipse.mtj.internal.core.build.preverifier.PreverificationError;
import org.eclipse.mtj.internal.core.build.preverifier.PreverificationErrorLocation;
import org.eclipse.mtj.internal.core.build.preverifier.PreverificationErrorLocationType;
import org.eclipse.mtj.internal.core.build.preverifier.PreverificationErrorType;
import org.eclipse.mtj.internal.core.util.Utils;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.tree.ClassNode;
import org.osgi.framework.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CopyPreverifier
implements IPreverifier {
    private static final String CLASS_EXT = ".class";
    private static final String MIN_SUPPORTED_VERSION_TEXT = "51.0";
    private static final Version MIN_SUPPORTED_VERSION = new Version("51.0");

    @Override
    public void loadUsing(IPersistenceProvider persistenceProvider) throws PersistenceException {
    }

    @Override
    public void storeUsing(IPersistenceProvider persistenceProvider) throws PersistenceException {
    }

    @Override
    public IPreverificationError[] preverify(IMTJProject mtjProject, IResource[] toVerify, IFolder outputFolder, IProgressMonitor monitor) throws CoreException {
        List<IPath> outputLocations = Utils.getOutputLocations(mtjProject, true);
        ArrayList<IPreverificationError> errors = new ArrayList<IPreverificationError>();
        IResource[] iResourceArray = toVerify;
        int n = toVerify.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            try {
                if (this.verifyResource(resource, errors)) {
                    IPath outputRelativePath = Utils.makePathRelativeToOutputLocation(resource.getFullPath(), outputLocations, resource.getFullPath().removeFirstSegments(1));
                    IPath targetPath = outputFolder.getLocation().append(outputRelativePath);
                    targetPath.toFile().getParentFile().mkdirs();
                    File sourceFile = resource.getLocation().toFile();
                    Utils.copy(sourceFile, targetPath.toFile());
                }
            }
            catch (Throwable t) {
                Status status = new Status(4, "org.eclipse.mtj.core", "Failed to copy file " + resource.getFullPath().toOSString() + " to the preverification output folder.", t);
                throw new CoreException((IStatus)status);
            }
            ++n2;
        }
        return errors.toArray(new IPreverificationError[errors.size()]);
    }

    @Override
    public IPreverificationError[] preverifyJarFile(IMTJProject mtjProject, File jarFile, IFolder outputFolder, IProgressMonitor monitor) throws CoreException {
        ArrayList<IPreverificationError> errors = new ArrayList<IPreverificationError>();
        try {
            if (this.verifyJarFile(jarFile, errors)) {
                File sourceJarFile = new File(jarFile.getPath());
                Utils.copy(sourceJarFile, outputFolder.getLocation().append(jarFile.getName()).toFile());
            }
        }
        catch (Throwable t) {
            Status status = new Status(4, "org.eclipse.mtj.core", "Failed to copy jar to the preverification output folder.", t);
            throw new CoreException((IStatus)status);
        }
        return errors.toArray(new IPreverificationError[errors.size()]);
    }

    @Override
    public File getPreverifierExecutable() {
        return null;
    }

    private boolean verifyJarFile(File jarFile, List<IPreverificationError> errors) throws IOException {
        JarFile jar = new JarFile(jarFile.getAbsolutePath());
        boolean result = true;
        try {
            Enumeration<JarEntry> entries = jar.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                if (!entry.getName().toLowerCase().endsWith(CLASS_EXT) || this.verifyClass(jar.getInputStream(entry), errors, true)) continue;
                result = false;
            }
        }
        finally {
            jar.close();
        }
        return result;
    }

    private boolean verifyResource(IResource resource, List<IPreverificationError> errors) throws IOException {
        if (resource.getName().toLowerCase().endsWith(CLASS_EXT)) {
            return this.verifyClass(new FileInputStream(resource.getLocation().toFile()), errors, false);
        }
        return true;
    }

    private boolean verifyClass(InputStream is, List<IPreverificationError> errors, boolean includeClassInMessage) throws IOException {
        if (is != null) {
            try {
                ClassReader reader = new ClassReader((InputStream)new BufferedInputStream(is));
                ClassNode node = new ClassNode();
                reader.accept((ClassVisitor)node, 0);
                String version = String.valueOf(node.version & 0xFFFF) + "." + (node.version >> 16 & 0xFFFF);
                if (new Version(version).compareTo(MIN_SUPPORTED_VERSION) < 0) {
                    String errorMessageTemplate = includeClassInMessage ? Messages.CopyPreverifier_UnsupportedClassFormatJAR : Messages.CopyPreverifier_UnsupportedClassFormat;
                    final String className = node.name.replace('/', '.');
                    String errorMessage = MessageFormat.format(errorMessageTemplate, version, className, MIN_SUPPORTED_VERSION_TEXT);
                    PreverificationErrorLocation errorLocation = new PreverificationErrorLocation(PreverificationErrorLocationType.CLASS_DEFINITION, new IClassErrorInformation(){

                        public String getName() {
                            return className;
                        }

                        public String getSourceFile() {
                            return null;
                        }
                    });
                    errors.add(new PreverificationError(PreverificationErrorType.UNSUPPORTED_CLASS_FILE_FORMAT, errorLocation, errorMessage));
                    return false;
                }
            }
            finally {
                is.close();
            }
        }
        return true;
    }
}

