/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.externallibrary.model.security;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.mtj.internal.core.externallibrary.model.security.Permission;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PermissionList {
    public static final PermissionList EMPTY = new PermissionList();
    private List<Permission> permissionList = new ArrayList<Permission>();

    public PermissionList(String permissions) {
        String permissionsInput = permissions.replace(" ", "");
        StringTokenizer permissionTokenizer = new StringTokenizer(permissionsInput, ",");
        while (permissionTokenizer.hasMoreTokens()) {
            try {
                this.permissionList.add(new Permission((String)permissionTokenizer.nextElement()));
            }
            catch (Exception exception) {}
        }
    }

    private PermissionList() {
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PermissionList)) {
            return false;
        }
        PermissionList other = (PermissionList)obj;
        return !(this.permissionList == null ? other.permissionList != null : !this.permissionList.equals(other.permissionList));
    }

    public List<Permission> getPermissionList() {
        return Collections.unmodifiableList(this.permissionList);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.permissionList == null ? 0 : this.permissionList.hashCode());
        return result;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (!this.permissionList.isEmpty()) {
            Iterator<Permission> iterator = this.permissionList.iterator();
            while (iterator.hasNext()) {
                Permission permission = iterator.next();
                stringBuilder.append(permission.getPermissionID());
                if (!iterator.hasNext()) continue;
                stringBuilder.append(",");
            }
        } else {
            stringBuilder.append("No permissions specified");
        }
        return stringBuilder.toString();
    }
}

