/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.launching.midp.ota;

import java.io.File;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.NCSARequestLog;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.bio.SocketConnector;
import org.eclipse.jetty.util.component.LifeCycle;
import org.eclipse.mtj.core.MTJCore;
import org.eclipse.mtj.internal.core.launching.midp.ota.OTAHandler;

public class OTAServer {
    private static OTAServer instance;
    private Server httpServer;
    private Server server = this.getHttpServer();

    public static synchronized OTAServer getInstance() {
        if (instance == null) {
            instance = new OTAServer();
        }
        return instance;
    }

    public static synchronized int getPort() {
        Connector connector = OTAServer.getInstance().getHttpServer().getConnectors()[0];
        return connector.getLocalPort();
    }

    private OTAServer() {
    }

    public synchronized void start() throws Exception {
        if (this.server != null && !this.server.isStarted()) {
            this.server.start();
        }
    }

    public synchronized void stop() throws Exception {
        if (this.server != null && this.server.isStarted()) {
            this.server.stop();
        }
    }

    private String getLogFileName() {
        IPath stateLocation = MTJCore.getMTJCore().getStateLocation();
        IPath logDirectory = stateLocation.append("jetty");
        File logDirectoryFile = logDirectory.toFile();
        if (!logDirectoryFile.exists()) {
            logDirectoryFile.mkdir();
        }
        File logFile = new File(logDirectoryFile, "logfile");
        String filename = logFile + "yyyy_mm_dd.txt";
        return filename;
    }

    private Server createHttpServer() {
        Server server = new Server();
        server.setConnectors(this.getConnectors());
        server.setHandler((Handler)OTAHandler.getContextHandler());
        NCSARequestLog log = new NCSARequestLog(this.getLogFileName());
        server.addLifeCycle((LifeCycle)log);
        return server;
    }

    private Connector[] getConnectors() {
        int specifiedPortNumber;
        SocketConnector connector = new SocketConnector();
        if (Platform.getPreferencesService().getBoolean(MTJCore.getPluginId(), "ota_port_defined", false, null) && (specifiedPortNumber = Platform.getPreferencesService().getInt(MTJCore.getPluginId(), "ota_port", 0, null)) != 0) {
            connector.setPort(specifiedPortNumber);
        }
        return new Connector[]{connector};
    }

    private Server getHttpServer() {
        if (this.httpServer == null) {
            this.httpServer = this.createHttpServer();
        }
        return this.httpServer;
    }
}

