/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.sdk.device;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import java.util.Properties;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.mtj.core.build.preverifier.IPreverifier;
import org.eclipse.mtj.core.sdk.device.IDevice;
import org.eclipse.mtj.core.sdk.device.IDeviceImporter;
import org.eclipse.mtj.internal.core.Messages;
import org.eclipse.mtj.internal.core.sdk.device.JavaEmulatorDeviceProperties;
import org.eclipse.mtj.internal.core.util.log.MTJLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JavaEmulatorDeviceImporter
implements IDeviceImporter {
    private static final String ATTR_MAIN_CLASS = "Main-Class";
    protected Properties deviceProperties;

    private Properties readDeviceProperties() {
        Properties deviceProperties;
        block15: {
            deviceProperties = new Properties();
            InputStream propertiesStream = null;
            try {
                try {
                    URL propsFileURL = this.getDevicePropertiesURL();
                    propertiesStream = propsFileURL.openStream();
                    if (propertiesStream != null) {
                        deviceProperties.load(propertiesStream);
                    }
                }
                catch (IOException e) {
                    MTJLogger.log(4, Messages.JavaEmulatorDeviceImporter_0, e);
                    if (propertiesStream != null) {
                        try {
                            propertiesStream.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block15;
                }
            }
            catch (Throwable throwable) {
                if (propertiesStream != null) {
                    try {
                        propertiesStream.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (propertiesStream != null) {
                try {
                    propertiesStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return deviceProperties;
    }

    protected Properties getDeviceProperties() {
        if (this.deviceProperties == null) {
            this.deviceProperties = this.readDeviceProperties();
        }
        return this.deviceProperties;
    }

    protected abstract URL getDevicePropertiesURL();

    protected String getLaunchCommand() {
        return this.getDeviceProperties().getProperty(JavaEmulatorDeviceProperties.LAUNCH_COMMAND.toString(), "");
    }

    protected IPreverifier getPreverifier(File jarFile) {
        return null;
    }

    protected boolean hasMainClassAttribute(File file, String classname) throws IOException {
        JarFile jarFile = new JarFile(file);
        try {
            Manifest manifest = jarFile.getManifest();
            Attributes attributes = manifest.getMainAttributes();
            String mainClass = attributes.getValue(ATTR_MAIN_CLASS);
            boolean bl = mainClass != null && mainClass.trim().equals(classname);
            return bl;
        }
        finally {
            jarFile.close();
        }
    }

    protected boolean isDebugServer() {
        return this.getDeviceProperties().getProperty(JavaEmulatorDeviceProperties.DEBUG_SERVER.toString(), Boolean.FALSE.toString()).equalsIgnoreCase(Boolean.TRUE.toString());
    }

    @Override
    public List<IDevice> importDevices(File directory, IProgressMonitor monitor) throws CoreException, InterruptedException {
        return this.importDevices(directory, null, monitor);
    }
}

