/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.sdk.device;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.mtj.core.MTJCore;
import org.eclipse.mtj.core.sdk.device.ILibrary;
import org.eclipse.mtj.core.sdk.device.midp.IMIDPLibrary;
import org.eclipse.mtj.internal.core.Trace;

public class JavadocDetector {
    private static final String ZIP_EXT = ".zip";
    private static final String PACKAGE_LIST = "package-list";

    public URL detectJavadoc(ILibrary library) {
        boolean trace = Trace.isOptionEnabled(Trace.JAVADOC_DETECT_PERF);
        long enterTime = 0L;
        if (trace) {
            enterTime = System.currentTimeMillis();
        }
        URL retURL = this.searchForJavaDoc(library);
        if (trace) {
            long elapsed = System.currentTimeMillis() - enterTime;
            Trace.trace(Trace.JAVADOC_DETECT_PERF, "Detected javadoc for ", library.toString(), " in ", elapsed, "ms");
        }
        return retURL;
    }

    private URL searchForJavaDoc(ILibrary library) {
        URL foundURL = null;
        File[] rootDirs = this.getDefaultDocRootDirectories(library);
        if (rootDirs != null) {
            File[] fileArray = rootDirs;
            int n = rootDirs.length;
            int n2 = 0;
            while (n2 < n) {
                File docDir = fileArray[n2];
                foundURL = this.searchForLibraryDoc(docDir, library);
                if (foundURL != null) break;
                ++n2;
            }
        }
        return foundURL;
    }

    private File[] getDefaultDocRootDirectories(ILibrary library) {
        if (library == null) {
            return null;
        }
        ArrayList<File> docfiles = new ArrayList<File>();
        File parentDir = library.toFile().getParentFile();
        int i = 0;
        while (i < 5 && parentDir != null) {
            File[] tmpDocfiles;
            File[] fileArray = tmpDocfiles = parentDir.listFiles(new FileFilter(){

                public boolean accept(File pathname) {
                    return pathname.isDirectory() && pathname.getName().indexOf("doc") != -1;
                }
            });
            int n = tmpDocfiles.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                docfiles.add(file);
                ++n2;
            }
            parentDir = parentDir.getParentFile();
            ++i;
        }
        if (docfiles.size() > 0) {
            return docfiles.toArray(new File[0]);
        }
        return null;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private URL searchForLibraryDoc(File parentDir, ILibrary library) {
        URL url;
        block42: {
            int i;
            File[] subdirectories;
            block41: {
                block40: {
                    if (!(library instanceof IMIDPLibrary)) return null;
                    File[] javadocDirsOrZips = parentDir.listFiles(new FileFilter(){

                        public boolean accept(File folder) {
                            File packageList;
                            File indexFile;
                            return folder.isDirectory() && (indexFile = new File(folder, "index.html")).isFile() && (packageList = new File(folder, JavadocDetector.PACKAGE_LIST)).isFile();
                        }
                    });
                    if (javadocDirsOrZips.length == 0) {
                        javadocDirsOrZips = parentDir.listFiles(new FileFilter(){

                            /*
                             * Enabled aggressive block sorting
                             * Enabled unnecessary exception pruning
                             * Enabled aggressive exception aggregation
                             */
                            public boolean accept(File file) {
                                if (!file.isFile()) return false;
                                if (!file.getName().toLowerCase().endsWith(JavadocDetector.ZIP_EXT)) return false;
                                try {
                                    ZipFile zip = new ZipFile(file);
                                    try {
                                        ZipEntry indexEntry = zip.getEntry("index.html");
                                        if (indexEntry == null) return false;
                                        if (indexEntry.isDirectory()) return false;
                                        ZipEntry packageListEntry = zip.getEntry(JavadocDetector.PACKAGE_LIST);
                                        if (packageListEntry == null) return false;
                                        if (packageListEntry.isDirectory()) return false;
                                        return true;
                                    }
                                    finally {
                                        zip.close();
                                    }
                                }
                                catch (Throwable throwable) {
                                    return false;
                                }
                            }
                        });
                    }
                    if (javadocDirsOrZips.length > 0) {
                        try {
                            JarFile jar = new JarFile(library.toFile());
                            boolean found = false;
                            IMIDPLibrary midpLib = (IMIDPLibrary)library;
                            boolean mustHaveJavaLang = midpLib.hasProfile() || midpLib.hasConfiguration();
                            HashSet<String> expandedJarEntries = new HashSet<String>();
                            Enumeration<JarEntry> jarEntries = jar.entries();
                            while (jarEntries.hasMoreElements()) {
                                File entryFile = new File(jarEntries.nextElement().getName());
                                while (entryFile != null) {
                                    entryFile = expandedJarEntries.add(entryFile.getPath().replace(File.separator, "/")) ? entryFile.getParentFile() : null;
                                }
                            }
                            Trace.trace(Trace.JAVADOC_DETECT_DEBUG, "Searching javadocs for ", midpLib);
                            int i2 = 0;
                            while (i2 < javadocDirsOrZips.length) {
                                String pListName;
                                BufferedReader reader;
                                boolean foundJavaLang = false;
                                ZipFile zip = null;
                                if (javadocDirsOrZips[i2].isDirectory()) {
                                    File pList = new File(javadocDirsOrZips[i2], PACKAGE_LIST);
                                    reader = new BufferedReader(new FileReader(pList));
                                    pListName = pList.toString();
                                } else {
                                    zip = new ZipFile(javadocDirsOrZips[i2]);
                                    reader = new BufferedReader(new InputStreamReader(zip.getInputStream(zip.getEntry(PACKAGE_LIST))));
                                    pListName = String.valueOf(javadocDirsOrZips[i2].toString()) + File.separator + PACKAGE_LIST;
                                }
                                try {
                                    String libraryName;
                                    String s = reader.readLine();
                                    while (s != null) {
                                        if (s.startsWith("#")) {
                                            s = reader.readLine();
                                            continue;
                                        }
                                        if (mustHaveJavaLang && !foundJavaLang && "java.lang".equals(s.trim())) {
                                            Trace.trace(Trace.JAVADOC_DETECT_DEBUG, "java.lang entry found in line ", s, " package-list is ", pListName);
                                            foundJavaLang = true;
                                        }
                                        if (!expandedJarEntries.contains(s.replace('.', '/'))) {
                                            found = false;
                                            break;
                                        }
                                        s = reader.readLine();
                                        found = true;
                                        if (!mustHaveJavaLang || foundJavaLang) continue;
                                        found = false;
                                    }
                                    if (found) {
                                        Trace.trace(Trace.JAVADOC_DETECT_DEBUG, "Found javadocs for ", midpLib, " in ", javadocDirsOrZips[i2]);
                                        URL uRL = this.getJavadocsURL(javadocDirsOrZips[i2]);
                                        return uRL;
                                    }
                                    String libFileName = library.toFile().getName();
                                    int dotIdx = libFileName.lastIndexOf(46);
                                    String libName = dotIdx > -1 ? libFileName.substring(0, dotIdx) : libFileName;
                                    String pathname = javadocDirsOrZips[i2].getName().toLowerCase().replace('_', '-');
                                    if (zip != null && pathname.endsWith(ZIP_EXT)) {
                                        pathname = pathname.substring(0, pathname.length() - ZIP_EXT.length());
                                    }
                                    if (pathname.startsWith(libraryName = libName.toLowerCase().replace('_', '-')) || libraryName.startsWith(pathname)) {
                                        URL uRL = this.getJavadocsURL(javadocDirsOrZips[i2]);
                                        return uRL;
                                    }
                                }
                                finally {
                                    try {
                                        reader.close();
                                    }
                                    finally {
                                        if (zip != null) {
                                            zip.close();
                                        }
                                    }
                                }
                                ++i2;
                            }
                            break block40;
                            {
                                continue;
                                break;
                            }
                            finally {
                                jar.close();
                            }
                        }
                        catch (IOException e) {
                            MTJCore.getMTJCore().getLog().log((IStatus)new Status(2, MTJCore.getPluginId(), "Error while matchin javadocs", (Throwable)e));
                        }
                    }
                }
                subdirectories = parentDir.listFiles(new FileFilter(){

                    public boolean accept(File pathname) {
                        return pathname.isDirectory();
                    }
                });
                url = null;
                i = 0;
                if (!true) break block41;
                if (i >= subdirectories.length) return url;
                if (url != null) break block42;
            }
            do {
                url = this.searchForLibraryDoc(subdirectories[i], library);
                ++i;
                if (i >= subdirectories.length) return url;
            } while (url == null);
        }
        return url;
    }

    private URL getJavadocsURL(File javadocDirOrZip) throws MalformedURLException {
        if (javadocDirOrZip.isDirectory()) {
            return javadocDirOrZip.toURI().toURL();
        }
        try {
            return new URI("jar:" + javadocDirOrZip.toURI().toString() + "!/").toURL();
        }
        catch (URISyntaxException uRISyntaxException) {
            return null;
        }
    }
}

