/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.symbol;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.mtj.core.MTJCore;
import org.eclipse.mtj.core.persistence.IPersistable;
import org.eclipse.mtj.core.persistence.IPersistenceProvider;
import org.eclipse.mtj.core.persistence.PersistenceException;
import org.eclipse.mtj.core.symbol.ISymbolSet;
import org.eclipse.mtj.core.symbol.ISymbolSetRegistry;
import org.eclipse.mtj.core.symbol.ISymbolSetRegistryChangeListener;
import org.eclipse.mtj.internal.core.Messages;
import org.eclipse.mtj.internal.core.persistence.XMLPersistenceProvider;
import org.eclipse.mtj.internal.core.symbol.ISymbolSetConstants;
import org.eclipse.mtj.internal.core.symbol.SymbolSet;
import org.eclipse.mtj.internal.core.util.migration.SymbolDefinitionsMigration;
import org.eclipse.mtj.internal.core.util.xml.XMLUtils;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SymbolSetRegistry
implements ISymbolSetRegistry,
ISymbolSetConstants {
    private static final SymbolSetRegistry instance = new SymbolSetRegistry();
    private static final String FILENAME = "symbolDefinitions.xml";
    private Map<String, IPersistable> registryMap;
    List<ISymbolSetRegistryChangeListener> listeners = new ArrayList<ISymbolSetRegistryChangeListener>();

    private SymbolSetRegistry() {
    }

    public static ISymbolSetRegistry getInstance() {
        return instance;
    }

    @Override
    public void addSymbolSet(ISymbolSet definitions) throws PersistenceException {
        String name = definitions.getName();
        if (name == null) {
            throw new IllegalStateException(Messages.SymbolDefinitionSetRegistry_addDefinitionSet_no_name_exception);
        }
        this.getRegistryMap().put(definitions.getName(), definitions);
        this.notifyListeners();
    }

    @Override
    public void addSymbolSetRegistryChangeListener(ISymbolSetRegistryChangeListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public ISymbolSet getSymbolSet(String name) throws PersistenceException {
        return (ISymbolSet)this.getRegistryMap().get(name);
    }

    @Override
    public void removeSymbolSet(String setName) {
        this.registryMap.remove(setName);
        this.notifyListeners();
    }

    @Override
    public void removeSymbolSetRegistryChangeListener(ISymbolSetRegistryChangeListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void clear() throws PersistenceException {
        this.getRegistryMap().clear();
    }

    @Override
    public String[] getAllSymbolSetNames() throws PersistenceException {
        Set<String> keys = this.registryMap.keySet();
        return keys.toArray(new String[keys.size()]);
    }

    @Override
    public ISymbolSet[] getAllSymbolSets() throws PersistenceException {
        Collection<IPersistable> definitions = this.getRegistryMap().values();
        return definitions.toArray(new SymbolSet[definitions.size()]);
    }

    @Override
    public void loadUsing(IPersistenceProvider persistenceProvider) throws PersistenceException {
        String keysString;
        if (this.registryMap != null && (keysString = persistenceProvider.loadString("mtjKeys")) != null && keysString.length() > 0) {
            String[] keys;
            String[] stringArray = keys = keysString.split(",");
            int n = keys.length;
            int n2 = 0;
            while (n2 < n) {
                String key = stringArray[n2];
                ISymbolSet definitions = (ISymbolSet)persistenceProvider.loadPersistable(key);
                this.registryMap.put(definitions.getName(), definitions);
                ++n2;
            }
        }
    }

    @Override
    public void storeUsing(IPersistenceProvider persistenceProvider) throws PersistenceException {
        StringBuffer keyString = new StringBuffer();
        Iterator<IPersistable> definitions = this.getRegistryMap().values().iterator();
        while (definitions.hasNext()) {
            SymbolSet definition = (SymbolSet)definitions.next();
            String name = definition.getStorableName();
            persistenceProvider.storePersistable(name, definition);
            keyString.append(name);
            if (!definitions.hasNext()) continue;
            keyString.append(",");
        }
        persistenceProvider.storeString("mtjKeys", keyString.toString());
    }

    private synchronized Map<String, IPersistable> getRegistryMap() throws PersistenceException {
        if (this.registryMap == null) {
            this.registryMap = new HashMap<String, IPersistable>();
            this.load();
        }
        return this.registryMap;
    }

    private File getStoreFile() {
        IPath pluginStatePath = MTJCore.getMTJCore().getStateLocation();
        IPath storePath = pluginStatePath.append(FILENAME);
        return storePath.toFile();
    }

    private void notifyListeners() {
        for (ISymbolSetRegistryChangeListener listener : this.listeners) {
            listener.symbolSetRegistryChanged();
        }
    }

    @Override
    public void load() throws PersistenceException {
        File storeFile;
        if (this.registryMap != null) {
            this.registryMap.clear();
        }
        if ((storeFile = this.getStoreFile()).exists()) {
            try {
                Document document = XMLUtils.readDocument(storeFile);
                SymbolDefinitionsMigration migration = new SymbolDefinitionsMigration();
                migration.migrate(document);
                if (migration.isMigrated()) {
                    try {
                        XMLUtils.writeDocument(storeFile, document);
                    }
                    catch (TransformerException e) {
                        e.printStackTrace();
                    }
                    document = XMLUtils.readDocument(storeFile);
                }
                XMLPersistenceProvider pprovider = new XMLPersistenceProvider(document);
                this.loadUsing(pprovider);
            }
            catch (ParserConfigurationException e) {
                throw new PersistenceException(e.getMessage(), e);
            }
            catch (SAXException e) {
                throw new PersistenceException(e.getMessage(), e);
            }
            catch (IOException e) {
                throw new PersistenceException(e.getMessage(), e);
            }
        }
    }

    @Override
    public void store() throws PersistenceException, TransformerException, IOException {
        XMLPersistenceProvider pprovider = new XMLPersistenceProvider("symbolDefinitionsRegistry");
        this.storeUsing(pprovider);
        XMLUtils.writeDocument(this.getStoreFile(), pprovider.getDocument());
    }

    @Override
    public void addSymbolSet(List<ISymbolSet> ss) throws PersistenceException {
        for (ISymbolSet s : ss) {
            this.registryMap.put(s.getName(), s);
        }
        this.notifyListeners();
    }

    public void addNewSymbolSet(ISymbolSet ss) throws PersistenceException {
        this.registryMap.put(ss.getName(), ss);
        this.notifyListeners();
    }
}

