/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.text;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.jface.text.IDocument;
import org.eclipse.mtj.internal.core.IModelChangeProviderExtension;
import org.eclipse.mtj.internal.core.IModelChangedEvent;
import org.eclipse.mtj.internal.core.IModelChangedListener;
import org.eclipse.mtj.internal.core.IModelChangedListenerFilter;
import org.eclipse.mtj.internal.core.ModelChangedEvent;
import org.eclipse.mtj.internal.core.text.IEditingModel;
import org.eclipse.mtj.internal.core.text.IModelTextChangeListener;

public abstract class AbstractEditingModel
extends PlatformObject
implements IEditingModel,
IModelChangeProviderExtension {
    private String fCharset;
    private boolean fDirty;
    private IDocument fDocument;
    private String fInstallLocation;
    private ArrayList<IModelChangedListener> fListeners = new ArrayList();
    private boolean fStale;
    private IResource fUnderlyingResource;
    protected boolean fDisposed;
    protected boolean fInSync = true;
    protected boolean fLoaded = false;
    protected boolean fReconciling;
    protected long fTimestamp;

    public AbstractEditingModel(IDocument document, boolean isReconciling) {
        this.fDocument = document;
        this.fReconciling = isReconciling;
    }

    public void addModelChangedListener(IModelChangedListener listener) {
        if (!this.fListeners.contains(listener)) {
            this.fListeners.add(listener);
        }
    }

    public abstract void adjustOffsets(IDocument var1) throws CoreException;

    public void dispose() {
        this.fDisposed = true;
        this.fListeners.clear();
    }

    public void fireModelChanged(IModelChangedEvent event) {
        if (event.getChangeType() == 3 && event.getOldValue() != null && event.getOldValue().equals(event.getNewValue())) {
            return;
        }
        this.setDirty(event.getChangeType() != 99);
        int i = 0;
        while (i < this.fListeners.size()) {
            this.fListeners.get(i).modelChanged(event);
            ++i;
        }
    }

    public void fireModelObjectChanged(Object object, String property, Object oldValue, Object newValue) {
        this.fireModelChanged(new ModelChangedEvent(this, object, property, oldValue, newValue));
    }

    public String getCharset() {
        return this.fCharset != null ? this.fCharset : "UTF-8";
    }

    public IDocument getDocument() {
        return this.fDocument;
    }

    public String getInstallLocation() {
        if (this.fInstallLocation == null && this.fUnderlyingResource != null) {
            IPath path = this.fUnderlyingResource.getProject().getLocation();
            return path != null ? path.addTrailingSeparator().toString() : null;
        }
        return this.fInstallLocation;
    }

    public IModelTextChangeListener getLastTextChangeListener() {
        int i = this.fListeners.size() - 1;
        while (i >= 0) {
            IModelChangedListener obj = this.fListeners.get(i);
            if (obj instanceof IModelTextChangeListener) {
                return (IModelTextChangeListener)obj;
            }
            --i;
        }
        return null;
    }

    public final long getTimeStamp() {
        return this.fTimestamp;
    }

    public IResource getUnderlyingResource() {
        return this.fUnderlyingResource;
    }

    public boolean isDirty() {
        return this.fDirty;
    }

    public boolean isDisposed() {
        return this.fDisposed;
    }

    public boolean isEditable() {
        return this.fReconciling;
    }

    public boolean isInSync() {
        return this.fInSync;
    }

    public boolean isLoaded() {
        return this.fLoaded;
    }

    public boolean isReconcilingModel() {
        return this.fReconciling;
    }

    public boolean isStale() {
        return this.fStale;
    }

    public boolean isValid() {
        return this.isLoaded();
    }

    public final void load() throws CoreException {
        try {
            this.load(this.getInputStream(this.getDocument()), false);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {}
    }

    public final void reconciled(IDocument document) {
        if (this.isReconcilingModel()) {
            try {
                if (this.isStale()) {
                    this.adjustOffsets(document);
                    this.setStale(false);
                } else {
                    this.reload(this.getInputStream(document), false);
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
            }
            catch (CoreException coreException) {}
            if (this.isDirty()) {
                this.setDirty(false);
            }
        }
    }

    public final void reload(InputStream source, boolean outOfSync) throws CoreException {
        this.load(source, outOfSync);
        this.fireModelChanged(new ModelChangedEvent(this, 99, new Object[]{this}, null));
    }

    public void removeModelChangedListener(IModelChangedListener listener) {
        this.fListeners.remove(listener);
    }

    public void save(PrintWriter writer) {
    }

    public void setCharset(String charset) {
        this.fCharset = charset;
    }

    public void setDirty(boolean dirty) {
        this.fDirty = dirty;
    }

    public void setInstallLocation(String location) {
        this.fInstallLocation = location;
    }

    public void setLoaded(boolean loaded) {
        this.fLoaded = loaded;
    }

    public void setStale(boolean stale) {
        this.fStale = stale;
    }

    public void setUnderlyingResource(IResource resource) {
        this.fUnderlyingResource = resource;
    }

    public void transferListenersTo(IModelChangeProviderExtension target, IModelChangedListenerFilter filter) {
        List oldList = (List)this.fListeners.clone();
        int i = 0;
        while (i < oldList.size()) {
            IModelChangedListener listener = (IModelChangedListener)oldList.get(i);
            if (filter == null || filter.accept(listener)) {
                target.addModelChangedListener(listener);
                this.fListeners.remove(listener);
            }
            ++i;
        }
    }

    protected InputStream getInputStream(IDocument document) throws UnsupportedEncodingException {
        return new BufferedInputStream(new ByteArrayInputStream(document.get().getBytes(this.getCharset())));
    }
}

