/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.text.l10n;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.mtj.internal.core.MTJPluginSchemas;
import org.eclipse.mtj.internal.core.text.l10n.L10nModel;
import org.eclipse.mtj.internal.core.text.l10n.L10nObject;

public class L10nEntry
extends L10nObject {
    private static final long serialVersionUID = 1L;
    private Schema schema;

    public L10nEntry(L10nModel model) {
        super(model, "entry");
    }

    public boolean canBeParent() {
        return false;
    }

    public String getKey() {
        return this.getXMLAttributeValue("key");
    }

    public String getName() {
        return this.getXMLAttributeValue("key");
    }

    public int getType() {
        return 2;
    }

    public String getValue() {
        return this.getXMLAttributeValue("value");
    }

    public void setKey(String Key2) {
        this.setXMLAttribute("key", Key2);
    }

    public void setValue(String value) {
        this.setXMLAttribute("value", value);
    }

    public void validate() {
        this.validateEntrySchema();
    }

    private void validateEntrySchema() {
        String doc = this.toString();
        BufferedInputStream is = null;
        try {
            is = new BufferedInputStream(new ByteArrayInputStream(doc.getBytes("UTF-8")));
            String schemaLang = "http://www.w3.org/2001/XMLSchema";
            SchemaFactory factory = SchemaFactory.newInstance(schemaLang);
            if (this.schema == null) {
                this.schema = factory.newSchema(MTJPluginSchemas.getInstance().create("entry.xsd"));
            }
            Validator validator = this.schema.newValidator();
            validator.validate(new StreamSource(is));
            Status status = new Status(0, "org.eclipse.mtj.core", null);
            this.setStatus((IStatus)status);
        }
        catch (Exception ex) {
            Status status = new Status(4, "org.eclipse.mtj.core", ex.getMessage(), (Throwable)ex);
            this.setStatus((IStatus)status);
        }
    }
}

