/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.text.l10n;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Vector;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.mtj.internal.core.MTJPluginSchemas;
import org.eclipse.mtj.internal.core.Messages;
import org.eclipse.mtj.internal.core.text.IDocumentElementNode;
import org.eclipse.mtj.internal.core.text.l10n.L10nLocale;
import org.eclipse.mtj.internal.core.text.l10n.L10nMarkerError;
import org.eclipse.mtj.internal.core.text.l10n.L10nModel;
import org.eclipse.mtj.internal.core.text.l10n.L10nObject;
import org.xml.sax.SAXParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class L10nLocales
extends L10nObject {
    private static final long serialVersionUID = 1L;
    private L10nLocale defaultLocale;
    private Schema schema;
    private Vector<L10nLocale> localeList;

    public L10nLocales(L10nModel model) {
        super(model, "locales");
        this.setInTheModel(true);
        this.localeList = new Vector();
    }

    @Override
    public void addChild(L10nObject child) {
        this.addChildNode((IDocumentElementNode)child, true);
    }

    @Override
    public void addChild(L10nObject child, L10nObject sibling, boolean insertBefore) {
        int currentIndex = this.indexOf(sibling);
        if (!insertBefore) {
            ++currentIndex;
        }
        this.addChildNode(child, currentIndex, true);
    }

    @Override
    public boolean canBeParent() {
        return true;
    }

    public String getDestination() {
        return this.getXMLAttributeValue("destination");
    }

    public L10nLocale getDefaultLocale() {
        String name = this.getXMLAttributeValue("default-locale");
        if (name == null || name.length() == 0) {
            this.defaultLocale = null;
        } else {
            IDocumentElementNode[] localeNodes = this.getChildNodes();
            boolean found = false;
            IDocumentElementNode[] iDocumentElementNodeArray = localeNodes;
            int n = localeNodes.length;
            int n2 = 0;
            while (n2 < n) {
                L10nLocale locale;
                IDocumentElementNode localeNode = iDocumentElementNodeArray[n2];
                if (localeNode instanceof L10nLocale && (locale = (L10nLocale)localeNode).getName().equals(name)) {
                    this.defaultLocale = locale;
                    found = true;
                    break;
                }
                ++n2;
            }
            if (!found) {
                this.defaultLocale = null;
                this.setXMLAttribute("default-locale", "");
            }
        }
        return this.defaultLocale;
    }

    public L10nLocale createlLocale() {
        L10nLocale locale = null;
        locale = new L10nLocale(this.getModel());
        this.localeList.add(locale);
        return locale;
    }

    public L10nLocale getLocale(IDocumentElementNode loc) {
        L10nLocale locale = null;
        int i = 0;
        while (i < this.localeList.size()) {
            if (this.localeList.get(i).equals(loc)) {
                locale = this.localeList.get(i);
            }
            ++i;
        }
        return locale;
    }

    @Override
    public String getName() {
        return "Locales";
    }

    public String getPackage() {
        String pack = this.getXMLAttributeValue("package");
        return pack == null ? "" : pack;
    }

    @Override
    public int getType() {
        return 0;
    }

    @Override
    public boolean isRoot() {
        return true;
    }

    public void moveChild(L10nObject l10nObject, int newRelativeIndex) {
        this.moveChildNode(l10nObject, newRelativeIndex, true);
    }

    public void removeChild(L10nObject l10nObject) {
        this.removeChildNode(l10nObject, true);
    }

    public void setDestination(String name) {
        this.setXMLAttribute("destination", name);
    }

    public void setPackage(String value) {
        this.setXMLAttribute("package", value);
    }

    public void setDefaultLocale(L10nLocale locale) {
        String value = null;
        if (locale != null) {
            value = locale.getName();
        }
        this.setXMLAttribute("default-locale", value);
        this.defaultLocale = locale;
    }

    @Override
    public void validate() {
        if (!this.validateLocalesSchema()) {
            IDocumentElementNode[] localeList = this.getChildNodes();
            int i = 0;
            while (i < localeList.length) {
                block14: {
                    L10nLocale locale;
                    try {
                        locale = (L10nLocale)localeList[i];
                    }
                    catch (Exception exception) {
                        break block14;
                    }
                    locale.validate();
                }
                ++i;
            }
        } else {
            IDocumentElementNode[] localeNodes = this.getChildNodes();
            ArrayList<L10nLocale> duplicates = new ArrayList<L10nLocale>();
            int i = 0;
            while (i < localeNodes.length) {
                block15: {
                    L10nLocale locale;
                    try {
                        locale = (L10nLocale)localeNodes[i];
                    }
                    catch (Exception exception) {
                        break block15;
                    }
                    locale.validate();
                    String localeName = locale.getName();
                    if (!duplicates.contains(locale)) {
                        boolean hasDuplicates = false;
                        int j = 0;
                        while (j < localeNodes.length) {
                            if (localeNodes[j] instanceof L10nLocale) {
                                L10nLocale candidate = (L10nLocale)localeNodes[j];
                                String candidateName = candidate.getLocaleName();
                                if (j != i && localeName.equalsIgnoreCase(candidateName)) {
                                    duplicates.add(candidate);
                                    hasDuplicates = true;
                                }
                            }
                            ++j;
                        }
                        if (hasDuplicates) {
                            duplicates.add(locale);
                        }
                    }
                }
                ++i;
            }
            for (L10nLocale duplicate : duplicates) {
                duplicate.setStatus((IStatus)new Status(4, "org.eclipse.mtj.core", Messages.L10nLocales_duplicatedLocale));
            }
        }
    }

    public Vector<L10nMarkerError> getMarkerErrors() {
        IDocumentElementNode[] localeNodes = this.getChildNodes();
        Vector<L10nMarkerError> markerErrors = new Vector<L10nMarkerError>();
        if (!this.getStatus().isOK()) {
            if (this.getStatus().getException() instanceof SAXParseException) {
                SAXParseException ex = (SAXParseException)this.getStatus().getException();
                L10nMarkerError marker = new L10nMarkerError(ex.getMessage(), ex.getLineNumber());
                markerErrors.add(marker);
            } else {
                int errorLine = -1;
                try {
                    int offSet = this.getModel().getDocument().getLineOfOffset(this.getOffset());
                    int length = this.getLength();
                    errorLine = offSet + this.getModel().getDocument().getNumberOfLines(this.getOffset(), length);
                }
                catch (BadLocationException badLocationException) {
                    return new Vector<L10nMarkerError>();
                }
                L10nMarkerError marker = new L10nMarkerError(this.getStatus().getMessage(), errorLine);
                markerErrors.add(marker);
            }
        } else {
            int i = 0;
            while (i < localeNodes.length) {
                block16: {
                    try {
                        L10nLocale locale;
                        try {
                            locale = (L10nLocale)localeNodes[i];
                        }
                        catch (Exception exception) {
                            break block16;
                        }
                        if (locale.getStatus().isOK()) {
                            Vector<L10nMarkerError> entryErrors = locale.getMarkerErrors();
                            if (entryErrors.size() > 0) {
                                return entryErrors;
                            }
                        } else {
                            int errorLine = -1;
                            try {
                                int offSet = this.getModel().getDocument().getLineOfOffset(locale.getOffset());
                                int length = locale.getLength();
                                errorLine = offSet + this.getModel().getDocument().getNumberOfLines(locale.getOffset(), length);
                                L10nMarkerError marker = new L10nMarkerError(locale.getStatus().getMessage(), errorLine);
                                markerErrors.add(marker);
                            }
                            catch (BadLocationException badLocationException) {}
                        }
                    }
                    catch (Exception exception) {}
                }
                ++i;
            }
        }
        return markerErrors;
    }

    public int getLocalesLine() {
        int line = -1;
        try {
            line = this.getModel().getDocument().getLineOfOffset(this.getOffset());
        }
        catch (BadLocationException badLocationException) {
            return line;
        }
        return line;
    }

    private boolean validateLocalesSchema() {
        boolean isOK = true;
        IDocument doc = this.getModel().getDocument();
        BufferedInputStream is = null;
        try {
            is = new BufferedInputStream(new ByteArrayInputStream(doc.get().getBytes("UTF-8")));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            isOK = false;
        }
        try {
            String schemaLang = "http://www.w3.org/2001/XMLSchema";
            SchemaFactory factory = SchemaFactory.newInstance(schemaLang);
            if (this.schema == null) {
                this.schema = factory.newSchema(MTJPluginSchemas.getInstance().create("locales.xsd"));
            }
            Validator validator = this.schema.newValidator();
            validator.validate(new StreamSource(is));
            Status status = new Status(0, "org.eclipse.mtj.core", null);
            this.setStatus((IStatus)status);
        }
        catch (Exception ex) {
            Status status = new Status(4, "org.eclipse.mtj.core", ex.getMessage(), (Throwable)ex);
            this.setStatus((IStatus)status);
            isOK = false;
        }
        return isOK;
    }

    @Override
    public IDocumentElementNode removeChildNode(IDocumentElementNode child, boolean fireEvent) {
        this.localeList.remove(child);
        return super.removeChildNode(child, fireEvent);
    }

    public L10nLocale getLocale(String localeName) {
        IDocumentElementNode[] localeNodes;
        L10nLocale result = null;
        IDocumentElementNode[] iDocumentElementNodeArray = localeNodes = this.getChildNodes();
        int n = localeNodes.length;
        int n2 = 0;
        while (n2 < n) {
            L10nLocale locale;
            IDocumentElementNode node = iDocumentElementNodeArray[n2];
            if (node instanceof L10nLocale && (locale = (L10nLocale)node).getLocaleName().equals(localeName)) {
                result = locale;
                break;
            }
            ++n2;
        }
        return result;
    }
}

