/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.util;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.IStreamListener;
import org.eclipse.debug.core.Launch;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStreamMonitor;
import org.eclipse.debug.core.model.IStreamsProxy;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.formatter.CodeFormatter;
import org.eclipse.jdt.internal.core.BinaryType;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.mtj.core.MTJCore;
import org.eclipse.mtj.core.project.IMTJProject;
import org.eclipse.mtj.internal.core.Messages;
import org.eclipse.mtj.internal.core.util.MTJStatusHandler;
import org.eclipse.mtj.internal.core.util.log.MTJLogger;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.TextEdit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Utils {
    public static final String EMPTY_STRING = "";
    private static final byte[] buffer = new byte[1024];
    private static boolean caseSensitiveFileSystem;
    private static boolean caseSensitivityChecked;
    private static final FileFilter DEFAULT_FILTER;
    private static final String PRIVATE_CONFIGURATION = "org.eclipse.debug.ui.private";

    static {
        DEFAULT_FILTER = new FileFilter(){

            public boolean accept(File pathname) {
                return true;
            }
        };
    }

    public static boolean arePathTargetsEqual(IPath path1, IPath path2) throws CoreException {
        boolean equal = false;
        File file1 = Utils.getPathTargetFile(path1);
        File file2 = Utils.getPathTargetFile(path2);
        if (file1 != null && file2 != null) {
            equal = file1.equals(file2);
        }
        return equal;
    }

    public static void clearContainer(IContainer container, IProgressMonitor monitor) throws CoreException {
        if (container.exists()) {
            IResource[] resources;
            IResource[] iResourceArray = resources = container.members();
            int n = resources.length;
            int n2 = 0;
            while (n2 < n) {
                IResource resource = iResourceArray[n2];
                ResourceAttributes attributes = resource.getResourceAttributes();
                if (attributes != null) {
                    if (attributes.isReadOnly()) {
                        attributes.setReadOnly(false);
                        resource.setResourceAttributes(attributes);
                    }
                    if (resource instanceof IContainer) {
                        Utils.clearContainer((IContainer)resource, monitor);
                    }
                    if (resource.exists()) {
                        resource.delete(true, monitor);
                    }
                }
                ++n2;
            }
        }
    }

    public static String codeFormat(IJavaProject project, String sourceString, int kind, int initialIndentationLevel, String lineDelim) {
        CodeFormatter formatter = ToolFactory.createCodeFormatter((Map)project.getOptions(true));
        TextEdit edit = formatter.format(kind, sourceString, 0, sourceString.length(), initialIndentationLevel, lineDelim);
        if (edit != null) {
            Document document = new Document(sourceString);
            try {
                edit.apply((IDocument)document);
                return document.get();
            }
            catch (MalformedTreeException malformedTreeException) {
            }
            catch (BadLocationException badLocationException) {}
        }
        return sourceString;
    }

    public static void copy(File source, File destination) throws IOException {
        Utils.copy(source, destination, null);
    }

    public static void copy(File source, File destination, FileFilter filter) throws IOException, SecurityException {
        if (source.exists()) {
            if (source.isDirectory()) {
                Utils.copyDirectory(source, destination, filter);
            } else {
                Utils.copyFile(source, destination, filter);
            }
        }
    }

    public static void copyDirectory(File source, File destination, FileFilter filter) throws IOException, SecurityException {
        if (filter == null) {
            filter = DEFAULT_FILTER;
        }
        if (source.exists() && source.isDirectory() && filter.accept(source)) {
            File[] sources;
            destination.mkdirs();
            File[] fileArray = sources = source.listFiles();
            int n = sources.length;
            int n2 = 0;
            while (n2 < n) {
                File newSource = fileArray[n2];
                File newDestination = new File(destination, newSource.getName());
                if (newSource.isDirectory()) {
                    Utils.copyDirectory(newSource, newDestination, filter);
                } else {
                    Utils.copyFile(newSource, newDestination, filter);
                }
                ++n2;
            }
        }
    }

    public static void copyFile(File sourceFile, File targetFile, FileFilter filter) throws IOException, SecurityException {
        if (filter == null) {
            filter = DEFAULT_FILTER;
        }
        if (filter.accept(sourceFile)) {
            FileInputStream fis = new FileInputStream(sourceFile);
            FileOutputStream fos = new FileOutputStream(targetFile);
            Utils.copyInputToOutput(fis, fos);
            fis.close();
            fos.close();
        }
    }

    public static void copyFile(IFile sourceFile, IFile targetFile) throws IOException, SecurityException {
        Utils.copyFile(sourceFile.getLocation().toFile(), targetFile.getLocation().toFile(), null);
    }

    public static void copyInputToOutput(InputStream input, OutputStream output) throws IOException {
        int bytesRead = 0;
        do {
            if ((bytesRead = input.read(buffer, 0, buffer.length)) <= 0) continue;
            output.write(buffer, 0, bytesRead);
        } while (bytesRead != -1);
        output.flush();
    }

    public static void createArchive(File tgtArchiveFile, File srcFolder) throws IOException {
        if (srcFolder.exists() && srcFolder.isDirectory()) {
            ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(tgtArchiveFile));
            try {
                Utils.addFolderToArchive(zos, srcFolder.getAbsolutePath().length() + 1, srcFolder);
            }
            catch (Throwable throwable) {
                if (zos != null) {
                    try {
                        zos.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (zos != null) {
                try {
                    zos.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static void delete(File file) {
        if (file.exists()) {
            if (file.isDirectory()) {
                File[] files;
                File[] fileArray = files = file.listFiles();
                int n = files.length;
                int n2 = 0;
                while (n2 < n) {
                    File file2 = fileArray[n2];
                    Utils.delete(file2);
                    ++n2;
                }
            }
            file.delete();
        }
    }

    public static void dumpCommandLine(ILaunch launch) {
        IProcess process;
        IProcess[] processes = launch.getProcesses();
        if (processes != null && processes.length > 0 && (process = processes[0]) != null) {
            String commandLine = process.getAttribute(IProcess.ATTR_CMDLINE);
            Utils.dumpCommandLine(commandLine);
        }
    }

    public static void dumpCommandLine(String commandLine) {
        String propValue = System.getProperty("mtj.dump.launch", Boolean.FALSE.toString());
        boolean doDump = propValue.equalsIgnoreCase(Boolean.TRUE.toString());
        if (doDump) {
            String text = commandLine == null ? Messages.Utils_commandLine_not_found : String.valueOf(Messages.Utils_commandLine) + commandLine;
            MTJLogger.log(1, text);
        }
    }

    public static void dumpCommandLine(String[] commandLine) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < commandLine.length) {
            String string = commandLine[i];
            if (i != 0) {
                sb.append(' ');
            }
            sb.append(string);
            ++i;
        }
        Utils.dumpCommandLine(sb.toString());
    }

    public static Process exec(String[] commandLine, File workingDirectory, String[] env) throws CoreException {
        return DebugPlugin.exec((String[])commandLine, (File)workingDirectory, (String[])env);
    }

    public static boolean executableExists(File executableFile) {
        File winExecutable = new File(executableFile.getParentFile(), String.valueOf(executableFile.getName()) + ".exe");
        return executableFile.exists() || winExecutable.exists();
    }

    public static void extractArchive(File jarFile, File tgtDirectory) throws IOException, SecurityException {
        ZipInputStream zis = new ZipInputStream(new FileInputStream(jarFile));
        try {
            ZipEntry zipEntry = null;
            while ((zipEntry = zis.getNextEntry()) != null) {
                if (zipEntry.isDirectory()) {
                    File directory = new File(tgtDirectory, zipEntry.getName());
                    directory.mkdirs();
                    continue;
                }
                File zipEntryFile = new File(tgtDirectory, zipEntry.getName());
                File zipEntryParentFile = zipEntryFile.getParentFile();
                if (zipEntryParentFile == null) continue;
                zipEntryParentFile.mkdirs();
                FileOutputStream fos = new FileOutputStream(zipEntryFile);
                try {
                    Utils.copyInputToOutput(zis, fos);
                }
                catch (Throwable throwable) {
                    if (fos != null) {
                        try {
                            fos.close();
                        }
                        catch (IOException iOException) {}
                    }
                    throw throwable;
                }
                if (fos == null) continue;
                try {
                    fos.close();
                }
                catch (IOException iOException) {}
            }
        }
        catch (Throwable throwable) {
            try {
                zis.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            zis.close();
        }
        catch (IOException iOException) {}
    }

    public static String extractClassName(IJavaProject javaProject, IResource resource) throws JavaModelException {
        IPath classPath = Utils.extractsSourceFolderRelativePath(javaProject, resource);
        return classPath == null ? null : classPath.removeFileExtension().toString().replace('/', '.');
    }

    public static IPath extractsSourceFolderRelativePath(IJavaProject javaProject, IResource resource) throws JavaModelException {
        return Utils.extractsSourceFolderRelativePath(javaProject, resource, false);
    }

    public static IPath extractsSourceFolderRelativePath(IJavaProject javaProject, IResource resource, boolean isSource) throws JavaModelException {
        IClasspathEntry[] classpath;
        IPath resultPath = null;
        IPath projectOutputPath = javaProject.getOutputLocation().makeAbsolute();
        IPath resourcePath = resource.getFullPath();
        IClasspathEntry[] iClasspathEntryArray = classpath = javaProject.getRawClasspath();
        int n = classpath.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathEntry entry = iClasspathEntryArray[n2];
            if (entry.getEntryKind() == 3) {
                IPath entryPath = null;
                if (isSource) {
                    entryPath = entry.getPath().makeAbsolute();
                } else {
                    entryPath = entry.getOutputLocation();
                    IPath iPath = entryPath = entryPath == null ? projectOutputPath : entryPath.makeAbsolute();
                }
                if (entryPath.isPrefixOf(resourcePath)) {
                    resultPath = resourcePath.removeFirstSegments(entryPath.segmentCount());
                    break;
                }
            }
            ++n2;
        }
        return resultPath;
    }

    public static IClasspathAttribute getJavadocAttribute(IClasspathEntry entry) {
        int index = Utils.getJavadocAttributeIndex(entry);
        return index == -1 ? null : entry.getExtraAttributes()[index];
    }

    public static int getJavadocAttributeIndex(IClasspathEntry entry) {
        int index = -1;
        IClasspathAttribute[] attributes = entry.getExtraAttributes();
        int i = 0;
        while (i < attributes.length) {
            IClasspathAttribute attribute = attributes[i];
            if (attribute.getName().equals("javadoc_location")) {
                index = i;
                break;
            }
            ++i;
        }
        return index;
    }

    public static String[] getJavaProjectSourceDirectories(IJavaProject javaProject) throws CoreException {
        LinkedList<String> paths = new LinkedList<String>();
        IClasspathEntry[] classpathEntries = null;
        IClasspathEntry[] iClasspathEntryArray = classpathEntries = javaProject.getResolvedClasspath(true);
        int n = classpathEntries.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathEntry entry = iClasspathEntryArray[n2];
            if (entry.getEntryKind() == 3 && entry.getContentKind() == 1) {
                IPath path = entry.getPath();
                paths.add(path.lastSegment());
            }
            ++n2;
        }
        return paths.toArray(new String[paths.size()]);
    }

    public static String getKeyringURL(IProject project) {
        StringBuffer buf = new StringBuffer();
        buf.append("projects.mtj/");
        String projectName = project.getName();
        int nLength = projectName.length();
        int i = 0;
        while (i < nLength) {
            char c = projectName.charAt(i);
            if (Character.isLetterOrDigit(c) || c == '.') {
                buf.append(c);
            } else {
                buf.append('%');
                String hexString = Integer.toHexString(c);
                if ((hexString.length() & 1) != 0) {
                    buf.append('0');
                }
                buf.append(hexString);
            }
            ++i;
        }
        return buf.toString();
    }

    public static List<IType> getMidletTypesInProject(IProgressMonitor monitor, IJavaProject project) {
        HashSet<IType> result = new HashSet<IType>(5);
        try {
            IType midlet = project.findType("javax.microedition.midlet.MIDlet");
            ITypeHierarchy hierarchy = midlet.newTypeHierarchy(project, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            IType[] types = hierarchy.getAllSubtypes(midlet);
            int length = types.length;
            if (length != 0) {
                int i = 0;
                while (i < length) {
                    if (!types[i].isBinary()) {
                        result.add(types[i]);
                    }
                    ++i;
                }
            }
        }
        catch (JavaModelException javaModelException) {}
        monitor.done();
        return new ArrayList<IType>(result);
    }

    public static ILaunch getNewLaunch(String configName) throws CoreException {
        return new Launch(Utils.getNewLaunchConfiguration(configName), "run", null);
    }

    public static ILaunchConfiguration getNewLaunchConfiguration(String name) throws CoreException {
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType configType = launchManager.getLaunchConfigurationType(IJavaLaunchConfigurationConstants.ID_JAVA_APPLICATION);
        ILaunchConfigurationWorkingCopy config = configType.newInstance(null, name);
        config.setAttribute(PRIVATE_CONFIGURATION, true);
        return config;
    }

    public static Object getPathTarget(IPath path) {
        Object target = null;
        IWorkspaceRoot root = MTJCore.getWorkspace().getRoot();
        target = root.findMember(path);
        if (target == null) {
            File externalFile = new File(path.toOSString());
            target = externalFile != null && externalFile.isFile() ? externalFile : null;
        }
        return target;
    }

    public static File getPathTargetFile(IPath path) throws CoreException {
        File entryFile = null;
        Object pathTarget = Utils.getPathTarget(path);
        if (pathTarget instanceof IResource) {
            entryFile = ((IResource)pathTarget).getLocation().toFile();
        } else if (pathTarget instanceof File) {
            entryFile = (File)pathTarget;
        }
        return entryFile;
    }

    public static int getProcessOutput(String name, String[] commandLine, StringBuffer stdout, StringBuffer stderr) throws CoreException {
        int result = 0;
        String os = Platform.getOS();
        if (os.toLowerCase().contains("win32")) {
            IProcess process = Utils.launchApplication(commandLine, null, null, name, name);
            IStreamsProxy proxy = process.getStreamsProxy();
            Utils.collectStreamContents(proxy.getOutputStreamMonitor(), stdout);
            Utils.collectStreamContents(proxy.getErrorStreamMonitor(), stderr);
            while (!process.isTerminated()) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
            result = process.getExitValue();
        } else {
            Process execProcess = Utils.exec(commandLine, null, null);
            try {
                result = execProcess.waitFor();
            }
            catch (InterruptedException interruptedException) {}
            Utils.readOutput(execProcess.getInputStream(), stdout);
            Utils.readOutput(execProcess.getErrorStream(), stderr);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void collectStreamContents(IStreamMonitor monitor, StringBuffer target) {
        IStreamMonitor iStreamMonitor = monitor;
        synchronized (iStreamMonitor) {
            String collected = monitor.getContents();
            if (collected != null) {
                target.append(collected);
            }
            monitor.addListener((IStreamListener)new StreamListener(target));
        }
    }

    private static void readOutput(InputStream inputStream, StringBuffer buffer) throws CoreException {
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
            String line = null;
            while ((line = reader.readLine()) != null) {
                buffer.append(line).append("\n");
            }
        }
        catch (IOException e) {
            throw new CoreException(MTJStatusHandler.newStatus(4, -999, e.getMessage(), e));
        }
    }

    public static String getQualifiedClassName(IType type) {
        String classname = null;
        classname = type instanceof BinaryType ? Utils.getQualifiedClassName((BinaryType)type) : type.getFullyQualifiedName();
        return classname;
    }

    public static IJavaProject[] getRequiredProjects(IJavaProject javaProject) throws JavaModelException {
        String[] names;
        ArrayList<IJavaProject> required = new ArrayList<IJavaProject>();
        String[] stringArray = names = javaProject.getRequiredProjectNames();
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            IProject project = MTJCore.getWorkspace().getRoot().getProject(name);
            if (project.exists() && project.isOpen()) {
                required.add(JavaCore.create((IProject)project));
            }
            ++n2;
        }
        return required.toArray(new IJavaProject[required.size()]);
    }

    public static Object getResolvedClasspathEntry(IClasspathEntry entry) {
        IClasspathEntry resolved = JavaCore.getResolvedClasspathEntry((IClasspathEntry)entry);
        return Utils.getPathTarget(resolved.getPath());
    }

    public static final File getResolvedClasspathEntryFile(IClasspathEntry entry) throws CoreException {
        IClasspathEntry resolved = JavaCore.getResolvedClasspathEntry((IClasspathEntry)entry);
        return Utils.getPathTargetFile(resolved.getPath());
    }

    public static String getStandardOutput(String name, String[] commandLine) throws CoreException {
        return Utils.getStandardOutput(name, commandLine, null);
    }

    public static String getStandardOutput(String name, String[] commandLine, File workingDirectory) throws CoreException {
        IProcess process = Utils.launchApplication(commandLine, workingDirectory, null, name, name);
        IStreamsProxy proxy = process.getStreamsProxy();
        while (!process.isTerminated()) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        return proxy.getOutputStreamMonitor().getContents();
    }

    public static String getStreamContent(InputStream stream) {
        String result = null;
        StringBuffer buffer = new StringBuffer();
        int c = -1;
        try {
            while ((c = stream.read()) != -1) {
                buffer.append((char)c);
            }
            result = buffer.toString();
        }
        catch (IOException iOException) {}
        return result;
    }

    public static Document getTextDocument(InputStream in) {
        String result;
        block8: {
            ByteArrayOutputStream output = null;
            result = null;
            try {
                int count;
                output = new ByteArrayOutputStream();
                byte[] buffer = new byte[1024];
                while ((count = in.read(buffer, 0, buffer.length)) > 0) {
                    output.write(buffer, 0, count);
                }
                result = output.toString("UTF-8");
                output.close();
                output = null;
                in.close();
                in = null;
            }
            catch (IOException iOException) {
                if (output != null) {
                    try {
                        output.close();
                    }
                    catch (IOException iOException2) {}
                }
                if (in == null) break block8;
                try {
                    in.close();
                }
                catch (IOException iOException3) {}
            }
        }
        return result == null ? null : new Document(result);
    }

    public static org.w3c.dom.Document getXmlDocument(IPath path) throws IOException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            return builder.parse(path.toFile());
        }
        catch (Exception exception) {
            throw new IOException(Messages.Utils_xml_parse_error);
        }
    }

    public static boolean isFileSystemCaseSensitive() {
        if (!caseSensitivityChecked) {
            String urlString;
            URL url;
            caseSensitivityChecked = true;
            Location location = Platform.getInstallLocation();
            if (location != null && (url = location.getURL()) != null && (urlString = url.toString()).startsWith("file:/")) {
                caseSensitiveFileSystem = !new File(urlString = urlString.substring("file:/".length()).toUpperCase()).exists();
            }
        }
        return caseSensitiveFileSystem;
    }

    public static boolean isMidlet(IType type, IProgressMonitor monitor) throws JavaModelException {
        boolean isMidlet = false;
        if (type != null) {
            IJavaProject javaProject = type.getJavaProject();
            if (!type.exists() && type.isBinary()) {
                String classname = Utils.getQualifiedClassName(type);
                if (classname != null) {
                    IType sourceType = javaProject.findType(classname);
                    isMidlet = Utils.isMidlet(sourceType, monitor);
                }
            } else {
                ITypeHierarchy typeHierarchy = type.newSupertypeHierarchy(monitor);
                IType midletType = javaProject.findType("javax.microedition.midlet.MIDlet");
                isMidlet = midletType != null && typeHierarchy.contains(midletType);
            }
        }
        return isMidlet;
    }

    public static IProcess launchApplication(String[] commandLine, File workingDirectory, String[] environment, String configName, String label) throws CoreException {
        Process execProcess = Utils.exec(commandLine, workingDirectory, environment);
        Launch launch = new Launch(Utils.getNewLaunchConfiguration(configName), "run", null);
        IProcess process = DebugPlugin.newProcess((ILaunch)launch, (Process)execProcess, (String)label);
        Utils.dumpCommandLine(commandLine);
        return process;
    }

    public static void switchAutoBuild(boolean state) throws CoreException {
        IWorkspace workspace = MTJCore.getWorkspace();
        IWorkspaceDescription description = workspace.getDescription();
        description.setAutoBuilding(state);
        workspace.setDescription(description);
    }

    public static boolean isAutoBuilding() {
        IWorkspace workspace = MTJCore.getWorkspace();
        IWorkspaceDescription description = workspace.getDescription();
        return description.isAutoBuilding();
    }

    private static void addFileEntryToArchive(ZipOutputStream zos, int prefixLength, File file) throws IOException {
        ZipEntry entry = Utils.getEntryForFile(file, prefixLength);
        zos.putNextEntry(entry);
        FileInputStream fis = new FileInputStream(file);
        try {
            Utils.copyInputToOutput(fis, zos);
        }
        catch (Throwable throwable) {
            zos.closeEntry();
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        zos.closeEntry();
        if (fis != null) {
            try {
                fis.close();
            }
            catch (IOException iOException) {}
        }
    }

    private static void addFolderToArchive(ZipOutputStream zos, int prefixLength, File srcFolder) throws IOException {
        File[] files;
        File[] fileArray = files = srcFolder.listFiles();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isDirectory()) {
                Utils.addFolderToArchive(zos, prefixLength, file);
            } else {
                Utils.addFileEntryToArchive(zos, prefixLength, file);
            }
            ++n2;
        }
    }

    private static ZipEntry getEntryForFile(File file, int prefixLength) {
        String fileString = file.getAbsolutePath();
        String entryName = fileString.substring(prefixLength).replace('\\', '/');
        ZipEntry entry = new ZipEntry(entryName);
        entry.setSize(file.length());
        entry.setTime(file.lastModified());
        return entry;
    }

    private static String getQualifiedClassName(BinaryType type) {
        IPackageFragment javaElement = type.getPackageFragment();
        StringBuffer name = new StringBuffer(type.getElementName());
        while (javaElement.getElementType() != 2) {
            String elementName = javaElement.getElementName();
            if (elementName != null && elementName.length() > 0) {
                name.insert(0, '.').insert(0, elementName);
            }
            javaElement = javaElement.getParent();
        }
        return name.toString();
    }

    public static IResource[] getSourceFolders(IJavaProject javaProject) {
        ArrayList<IProject> sources = new ArrayList<IProject>();
        try {
            IClasspathEntry[] classpath;
            IClasspathEntry[] iClasspathEntryArray = classpath = javaProject.getRawClasspath();
            int n = classpath.length;
            int n2 = 0;
            while (n2 < n) {
                IClasspathEntry entry = iClasspathEntryArray[n2];
                if (entry.getEntryKind() == 3) {
                    IProject project;
                    IPath entryPath = entry.getPath();
                    IProject resource = project = javaProject.getProject();
                    if (entryPath.segmentCount() > 1) {
                        entryPath = entryPath.removeFirstSegments(1);
                        resource = project.getFolder(entryPath);
                    }
                    if (resource.exists()) {
                        sources.add(resource);
                    }
                }
                ++n2;
            }
        }
        catch (JavaModelException e) {
            MTJLogger.log(4, e);
        }
        return sources.toArray(new IResource[sources.size()]);
    }

    private Utils() {
    }

    public static void setResourcesAsDerived(IContainer container) throws CoreException {
        if (container.exists()) {
            IResource[] resources;
            container.setDerived(true, null);
            IResource[] iResourceArray = resources = container.members();
            int n = resources.length;
            int n2 = 0;
            while (n2 < n) {
                IResource resource = iResourceArray[n2];
                if (resource instanceof IContainer) {
                    Utils.setResourcesAsDerived((IContainer)resource);
                } else {
                    resource.setDerived(true, null);
                }
                ++n2;
            }
        }
    }

    public static boolean isValidFolderName(String folderName) {
        IWorkspace workspace = MTJCore.getWorkspace();
        IStatus result = workspace.validateName(folderName, 2);
        return result.isOK();
    }

    public static boolean isValidFileName(String fileName) {
        IWorkspace workspace = MTJCore.getWorkspace();
        IStatus result = workspace.validateName(fileName, 1);
        return result.isOK();
    }

    public static void createErrorMarker(IResource resource, String message) throws CoreException {
        IMarker marker = resource.createMarker("org.eclipse.mtj.core.problem");
        marker.setAttribute("message", (Object)message);
        marker.setAttribute("severity", 2);
    }

    public static void removeAllErrorMarkers(IResource resource) throws CoreException {
        resource.deleteMarkers("org.eclipse.mtj.core.problem", true, 0);
    }

    public static IPath makePathRelativeToOutputLocation(IPath path, List<IPath> outputLocations, IPath defaultValue) {
        for (IPath outputLocation : outputLocations) {
            int commonSegnmentCount = path.matchingFirstSegments(outputLocation);
            if (commonSegnmentCount != outputLocation.segmentCount()) continue;
            return path.removeFirstSegments(commonSegnmentCount);
        }
        return defaultValue;
    }

    public static List<IPath> getOutputLocations(IMTJProject mtjProject, boolean considerDependentProjects) {
        return Utils.collectOutputLocations(mtjProject.getJavaProject(), new HashSet<IJavaProject>(), considerDependentProjects);
    }

    private static List<IPath> collectOutputLocations(IJavaProject javaProject, HashSet<IJavaProject> processed, boolean considerDependentProjects) {
        ArrayList<IPath> result = new ArrayList<IPath>();
        if (processed.add(javaProject)) {
            IPath projectOutputLocation;
            try {
                projectOutputLocation = javaProject.getOutputLocation();
            }
            catch (JavaModelException javaModelException) {
                projectOutputLocation = null;
            }
            if (projectOutputLocation != null) {
                result.add(projectOutputLocation);
            }
            try {
                IClasspathEntry[] rawClasspath = javaProject.getRawClasspath();
                if (rawClasspath != null) {
                    IClasspathEntry[] iClasspathEntryArray = rawClasspath;
                    int n = rawClasspath.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IPath outputLocation;
                        IClasspathEntry entry = iClasspathEntryArray[n2];
                        if (entry.getEntryKind() == 2 && considerDependentProjects) {
                            IPath projectPath = entry.getPath();
                            IProject project = (IProject)MTJCore.getWorkspace().getRoot().findMember(projectPath);
                            if (project != null) {
                                result.addAll(Utils.collectOutputLocations(JavaCore.create((IProject)project), processed, considerDependentProjects));
                            }
                        } else if (entry.getEntryKind() == 3 && (outputLocation = entry.getOutputLocation()) != null) {
                            result.add(outputLocation);
                        }
                        ++n2;
                    }
                }
            }
            catch (JavaModelException javaModelException) {}
        }
        return result;
    }

    private static class StreamListener
    implements IStreamListener {
        private StringBuffer buf;

        public StreamListener(StringBuffer buf) {
            this.buf = buf;
        }

        public void streamAppended(String text, IStreamMonitor monitor) {
            if (this.buf != null) {
                this.buf.append(text);
            }
        }
    }
}

