/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.util.migration;

import org.eclipse.mtj.core.MTJCore;
import org.eclipse.mtj.internal.core.util.migration.AbstractMigration;
import org.eclipse.mtj.internal.core.util.xml.DocumentAdapter;
import org.eclipse.mtj.internal.core.util.xml.DocumentVisitor;
import org.eclipse.mtj.internal.core.util.xml.XMLUtils;
import org.osgi.framework.Version;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DeviceRegistryMigration
extends AbstractMigration {
    public Document migrate(Document document) {
        this.migrated = false;
        if (document == null) {
            return null;
        }
        Element rootXmlElement = document.getDocumentElement();
        if (!rootXmlElement.getNodeName().equals("deviceRegistry")) {
            return null;
        }
        Version version = XMLUtils.getVersion(document);
        if (version.compareTo(new Version(MTJCore.getMTJCoreVersion())) < 0) {
            DocumentAdapter documentAdapter = new DocumentAdapter(document);
            documentAdapter.accept(new ConversionDocumentVisitor());
            String pluginVersion = MTJCore.getMTJCoreVersion();
            Version newVersion = new Version(pluginVersion);
            rootXmlElement.setAttribute("version", newVersion.toString());
            this.migrated = true;
        }
        return document;
    }

    private final class ConversionDocumentVisitor
    implements DocumentVisitor {
        private ConversionDocumentVisitor() {
        }

        public void visitElement(Element element) {
            String name = element.getNodeName();
            if (name.startsWith("device") && !name.equals("deviceRegistry") && !name.equals("deviceCount") && !name.equals("deviceProperties")) {
                Attr attr = element.getAttributeNode("bundle");
                if (attr != null) {
                    String bundleName = attr.getValue();
                    if (bundleName.equals("org.eclipse.mtj.toolkit.uei")) {
                        element.setAttribute("class", "org.eclipse.mtj.internal.toolkit.uei.UEIDeviceInternal");
                    } else if (bundleName.equals("org.eclipse.mtj.toolkit.microemu")) {
                        element.setAttribute("class", "org.eclipse.mtj.internal.toolkit.microemu.MicroEmuDevice");
                    } else if (bundleName.equals("org.eclipse.mtj.toolkit.mpowerplayer")) {
                        element.setAttribute("class", "org.eclipse.mtj.internal.toolkit.mpowerplayer.MpowerplayerDevice");
                    } else if (bundleName.equals("org.eclipse.mtj.toolkit.me4se")) {
                        element.setAttribute("class", "org.eclipse.mtj.examples.toolkits.me4se.ME4SEDevice");
                    } else if (bundleName.equals("org.eclipse.mtj.toolkit.motorola")) {
                        element.setAttribute("class", "org.eclipse.mtj.examples.toolkits.motorola.MotorolaDevice");
                    }
                }
            } else if (name.equalsIgnoreCase("classpath")) {
                element.setAttribute("class", "org.eclipse.mtj.internal.core.sdk.device.DeviceClasspath");
            } else if (name.startsWith("entry")) {
                String className = element.getAttribute("class");
                if (className.endsWith(".API")) {
                    element.setAttribute("class", "org.eclipse.mtj.internal.core.sdk.device.midp.MIDPAPI");
                } else if (className.endsWith(".Library")) {
                    element.setAttribute("class", "org.eclipse.mtj.internal.core.sdk.device.midp.MIDPLibrary");
                }
            } else if (name.equals("preverifier") || name.equals("defaultPreverifier")) {
                element.setAttribute("class", "org.eclipse.mtj.internal.core.build.preverifier.StandardPreverifier");
            } else if (name.equals("parameters")) {
                element.setAttribute("class", "org.eclipse.mtj.internal.core.build.preverifier.StandardPreverifierParameters");
            }
        }
    }
}

