/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.jmunit.ui.actions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.mtj.internal.core.util.MTJStatusHandler;
import org.eclipse.mtj.internal.jmunit.core.api.JMUnitTestFinder;
import org.eclipse.mtj.internal.jmunit.core.api.TestSuiteWriter;
import org.eclipse.mtj.internal.jmunit.ui.actions.Messages;
import org.eclipse.mtj.internal.jmunit.ui.wizards.testsuite.SuiteClassesContentProvider;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.dialogs.ListSelectionDialog;

public class UpdateJMUnitTestSuiteAction
implements IObjectActionDelegate {
    private ICompilationUnit testSuite;

    public static IType[] findAllTests(IPackageFragmentRoot[] packageFragmentRoots, IType[] exclusions) throws CoreException {
        HashSet<IType> result = new HashSet<IType>();
        JMUnitTestFinder finder = null;
        IPackageFragmentRoot[] iPackageFragmentRootArray = packageFragmentRoots;
        int n = packageFragmentRoots.length;
        int n2 = 0;
        while (n2 < n) {
            IPackageFragmentRoot packageFragmentRoot = iPackageFragmentRootArray[n2];
            if (packageFragmentRoot.getKind() == 1) {
                finder = new JMUnitTestFinder("jmunit.framework.cldc11.TestCase");
                finder.findTestsInContainer((IJavaElement)packageFragmentRoot, result, null);
            }
            ++n2;
        }
        iPackageFragmentRootArray = exclusions;
        n = exclusions.length;
        n2 = 0;
        while (n2 < n) {
            IPackageFragmentRoot excluded = iPackageFragmentRootArray[n2];
            if (result.contains(excluded)) {
                result.remove(excluded);
            }
            ++n2;
        }
        return result.toArray(new IType[result.size()]);
    }

    public void run(IAction action) {
        try {
            IType clazzType = this.testSuite.findPrimaryType();
            ITypeHierarchy hierarchy = clazzType.newSupertypeHierarchy((IProgressMonitor)new NullProgressMonitor());
            IType superType = hierarchy.getSuperclass(clazzType);
            if (superType.getFullyQualifiedName().equals("jmunit.framework.cldc11.TestSuite")) {
                TestsContentProvider contentProvider = new TestsContentProvider(new IType[]{clazzType});
                JavaElementLabelProvider labelProvider = new JavaElementLabelProvider(JavaElementLabelProvider.SHOW_DEFAULT);
                ListSelectionDialog dialog = new ListSelectionDialog(Display.getDefault().getActiveShell(), (Object)this.testSuite.getJavaProject(), (IStructuredContentProvider)contentProvider, (ILabelProvider)labelProvider, Messages.UpdateJMUnitTestSuiteAction_UpdateTestSuiteTests);
                dialog.setTitle(Messages.UpdateJMUnitTestSuiteAction_UpdateTestSuite);
                dialog.setInitialSelections((Object[])this.findSuiteTests(clazzType));
                int result = dialog.open();
                if (result == 0) {
                    this.updateTestSuiteSetupMethod(clazzType, dialog.getResult());
                }
            }
        }
        catch (CoreException e) {
            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)Messages.UpdateJMUnitTestSuiteAction_ErrorUpdatingTestSuite, (String)e.getMessage());
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        StructuredSelection structuredSelection;
        Object element;
        if (selection instanceof StructuredSelection && (element = (structuredSelection = (StructuredSelection)selection).getFirstElement()) instanceof ICompilationUnit) {
            this.testSuite = (ICompilationUnit)element;
        }
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    private String buildSetupSuiteMarkerExp() {
        StringBuffer regularExp = new StringBuffer();
        regularExp.append("//");
        regularExp.append("(\\s)*");
        regularExp.append("JMUnit-BEGIN");
        regularExp.append("(.)*");
        regularExp.append("//");
        regularExp.append("(\\s)*");
        regularExp.append("JMUnit-END");
        return regularExp.toString();
    }

    private IType[] findSuiteTests(IType clazzType) throws CoreException {
        IType[] existingTypes = new IType[]{};
        IMethod method = clazzType.getMethod("setupSuite", new String[0]);
        if (method != null) {
            Pattern pattern = Pattern.compile(this.buildSetupSuiteMarkerExp(), 40);
            Matcher matcher = pattern.matcher(method.getSource());
            if (matcher.find()) {
                StringBuffer buffer = new StringBuffer(matcher.group());
                int start = 0;
                int end = 0;
                end = buffer.indexOf("JMUnit-BEGIN") + "JMUnit-BEGIN".length();
                buffer.delete(0, end);
                start = buffer.indexOf("//");
                end = buffer.indexOf("JMUnit-END", start) + "JMUnit-END".length();
                buffer.delete(start, end);
                existingTypes = this.parseSetupSuite(buffer, clazzType.getJavaProject());
            } else {
                MTJStatusHandler.throwCoreException((int)4, (int)-999, (String)Messages.UpdateJMUnitTestSuiteAction_MarkersNotFound);
            }
        }
        return existingTypes;
    }

    private IType[] parseSetupSuite(StringBuffer buffer, IJavaProject javaProject) throws CoreException {
        String[] adds;
        LinkedList<String> testNames = new LinkedList<String>();
        LinkedList<IType> testTypes = new LinkedList<IType>();
        String region = buffer.toString();
        String[] stringArray = adds = region.split(System.getProperty("line.separator"));
        int n = adds.length;
        int n2 = 0;
        while (n2 < n) {
            String add2 = stringArray[n2];
            String add = add2.trim();
            if (add.length() > 0) {
                int start = add.indexOf("new ") + "new ".length();
                int end = add.indexOf("(", start);
                String className = add.substring(start, end);
                testNames.add(className);
            }
            ++n2;
        }
        IType[] availableTests = UpdateJMUnitTestSuiteAction.findAllTests(javaProject.getPackageFragmentRoots(), new IType[0]);
        block1: for (String test : testNames) {
            IType[] iTypeArray = availableTests;
            int n3 = availableTests.length;
            int n4 = 0;
            while (n4 < n3) {
                IType type = iTypeArray[n4];
                if (type.getElementName().equals(test)) {
                    testTypes.add(type);
                    continue block1;
                }
                ++n4;
            }
        }
        return testTypes.toArray(new IType[testTypes.size()]);
    }

    private void updateTestSuiteSetupMethod(IType clazzType, Object[] tests) throws CoreException {
        LinkedList<String> classNames = new LinkedList<String>();
        IType[] oldTests = this.findSuiteTests(clazzType);
        IType[] newTests = new IType[tests.length];
        int count = 0;
        while (count < tests.length) {
            newTests[count] = (IType)tests[count];
            ++count;
        }
        IType[] importTypes = this.returnImports(oldTests, newTests);
        IType[] removeTypes = this.returnImports(newTests, oldTests);
        Object[] objectArray = importTypes;
        int n = importTypes.length;
        int n2 = 0;
        while (n2 < n) {
            IType iType = objectArray[n2];
            if (!iType.getPackageFragment().getElementName().equals(clazzType.getPackageFragment().getElementName())) {
                String importName = iType.getFullyQualifiedName();
                clazzType.getCompilationUnit().createImport(importName, null, (IProgressMonitor)new NullProgressMonitor());
            }
            ++n2;
        }
        objectArray = clazzType.getCompilationUnit().getImports();
        n = objectArray.length;
        n2 = 0;
        while (n2 < n) {
            IType imported = objectArray[n2];
            IType[] iTypeArray = removeTypes;
            int n3 = removeTypes.length;
            int n4 = 0;
            while (n4 < n3) {
                IType remove = iTypeArray[n4];
                if (imported.getElementName().equals(remove.getFullyQualifiedName())) {
                    clazzType.getCompilationUnit().getImport(imported.getElementName()).delete(true, (IProgressMonitor)new NullProgressMonitor());
                    break;
                }
                ++n4;
            }
            ++n2;
        }
        objectArray = tests;
        n = tests.length;
        n2 = 0;
        while (n2 < n) {
            IType object;
            IType type = object = objectArray[n2];
            classNames.add(type.getElementName());
            ++n2;
        }
        TestSuiteWriter suiteWriter = new TestSuiteWriter(clazzType, clazzType.getElementName());
        suiteWriter.updateSetupSuiteMethod(classNames.toArray(new String[classNames.size()]), (IProgressMonitor)new NullProgressMonitor());
    }

    private IType[] returnImports(IType[] oldTests, IType[] newTests) {
        ArrayList<IType> result = new ArrayList<IType>();
        IType[] iTypeArray = newTests;
        int n = newTests.length;
        int n2 = 0;
        while (n2 < n) {
            IType newType = iTypeArray[n2];
            boolean change = true;
            IType[] iTypeArray2 = oldTests;
            int n3 = oldTests.length;
            int n4 = 0;
            while (n4 < n3) {
                IType oldtype = iTypeArray2[n4];
                if (oldtype.getElementName().equals(newType.getElementName())) {
                    change = false;
                    break;
                }
                ++n4;
            }
            if (change) {
                result.add(newType);
            }
            ++n2;
        }
        return result.toArray(new IType[0]);
    }

    private class TestsContentProvider
    extends SuiteClassesContentProvider {
        private IType[] exclusion;

        public TestsContentProvider(IType[] exclusion) {
            this.exclusion = exclusion == null ? new IType[0] : exclusion;
        }

        public void dispose() {
        }

        public Object[] getElements(Object inputElement) {
            Object[] result = super.getElements(inputElement);
            ArrayList<Object> types = new ArrayList<Object>(Arrays.asList(result));
            IType[] iTypeArray = this.exclusion;
            int n = this.exclusion.length;
            int n2 = 0;
            while (n2 < n) {
                IType excluded = iTypeArray[n2];
                if (types.contains(excluded)) {
                    types.remove(excluded);
                }
                ++n2;
            }
            return result;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }
}

